// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.transform

import aws.sdk.kotlin.runtime.http.setAseErrorMetadata
import aws.sdk.kotlin.runtime.http.withPayload
import aws.sdk.kotlin.runtime.protocol.json.RestJsonErrorDeserializer
import aws.sdk.kotlin.services.robomaker.model.DeploymentApplicationConfig
import aws.sdk.kotlin.services.robomaker.model.DeploymentConfig
import aws.sdk.kotlin.services.robomaker.model.DeploymentJobErrorCode
import aws.sdk.kotlin.services.robomaker.model.DeploymentStatus
import aws.sdk.kotlin.services.robomaker.model.DescribeDeploymentJobResponse
import aws.sdk.kotlin.services.robomaker.model.RoboMakerException
import aws.sdk.kotlin.services.robomaker.model.RobotDeployment
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.http.response.HttpResponse
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf


internal class DescribeDeploymentJobOperationDeserializer: HttpDeserialize<DescribeDeploymentJobResponse> {

    override suspend fun deserialize(context: ExecutionContext, response: HttpResponse): DescribeDeploymentJobResponse {
        if (!response.status.isSuccess()) {
            throwDescribeDeploymentJobError(context, response)
        }
        val builder = DescribeDeploymentJobResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeDescribeDeploymentJobOperationBody(builder, payload)
        }
        return builder.build()
    }
}

private suspend fun throwDescribeDeploymentJobError(context: ExecutionContext, response: HttpResponse): kotlin.Nothing {
    val payload = response.body.readAll()
    val wrappedResponse = response.withPayload(payload)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(response.headers, payload)
    } catch (ex: Exception) {
        throw RoboMakerException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedResponse, null)
        }
    }

    val ex = when(errorDetails.code) {
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedResponse)
        "InvalidParameterException" -> InvalidParameterExceptionDeserializer().deserialize(context, wrappedResponse)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedResponse)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedResponse)
        else -> RoboMakerException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDeploymentJobOperationBody(builder: DescribeDeploymentJobResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val ARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("arn"))
    val CREATEDAT_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("createdAt"))
    val DEPLOYMENTAPPLICATIONCONFIGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("deploymentApplicationConfigs"))
    val DEPLOYMENTCONFIG_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Struct, JsonSerialName("deploymentConfig"))
    val FAILURECODE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureCode"))
    val FAILUREREASON_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("failureReason"))
    val FLEET_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("fleet"))
    val ROBOTDEPLOYMENTSUMMARY_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("robotDeploymentSummary"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("status"))
    val TAGS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Map, JsonSerialName("tags"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(ARN_DESCRIPTOR)
        field(CREATEDAT_DESCRIPTOR)
        field(DEPLOYMENTAPPLICATIONCONFIGS_DESCRIPTOR)
        field(DEPLOYMENTCONFIG_DESCRIPTOR)
        field(FAILURECODE_DESCRIPTOR)
        field(FAILUREREASON_DESCRIPTOR)
        field(FLEET_DESCRIPTOR)
        field(ROBOTDEPLOYMENTSUMMARY_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TAGS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                ARN_DESCRIPTOR.index -> builder.arn = deserializeString()
                CREATEDAT_DESCRIPTOR.index -> builder.createdAt = deserializeString().let { Instant.fromEpochSeconds(it) }
                DEPLOYMENTAPPLICATIONCONFIGS_DESCRIPTOR.index -> builder.deploymentApplicationConfigs =
                    deserializer.deserializeList(DEPLOYMENTAPPLICATIONCONFIGS_DESCRIPTOR) {
                        val col0 = mutableListOf<DeploymentApplicationConfig>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeDeploymentApplicationConfigDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                DEPLOYMENTCONFIG_DESCRIPTOR.index -> builder.deploymentConfig = deserializeDeploymentConfigDocument(deserializer)
                FAILURECODE_DESCRIPTOR.index -> builder.failureCode = deserializeString().let { DeploymentJobErrorCode.fromValue(it) }
                FAILUREREASON_DESCRIPTOR.index -> builder.failureReason = deserializeString()
                FLEET_DESCRIPTOR.index -> builder.fleet = deserializeString()
                ROBOTDEPLOYMENTSUMMARY_DESCRIPTOR.index -> builder.robotDeploymentSummary =
                    deserializer.deserializeList(ROBOTDEPLOYMENTSUMMARY_DESCRIPTOR) {
                        val col0 = mutableListOf<RobotDeployment>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeRobotDeploymentDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { DeploymentStatus.fromValue(it) }
                TAGS_DESCRIPTOR.index -> builder.tags =
                    deserializer.deserializeMap(TAGS_DESCRIPTOR) {
                        val map0 = mutableMapOf<String, String>()
                        while (hasNextEntry()) {
                            val k0 = key()
                            val v0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            map0[k0] = v0
                        }
                        map0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
