// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.time.Instant

/**
 * Information about a world generator job.
 */
public class WorldGenerationJobSummary private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the world generator job.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The time, in milliseconds since the epoch, when the world generator job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The number of worlds that failed.
     */
    public val failedWorldCount: kotlin.Int = builder.failedWorldCount
    /**
     * The status of the world generator job:
     *
     * ## Pending
     * The world generator job request is pending.
     *
     * ## Running
     * The world generator job is running.
     *
     * ## Completed
     * The world generator job completed.
     *
     * ## Failed
     * The world generator job failed. See `failureCode` for more information.
     *
     * ## PartialFailed
     * Some worlds did not generate.
     *
     * ## Canceled
     * The world generator job was cancelled.
     *
     * ## Canceling
     * The world generator job is being cancelled.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobStatus? = builder.status
    /**
     * The number of worlds that were generated.
     */
    public val succeededWorldCount: kotlin.Int = builder.succeededWorldCount
    /**
     * The Amazon Resource Name (arn) of the world template.
     */
    public val template: kotlin.String? = builder.template
    /**
     * Information about the world count.
     */
    public val worldCount: aws.sdk.kotlin.services.robomaker.model.WorldCount? = builder.worldCount

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("WorldGenerationJobSummary(")
        append("arn=$arn,")
        append("createdAt=$createdAt,")
        append("failedWorldCount=$failedWorldCount,")
        append("status=$status,")
        append("succeededWorldCount=$succeededWorldCount,")
        append("template=$template,")
        append("worldCount=$worldCount")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (failedWorldCount)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (succeededWorldCount)
        result = 31 * result + (template?.hashCode() ?: 0)
        result = 31 * result + (worldCount?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as WorldGenerationJobSummary

        if (arn != other.arn) return false
        if (createdAt != other.createdAt) return false
        if (failedWorldCount != other.failedWorldCount) return false
        if (status != other.status) return false
        if (succeededWorldCount != other.succeededWorldCount) return false
        if (template != other.template) return false
        if (worldCount != other.worldCount) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobSummary = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the world generator job.
         */
        public var arn: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the world generator job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The number of worlds that failed.
         */
        public var failedWorldCount: kotlin.Int = 0
        /**
         * The status of the world generator job:
         *
         * ## Pending
         * The world generator job request is pending.
         *
         * ## Running
         * The world generator job is running.
         *
         * ## Completed
         * The world generator job completed.
         *
         * ## Failed
         * The world generator job failed. See `failureCode` for more information.
         *
         * ## PartialFailed
         * Some worlds did not generate.
         *
         * ## Canceled
         * The world generator job was cancelled.
         *
         * ## Canceling
         * The world generator job is being cancelled.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobStatus? = null
        /**
         * The number of worlds that were generated.
         */
        public var succeededWorldCount: kotlin.Int = 0
        /**
         * The Amazon Resource Name (arn) of the world template.
         */
        public var template: kotlin.String? = null
        /**
         * Information about the world count.
         */
        public var worldCount: aws.sdk.kotlin.services.robomaker.model.WorldCount? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobSummary) : this() {
            this.arn = x.arn
            this.createdAt = x.createdAt
            this.failedWorldCount = x.failedWorldCount
            this.status = x.status
            this.succeededWorldCount = x.succeededWorldCount
            this.template = x.template
            this.worldCount = x.worldCount
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.WorldGenerationJobSummary = WorldGenerationJobSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.WorldCount] inside the given [block]
         */
        public fun worldCount(block: aws.sdk.kotlin.services.robomaker.model.WorldCount.Builder.() -> kotlin.Unit) {
            this.worldCount = aws.sdk.kotlin.services.robomaker.model.WorldCount.invoke(block)
        }
    }
}
