// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class StartSimulationJobBatchResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (arn) of the batch.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * The batch policy.
     */
    public val batchPolicy: aws.sdk.kotlin.services.robomaker.model.BatchPolicy? = builder.batchPolicy
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The time, in milliseconds since the epoch, when the simulation job batch was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * A list of created simulation job request summaries.
     */
    public val createdRequests: List<SimulationJobSummary>? = builder.createdRequests
    /**
     * A list of failed simulation job requests. The request failed to be created into a simulation job. Failed requests do not have a simulation job ID.
     */
    public val failedRequests: List<FailedCreateSimulationJobRequest>? = builder.failedRequests
    /**
     * The failure code if the simulation job batch failed.
     */
    public val failureCode: aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchErrorCode? = builder.failureCode
    /**
     * The reason the simulation job batch failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * A list of pending simulation job requests. These requests have not yet been created into simulation jobs.
     */
    public val pendingRequests: List<SimulationJobRequest>? = builder.pendingRequests
    /**
     * The status of the simulation job batch.
     *
     * ## Pending
     * The simulation job batch request is pending.
     *
     * ## InProgress
     * The simulation job batch is in progress.
     *
     * ## Failed
     * The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like `InternalServiceError`). See `failureCode` and `failureReason` for more information.
     *
     * ## Completed
     * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to `InternalServiceError` and (2) when all created simulation jobs have reached a terminal state (for example, `Completed` or `Failed`).
     *
     * ## Canceled
     * The simulation batch job was cancelled.
     *
     * ## Canceling
     * The simulation batch job is being cancelled.
     *
     * ## Completing
     * The simulation batch job is completing.
     *
     * ## TimingOut
     * The simulation job batch is timing out.
     *
     * If a batch timing out, and there are pending requests that were failing due to an internal failure (like `InternalServiceError`), the batch status will be `Failed`. If there are no such failing request, the batch status will be `TimedOut`.
     *
     * ## TimedOut
     * The simulation batch job timed out.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchStatus? = builder.status
    /**
     * A map that contains tag keys and tag values that are attached to the deployment job batch.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("StartSimulationJobBatchResponse(")
        append("arn=$arn,")
        append("batchPolicy=$batchPolicy,")
        append("clientRequestToken=$clientRequestToken,")
        append("createdAt=$createdAt,")
        append("createdRequests=$createdRequests,")
        append("failedRequests=$failedRequests,")
        append("failureCode=$failureCode,")
        append("failureReason=$failureReason,")
        append("pendingRequests=$pendingRequests,")
        append("status=$status,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (batchPolicy?.hashCode() ?: 0)
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (createdRequests?.hashCode() ?: 0)
        result = 31 * result + (failedRequests?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (pendingRequests?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as StartSimulationJobBatchResponse

        if (arn != other.arn) return false
        if (batchPolicy != other.batchPolicy) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (createdAt != other.createdAt) return false
        if (createdRequests != other.createdRequests) return false
        if (failedRequests != other.failedRequests) return false
        if (failureCode != other.failureCode) return false
        if (failureReason != other.failureReason) return false
        if (pendingRequests != other.pendingRequests) return false
        if (status != other.status) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (arn) of the batch.
         */
        public var arn: kotlin.String? = null
        /**
         * The batch policy.
         */
        public var batchPolicy: aws.sdk.kotlin.services.robomaker.model.BatchPolicy? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the simulation job batch was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * A list of created simulation job request summaries.
         */
        public var createdRequests: List<SimulationJobSummary>? = null
        /**
         * A list of failed simulation job requests. The request failed to be created into a simulation job. Failed requests do not have a simulation job ID.
         */
        public var failedRequests: List<FailedCreateSimulationJobRequest>? = null
        /**
         * The failure code if the simulation job batch failed.
         */
        public var failureCode: aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchErrorCode? = null
        /**
         * The reason the simulation job batch failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * A list of pending simulation job requests. These requests have not yet been created into simulation jobs.
         */
        public var pendingRequests: List<SimulationJobRequest>? = null
        /**
         * The status of the simulation job batch.
         *
         * ## Pending
         * The simulation job batch request is pending.
         *
         * ## InProgress
         * The simulation job batch is in progress.
         *
         * ## Failed
         * The simulation job batch failed. One or more simulation job requests could not be completed due to an internal failure (like `InternalServiceError`). See `failureCode` and `failureReason` for more information.
         *
         * ## Completed
         * The simulation batch job completed. A batch is complete when (1) there are no pending simulation job requests in the batch and none of the failed simulation job requests are due to `InternalServiceError` and (2) when all created simulation jobs have reached a terminal state (for example, `Completed` or `Failed`).
         *
         * ## Canceled
         * The simulation batch job was cancelled.
         *
         * ## Canceling
         * The simulation batch job is being cancelled.
         *
         * ## Completing
         * The simulation batch job is completing.
         *
         * ## TimingOut
         * The simulation job batch is timing out.
         *
         * If a batch timing out, and there are pending requests that were failing due to an internal failure (like `InternalServiceError`), the batch status will be `Failed`. If there are no such failing request, the batch status will be `TimedOut`.
         *
         * ## TimedOut
         * The simulation batch job timed out.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.SimulationJobBatchStatus? = null
        /**
         * A map that contains tag keys and tag values that are attached to the deployment job batch.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchResponse) : this() {
            this.arn = x.arn
            this.batchPolicy = x.batchPolicy
            this.clientRequestToken = x.clientRequestToken
            this.createdAt = x.createdAt
            this.createdRequests = x.createdRequests
            this.failedRequests = x.failedRequests
            this.failureCode = x.failureCode
            this.failureReason = x.failureReason
            this.pendingRequests = x.pendingRequests
            this.status = x.status
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchResponse = StartSimulationJobBatchResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.BatchPolicy] inside the given [block]
         */
        public fun batchPolicy(block: aws.sdk.kotlin.services.robomaker.model.BatchPolicy.Builder.() -> kotlin.Unit) {
            this.batchPolicy = aws.sdk.kotlin.services.robomaker.model.BatchPolicy.invoke(block)
        }
    }
}
