// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model



/**
 * Information about a simulation application configuration.
 */
public class SimulationApplicationConfig private constructor(builder: Builder) {
    /**
     * The application information for the simulation application.
     */
    public val application: kotlin.String? = builder.application
    /**
     * The version of the simulation application.
     */
    public val applicationVersion: kotlin.String? = builder.applicationVersion
    /**
     * The launch configuration for the simulation application.
     */
    public val launchConfig: aws.sdk.kotlin.services.robomaker.model.LaunchConfig? = builder.launchConfig
    /**
     * Information about tools configured for the simulation application.
     */
    public val tools: List<Tool>? = builder.tools
    /**
     * Information about upload configurations for the simulation application.
     */
    public val uploadConfigurations: List<UploadConfiguration>? = builder.uploadConfigurations
    /**
     * A Boolean indicating whether to use default simulation application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is `False`.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val useDefaultTools: kotlin.Boolean? = builder.useDefaultTools
    /**
     * A Boolean indicating whether to use default upload configurations. By default, `.ros` and `.gazebo` files are uploaded when the application terminates and all ROS topics will be recorded.
     *
     * If you set this value, you must specify an `outputLocation`.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val useDefaultUploadConfigurations: kotlin.Boolean? = builder.useDefaultUploadConfigurations
    /**
     * A list of world configurations.
     */
    public val worldConfigs: List<WorldConfig>? = builder.worldConfigs

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.SimulationApplicationConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SimulationApplicationConfig(")
        append("application=$application,")
        append("applicationVersion=$applicationVersion,")
        append("launchConfig=$launchConfig,")
        append("tools=$tools,")
        append("uploadConfigurations=$uploadConfigurations,")
        append("useDefaultTools=$useDefaultTools,")
        append("useDefaultUploadConfigurations=$useDefaultUploadConfigurations,")
        append("worldConfigs=$worldConfigs")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = application?.hashCode() ?: 0
        result = 31 * result + (applicationVersion?.hashCode() ?: 0)
        result = 31 * result + (launchConfig?.hashCode() ?: 0)
        result = 31 * result + (tools?.hashCode() ?: 0)
        result = 31 * result + (uploadConfigurations?.hashCode() ?: 0)
        result = 31 * result + (useDefaultTools?.hashCode() ?: 0)
        result = 31 * result + (useDefaultUploadConfigurations?.hashCode() ?: 0)
        result = 31 * result + (worldConfigs?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SimulationApplicationConfig

        if (application != other.application) return false
        if (applicationVersion != other.applicationVersion) return false
        if (launchConfig != other.launchConfig) return false
        if (tools != other.tools) return false
        if (uploadConfigurations != other.uploadConfigurations) return false
        if (useDefaultTools != other.useDefaultTools) return false
        if (useDefaultUploadConfigurations != other.useDefaultUploadConfigurations) return false
        if (worldConfigs != other.worldConfigs) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.SimulationApplicationConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The application information for the simulation application.
         */
        public var application: kotlin.String? = null
        /**
         * The version of the simulation application.
         */
        public var applicationVersion: kotlin.String? = null
        /**
         * The launch configuration for the simulation application.
         */
        public var launchConfig: aws.sdk.kotlin.services.robomaker.model.LaunchConfig? = null
        /**
         * Information about tools configured for the simulation application.
         */
        public var tools: List<Tool>? = null
        /**
         * Information about upload configurations for the simulation application.
         */
        public var uploadConfigurations: List<UploadConfiguration>? = null
        /**
         * A Boolean indicating whether to use default simulation application tools. The default tools are rviz, rqt, terminal and rosbag record. The default is `False`.
         *
         * This API is no longer supported and will throw an error if used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var useDefaultTools: kotlin.Boolean? = null
        /**
         * A Boolean indicating whether to use default upload configurations. By default, `.ros` and `.gazebo` files are uploaded when the application terminates and all ROS topics will be recorded.
         *
         * If you set this value, you must specify an `outputLocation`.
         *
         * This API is no longer supported and will throw an error if used.
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var useDefaultUploadConfigurations: kotlin.Boolean? = null
        /**
         * A list of world configurations.
         */
        public var worldConfigs: List<WorldConfig>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.SimulationApplicationConfig) : this() {
            this.application = x.application
            this.applicationVersion = x.applicationVersion
            this.launchConfig = x.launchConfig
            this.tools = x.tools
            this.uploadConfigurations = x.uploadConfigurations
            this.useDefaultTools = x.useDefaultTools
            this.useDefaultUploadConfigurations = x.useDefaultUploadConfigurations
            this.worldConfigs = x.worldConfigs
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.SimulationApplicationConfig = SimulationApplicationConfig(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.LaunchConfig] inside the given [block]
         */
        public fun launchConfig(block: aws.sdk.kotlin.services.robomaker.model.LaunchConfig.Builder.() -> kotlin.Unit) {
            this.launchConfig = aws.sdk.kotlin.services.robomaker.model.LaunchConfig.invoke(block)
        }
    }
}
