// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model



/**
 * Information about the progress of a deployment job.
 */
public class ProgressDetail private constructor(builder: Builder) {
    /**
     * The current progress status.
     *
     * ## Validating
     * Validating the deployment.
     *
     * ## DownloadingExtracting
     * Downloading and extracting the bundle on the robot.
     *
     * ## ExecutingPreLaunch
     * Executing pre-launch script(s) if provided.
     *
     * ## Launching
     * Launching the robot application.
     *
     * ## ExecutingPostLaunch
     * Executing post-launch script(s) if provided.
     *
     * ## Finished
     * Deployment is complete.
     */
    public val currentProgress: aws.sdk.kotlin.services.robomaker.model.RobotDeploymentStep? = builder.currentProgress
    /**
     * Estimated amount of time in seconds remaining in the step. This currently only applies to the `Downloading/Extracting` step of the deployment. It is empty for other steps.
     */
    public val estimatedTimeRemainingSeconds: kotlin.Int? = builder.estimatedTimeRemainingSeconds
    /**
     * Precentage of the step that is done. This currently only applies to the `Downloading/Extracting` step of the deployment. It is empty for other steps.
     */
    public val percentDone: kotlin.Float? = builder.percentDone
    /**
     * The Amazon Resource Name (ARN) of the deployment job.
     */
    public val targetResource: kotlin.String? = builder.targetResource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.ProgressDetail = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ProgressDetail(")
        append("currentProgress=$currentProgress,")
        append("estimatedTimeRemainingSeconds=$estimatedTimeRemainingSeconds,")
        append("percentDone=$percentDone,")
        append("targetResource=$targetResource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = currentProgress?.hashCode() ?: 0
        result = 31 * result + (estimatedTimeRemainingSeconds ?: 0)
        result = 31 * result + (percentDone?.hashCode() ?: 0)
        result = 31 * result + (targetResource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ProgressDetail

        if (currentProgress != other.currentProgress) return false
        if (estimatedTimeRemainingSeconds != other.estimatedTimeRemainingSeconds) return false
        if (percentDone != other.percentDone) return false
        if (targetResource != other.targetResource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.ProgressDetail = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The current progress status.
         *
         * ## Validating
         * Validating the deployment.
         *
         * ## DownloadingExtracting
         * Downloading and extracting the bundle on the robot.
         *
         * ## ExecutingPreLaunch
         * Executing pre-launch script(s) if provided.
         *
         * ## Launching
         * Launching the robot application.
         *
         * ## ExecutingPostLaunch
         * Executing post-launch script(s) if provided.
         *
         * ## Finished
         * Deployment is complete.
         */
        public var currentProgress: aws.sdk.kotlin.services.robomaker.model.RobotDeploymentStep? = null
        /**
         * Estimated amount of time in seconds remaining in the step. This currently only applies to the `Downloading/Extracting` step of the deployment. It is empty for other steps.
         */
        public var estimatedTimeRemainingSeconds: kotlin.Int? = null
        /**
         * Precentage of the step that is done. This currently only applies to the `Downloading/Extracting` step of the deployment. It is empty for other steps.
         */
        public var percentDone: kotlin.Float? = null
        /**
         * The Amazon Resource Name (ARN) of the deployment job.
         */
        public var targetResource: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.ProgressDetail) : this() {
            this.currentProgress = x.currentProgress
            this.estimatedTimeRemainingSeconds = x.estimatedTimeRemainingSeconds
            this.percentDone = x.percentDone
            this.targetResource = x.targetResource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.ProgressDetail = ProgressDetail(this)
    }
}
