// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model

import aws.smithy.kotlin.runtime.time.Instant

public class DescribeWorldExportJobResponse private constructor(builder: Builder) {
    /**
     * The Amazon Resource Name (ARN) of the world export job.
     */
    public val arn: kotlin.String? = builder.arn
    /**
     * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
     */
    public val clientRequestToken: kotlin.String? = builder.clientRequestToken
    /**
     * The time, in milliseconds since the epoch, when the world export job was created.
     */
    public val createdAt: aws.smithy.kotlin.runtime.time.Instant? = builder.createdAt
    /**
     * The failure code of the world export job if it failed:
     *
     * ## InternalServiceError
     * Internal service error.
     *
     * ## LimitExceeded
     * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed.
     *
     * ## ResourceNotFound
     * The specified resource could not be found.
     *
     * ## RequestThrottled
     * The request was throttled.
     *
     * ## InvalidInput
     * An input parameter in the request is not valid.
     */
    public val failureCode: aws.sdk.kotlin.services.robomaker.model.WorldExportJobErrorCode? = builder.failureCode
    /**
     * The reason why the world export job failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
     */
    public val iamRole: kotlin.String? = builder.iamRole
    /**
     * The output location.
     */
    public val outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = builder.outputLocation
    /**
     * The status of the world export job.
     *
     * ## Pending
     * The world export job request is pending.
     *
     * ## Running
     * The world export job is running.
     *
     * ## Completed
     * The world export job completed.
     *
     * ## Failed
     * The world export job failed. See `failureCode` and `failureReason` for more information.
     *
     * ## Canceled
     * The world export job was cancelled.
     *
     * ## Canceling
     * The world export job is being cancelled.
     */
    public val status: aws.sdk.kotlin.services.robomaker.model.WorldExportJobStatus? = builder.status
    /**
     * A map that contains tag keys and tag values that are attached to the world export job.
     */
    public val tags: Map<String, String>? = builder.tags
    /**
     * A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
     */
    public val worlds: List<String>? = builder.worlds

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeWorldExportJobResponse(")
        append("arn=$arn,")
        append("clientRequestToken=$clientRequestToken,")
        append("createdAt=$createdAt,")
        append("failureCode=$failureCode,")
        append("failureReason=$failureReason,")
        append("iamRole=$iamRole,")
        append("outputLocation=$outputLocation,")
        append("status=$status,")
        append("tags=$tags,")
        append("worlds=$worlds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = arn?.hashCode() ?: 0
        result = 31 * result + (clientRequestToken?.hashCode() ?: 0)
        result = 31 * result + (createdAt?.hashCode() ?: 0)
        result = 31 * result + (failureCode?.hashCode() ?: 0)
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (iamRole?.hashCode() ?: 0)
        result = 31 * result + (outputLocation?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        result = 31 * result + (worlds?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeWorldExportJobResponse

        if (arn != other.arn) return false
        if (clientRequestToken != other.clientRequestToken) return false
        if (createdAt != other.createdAt) return false
        if (failureCode != other.failureCode) return false
        if (failureReason != other.failureReason) return false
        if (iamRole != other.iamRole) return false
        if (outputLocation != other.outputLocation) return false
        if (status != other.status) return false
        if (tags != other.tags) return false
        if (worlds != other.worlds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The Amazon Resource Name (ARN) of the world export job.
         */
        public var arn: kotlin.String? = null
        /**
         * Unique, case-sensitive identifier that you provide to ensure the idempotency of the request.
         */
        public var clientRequestToken: kotlin.String? = null
        /**
         * The time, in milliseconds since the epoch, when the world export job was created.
         */
        public var createdAt: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The failure code of the world export job if it failed:
         *
         * ## InternalServiceError
         * Internal service error.
         *
         * ## LimitExceeded
         * The requested resource exceeds the maximum number allowed, or the number of concurrent stream requests exceeds the maximum number allowed.
         *
         * ## ResourceNotFound
         * The specified resource could not be found.
         *
         * ## RequestThrottled
         * The request was throttled.
         *
         * ## InvalidInput
         * An input parameter in the request is not valid.
         */
        public var failureCode: aws.sdk.kotlin.services.robomaker.model.WorldExportJobErrorCode? = null
        /**
         * The reason why the world export job failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * The IAM role that the world export process uses to access the Amazon S3 bucket and put the export.
         */
        public var iamRole: kotlin.String? = null
        /**
         * The output location.
         */
        public var outputLocation: aws.sdk.kotlin.services.robomaker.model.OutputLocation? = null
        /**
         * The status of the world export job.
         *
         * ## Pending
         * The world export job request is pending.
         *
         * ## Running
         * The world export job is running.
         *
         * ## Completed
         * The world export job completed.
         *
         * ## Failed
         * The world export job failed. See `failureCode` and `failureReason` for more information.
         *
         * ## Canceled
         * The world export job was cancelled.
         *
         * ## Canceling
         * The world export job is being cancelled.
         */
        public var status: aws.sdk.kotlin.services.robomaker.model.WorldExportJobStatus? = null
        /**
         * A map that contains tag keys and tag values that are attached to the world export job.
         */
        public var tags: Map<String, String>? = null
        /**
         * A list of Amazon Resource Names (arns) that correspond to worlds to be exported.
         */
        public var worlds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobResponse) : this() {
            this.arn = x.arn
            this.clientRequestToken = x.clientRequestToken
            this.createdAt = x.createdAt
            this.failureCode = x.failureCode
            this.failureReason = x.failureReason
            this.iamRole = x.iamRole
            this.outputLocation = x.outputLocation
            this.status = x.status
            this.tags = x.tags
            this.worlds = x.worlds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobResponse = DescribeWorldExportJobResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.robomaker.model.OutputLocation] inside the given [block]
         */
        public fun outputLocation(block: aws.sdk.kotlin.services.robomaker.model.OutputLocation.Builder.() -> kotlin.Unit) {
            this.outputLocation = aws.sdk.kotlin.services.robomaker.model.OutputLocation.invoke(block)
        }
    }
}
