// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker.model



/**
 * Information about a data source.
 */
public class DataSourceConfig private constructor(builder: Builder) {
    /**
     * The location where your files are mounted in the container image.
     *
     * If you've specified the `type` of the data source as an `Archive`, you must provide an Amazon S3 object key to your archive. The object key must point to either a `.zip` or `.tar.gz` file.
     *
     * If you've specified the `type` of the data source as a `Prefix`, you provide the Amazon S3 prefix that points to the files that you are using for your data source.
     *
     * If you've specified the `type` of the data source as a `File`, you provide the Amazon S3 path to the file that you're using as your data source.
     */
    public val destination: kotlin.String? = builder.destination
    /**
     * The name of the data source.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The S3 bucket where the data files are located.
     */
    public val s3Bucket: kotlin.String? = builder.s3Bucket
    /**
     * The list of S3 keys identifying the data source files.
     */
    public val s3Keys: List<String>? = builder.s3Keys
    /**
     * The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.
     *
     * If you don't specify a field, the default value is `File`.
     */
    public val type: aws.sdk.kotlin.services.robomaker.model.DataSourceType? = builder.type

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.robomaker.model.DataSourceConfig = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DataSourceConfig(")
        append("destination=$destination,")
        append("name=$name,")
        append("s3Bucket=$s3Bucket,")
        append("s3Keys=$s3Keys,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = destination?.hashCode() ?: 0
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (s3Bucket?.hashCode() ?: 0)
        result = 31 * result + (s3Keys?.hashCode() ?: 0)
        result = 31 * result + (type?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DataSourceConfig

        if (destination != other.destination) return false
        if (name != other.name) return false
        if (s3Bucket != other.s3Bucket) return false
        if (s3Keys != other.s3Keys) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.robomaker.model.DataSourceConfig = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The location where your files are mounted in the container image.
         *
         * If you've specified the `type` of the data source as an `Archive`, you must provide an Amazon S3 object key to your archive. The object key must point to either a `.zip` or `.tar.gz` file.
         *
         * If you've specified the `type` of the data source as a `Prefix`, you provide the Amazon S3 prefix that points to the files that you are using for your data source.
         *
         * If you've specified the `type` of the data source as a `File`, you provide the Amazon S3 path to the file that you're using as your data source.
         */
        public var destination: kotlin.String? = null
        /**
         * The name of the data source.
         */
        public var name: kotlin.String? = null
        /**
         * The S3 bucket where the data files are located.
         */
        public var s3Bucket: kotlin.String? = null
        /**
         * The list of S3 keys identifying the data source files.
         */
        public var s3Keys: List<String>? = null
        /**
         * The data type for the data source that you're using for your container image or simulation job. You can use this field to specify whether your data source is an Archive, an Amazon S3 prefix, or a file.
         *
         * If you don't specify a field, the default value is `File`.
         */
        public var type: aws.sdk.kotlin.services.robomaker.model.DataSourceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.robomaker.model.DataSourceConfig) : this() {
            this.destination = x.destination
            this.name = x.name
            this.s3Bucket = x.s3Bucket
            this.s3Keys = x.s3Keys
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.robomaker.model.DataSourceConfig = DataSourceConfig(this)
    }
}
