// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.robomaker

import aws.sdk.kotlin.runtime.client.AwsClientOption
import aws.sdk.kotlin.runtime.http.ApiMetadata
import aws.sdk.kotlin.runtime.http.AwsUserAgentMetadata
import aws.sdk.kotlin.runtime.http.middleware.AwsRetryHeaderMiddleware
import aws.sdk.kotlin.runtime.http.middleware.RecursionDetection
import aws.sdk.kotlin.runtime.http.middleware.UserAgent
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.robomaker.endpoints.internal.ResolveEndpoint
import aws.sdk.kotlin.services.robomaker.endpoints.internal.bindAwsBuiltins
import aws.sdk.kotlin.services.robomaker.model.*
import aws.sdk.kotlin.services.robomaker.model.BatchDeleteWorldsRequest
import aws.sdk.kotlin.services.robomaker.model.BatchDescribeSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.CancelSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.CancelWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateFleetRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotApplicationVersionRequest
import aws.sdk.kotlin.services.robomaker.model.CreateRobotRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationApplicationVersionRequest
import aws.sdk.kotlin.services.robomaker.model.CreateSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.CreateWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteFleetRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DeleteWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.DeregisterRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeFleetRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeRobotRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldExportJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldGenerationJobRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldRequest
import aws.sdk.kotlin.services.robomaker.model.DescribeWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.model.GetWorldTemplateBodyRequest
import aws.sdk.kotlin.services.robomaker.model.ListDeploymentJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListFleetsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListRobotsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationApplicationsRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobBatchesRequest
import aws.sdk.kotlin.services.robomaker.model.ListSimulationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldExportJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldGenerationJobsRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldTemplatesRequest
import aws.sdk.kotlin.services.robomaker.model.ListWorldsRequest
import aws.sdk.kotlin.services.robomaker.model.RegisterRobotRequest
import aws.sdk.kotlin.services.robomaker.model.RestartSimulationJobRequest
import aws.sdk.kotlin.services.robomaker.model.StartSimulationJobBatchRequest
import aws.sdk.kotlin.services.robomaker.model.SyncDeploymentJobRequest
import aws.sdk.kotlin.services.robomaker.model.TagResourceRequest
import aws.sdk.kotlin.services.robomaker.model.UntagResourceRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateRobotApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateSimulationApplicationRequest
import aws.sdk.kotlin.services.robomaker.model.UpdateWorldTemplateRequest
import aws.sdk.kotlin.services.robomaker.transform.*
import aws.smithy.kotlin.runtime.auth.awssigning.AwsHttpSigner
import aws.smithy.kotlin.runtime.auth.awssigning.AwsSigningAttributes
import aws.smithy.kotlin.runtime.client.ExecutionContext
import aws.smithy.kotlin.runtime.client.SdkClientOption
import aws.smithy.kotlin.runtime.client.idempotencyTokenProvider
import aws.smithy.kotlin.runtime.http.SdkHttpClient
import aws.smithy.kotlin.runtime.http.engine.DefaultHttpEngine
import aws.smithy.kotlin.runtime.http.operation.SdkHttpOperation
import aws.smithy.kotlin.runtime.http.operation.context
import aws.smithy.kotlin.runtime.http.operation.roundTrip
import aws.smithy.kotlin.runtime.http.operation.sdkRequestId
import aws.smithy.kotlin.runtime.http.sdkHttpClient
import aws.smithy.kotlin.runtime.io.Closeable
import aws.smithy.kotlin.runtime.tracing.withRootTraceSpan
import aws.smithy.kotlin.runtime.util.putIfAbsent
import kotlin.coroutines.coroutineContext


public const val ServiceId: String = "RoboMaker"
public const val ServiceApiVersion: String = "2018-06-29"
public const val SdkVersion: String = "0.19.3-beta"

internal class DefaultRoboMakerClient(override val config: RoboMakerClient.Config) : RoboMakerClient {
    private val client: SdkHttpClient
    init {
        val httpClientEngine = config.httpClientEngine ?: DefaultHttpEngine()
        client = sdkHttpClient(httpClientEngine, manageEngine = config.httpClientEngine == null)
    }
    private val awsUserAgentMetadata = AwsUserAgentMetadata.fromEnvironment(ApiMetadata(ServiceId, SdkVersion))

    /**
     * Deletes one or more worlds in a batch operation.
     */
    override suspend fun batchDeleteWorlds(input: BatchDeleteWorldsRequest): BatchDeleteWorldsResponse {
        val op = SdkHttpOperation.build<BatchDeleteWorldsRequest, BatchDeleteWorldsResponse> {
            serializer = BatchDeleteWorldsOperationSerializer()
            deserializer = BatchDeleteWorldsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDeleteWorlds"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<BatchDeleteWorldsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDeleteWorlds-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes one or more simulation jobs.
     */
    override suspend fun batchDescribeSimulationJob(input: BatchDescribeSimulationJobRequest): BatchDescribeSimulationJobResponse {
        val op = SdkHttpOperation.build<BatchDescribeSimulationJobRequest, BatchDescribeSimulationJobResponse> {
            serializer = BatchDescribeSimulationJobOperationSerializer()
            deserializer = BatchDescribeSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "BatchDescribeSimulationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<BatchDescribeSimulationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("BatchDescribeSimulationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Cancels the specified deployment job.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun cancelDeploymentJob(input: CancelDeploymentJobRequest): CancelDeploymentJobResponse {
        val op = SdkHttpOperation.build<CancelDeploymentJobRequest, CancelDeploymentJobResponse> {
            serializer = CancelDeploymentJobOperationSerializer()
            deserializer = CancelDeploymentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelDeploymentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CancelDeploymentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CancelDeploymentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Cancels the specified simulation job.
     */
    override suspend fun cancelSimulationJob(input: CancelSimulationJobRequest): CancelSimulationJobResponse {
        val op = SdkHttpOperation.build<CancelSimulationJobRequest, CancelSimulationJobResponse> {
            serializer = CancelSimulationJobOperationSerializer()
            deserializer = CancelSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelSimulationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CancelSimulationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CancelSimulationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Cancels a simulation job batch. When you cancel a simulation job batch, you are also cancelling all of the active simulation jobs created as part of the batch.
     */
    override suspend fun cancelSimulationJobBatch(input: CancelSimulationJobBatchRequest): CancelSimulationJobBatchResponse {
        val op = SdkHttpOperation.build<CancelSimulationJobBatchRequest, CancelSimulationJobBatchResponse> {
            serializer = CancelSimulationJobBatchOperationSerializer()
            deserializer = CancelSimulationJobBatchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelSimulationJobBatch"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CancelSimulationJobBatchRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CancelSimulationJobBatch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Cancels the specified export job.
     */
    override suspend fun cancelWorldExportJob(input: CancelWorldExportJobRequest): CancelWorldExportJobResponse {
        val op = SdkHttpOperation.build<CancelWorldExportJobRequest, CancelWorldExportJobResponse> {
            serializer = CancelWorldExportJobOperationSerializer()
            deserializer = CancelWorldExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelWorldExportJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CancelWorldExportJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CancelWorldExportJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Cancels the specified world generator job.
     */
    override suspend fun cancelWorldGenerationJob(input: CancelWorldGenerationJobRequest): CancelWorldGenerationJobResponse {
        val op = SdkHttpOperation.build<CancelWorldGenerationJobRequest, CancelWorldGenerationJobResponse> {
            serializer = CancelWorldGenerationJobOperationSerializer()
            deserializer = CancelWorldGenerationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CancelWorldGenerationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CancelWorldGenerationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CancelWorldGenerationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deploys a specific version of a robot application to robots in a fleet.
     *
     * This API is no longer supported and will throw an error if used.
     *
     * The robot application must have a numbered `applicationVersion` for consistency reasons. To create a new version, use `CreateRobotApplicationVersion` or see [Creating a Robot Application Version](https://docs.aws.amazon.com/robomaker/latest/dg/create-robot-application-version.html).
     *
     * After 90 days, deployment jobs expire and will be deleted. They will no longer be accessible.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createDeploymentJob(input: CreateDeploymentJobRequest): CreateDeploymentJobResponse {
        val op = SdkHttpOperation.build<CreateDeploymentJobRequest, CreateDeploymentJobResponse> {
            serializer = CreateDeploymentJobOperationSerializer()
            deserializer = CreateDeploymentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateDeploymentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateDeploymentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateDeploymentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a fleet, a logical group of robots running the same robot application.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createFleet(input: CreateFleetRequest): CreateFleetResponse {
        val op = SdkHttpOperation.build<CreateFleetRequest, CreateFleetResponse> {
            serializer = CreateFleetOperationSerializer()
            deserializer = CreateFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateFleet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateFleetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateFleet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a robot.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun createRobot(input: CreateRobotRequest): CreateRobotResponse {
        val op = SdkHttpOperation.build<CreateRobotRequest, CreateRobotResponse> {
            serializer = CreateRobotOperationSerializer()
            deserializer = CreateRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRobot"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateRobotRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateRobot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a robot application.
     */
    override suspend fun createRobotApplication(input: CreateRobotApplicationRequest): CreateRobotApplicationResponse {
        val op = SdkHttpOperation.build<CreateRobotApplicationRequest, CreateRobotApplicationResponse> {
            serializer = CreateRobotApplicationOperationSerializer()
            deserializer = CreateRobotApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRobotApplication"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateRobotApplicationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateRobotApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a version of a robot application.
     */
    override suspend fun createRobotApplicationVersion(input: CreateRobotApplicationVersionRequest): CreateRobotApplicationVersionResponse {
        val op = SdkHttpOperation.build<CreateRobotApplicationVersionRequest, CreateRobotApplicationVersionResponse> {
            serializer = CreateRobotApplicationVersionOperationSerializer()
            deserializer = CreateRobotApplicationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateRobotApplicationVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateRobotApplicationVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateRobotApplicationVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a simulation application.
     */
    override suspend fun createSimulationApplication(input: CreateSimulationApplicationRequest): CreateSimulationApplicationResponse {
        val op = SdkHttpOperation.build<CreateSimulationApplicationRequest, CreateSimulationApplicationResponse> {
            serializer = CreateSimulationApplicationOperationSerializer()
            deserializer = CreateSimulationApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSimulationApplication"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSimulationApplicationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSimulationApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a simulation application with a specific revision id.
     */
    override suspend fun createSimulationApplicationVersion(input: CreateSimulationApplicationVersionRequest): CreateSimulationApplicationVersionResponse {
        val op = SdkHttpOperation.build<CreateSimulationApplicationVersionRequest, CreateSimulationApplicationVersionResponse> {
            serializer = CreateSimulationApplicationVersionOperationSerializer()
            deserializer = CreateSimulationApplicationVersionOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSimulationApplicationVersion"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSimulationApplicationVersionRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSimulationApplicationVersion-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a simulation job.
     *
     * After 90 days, simulation jobs expire and will be deleted. They will no longer be accessible.
     */
    override suspend fun createSimulationJob(input: CreateSimulationJobRequest): CreateSimulationJobResponse {
        val op = SdkHttpOperation.build<CreateSimulationJobRequest, CreateSimulationJobResponse> {
            serializer = CreateSimulationJobOperationSerializer()
            deserializer = CreateSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateSimulationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateSimulationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateSimulationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a world export job.
     */
    override suspend fun createWorldExportJob(input: CreateWorldExportJobRequest): CreateWorldExportJobResponse {
        val op = SdkHttpOperation.build<CreateWorldExportJobRequest, CreateWorldExportJobResponse> {
            serializer = CreateWorldExportJobOperationSerializer()
            deserializer = CreateWorldExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorldExportJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateWorldExportJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateWorldExportJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates worlds using the specified template.
     */
    override suspend fun createWorldGenerationJob(input: CreateWorldGenerationJobRequest): CreateWorldGenerationJobResponse {
        val op = SdkHttpOperation.build<CreateWorldGenerationJobRequest, CreateWorldGenerationJobResponse> {
            serializer = CreateWorldGenerationJobOperationSerializer()
            deserializer = CreateWorldGenerationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorldGenerationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateWorldGenerationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateWorldGenerationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Creates a world template.
     */
    override suspend fun createWorldTemplate(input: CreateWorldTemplateRequest): CreateWorldTemplateResponse {
        val op = SdkHttpOperation.build<CreateWorldTemplateRequest, CreateWorldTemplateResponse> {
            serializer = CreateWorldTemplateOperationSerializer()
            deserializer = CreateWorldTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "CreateWorldTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<CreateWorldTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("CreateWorldTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a fleet.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteFleet(input: DeleteFleetRequest): DeleteFleetResponse {
        val op = SdkHttpOperation.build<DeleteFleetRequest, DeleteFleetResponse> {
            serializer = DeleteFleetOperationSerializer()
            deserializer = DeleteFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteFleet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteFleetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteFleet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deleteRobot(input: DeleteRobotRequest): DeleteRobotResponse {
        val op = SdkHttpOperation.build<DeleteRobotRequest, DeleteRobotResponse> {
            serializer = DeleteRobotOperationSerializer()
            deserializer = DeleteRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRobot"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteRobotRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteRobot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a robot application.
     */
    override suspend fun deleteRobotApplication(input: DeleteRobotApplicationRequest): DeleteRobotApplicationResponse {
        val op = SdkHttpOperation.build<DeleteRobotApplicationRequest, DeleteRobotApplicationResponse> {
            serializer = DeleteRobotApplicationOperationSerializer()
            deserializer = DeleteRobotApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteRobotApplication"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteRobotApplicationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteRobotApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a simulation application.
     */
    override suspend fun deleteSimulationApplication(input: DeleteSimulationApplicationRequest): DeleteSimulationApplicationResponse {
        val op = SdkHttpOperation.build<DeleteSimulationApplicationRequest, DeleteSimulationApplicationResponse> {
            serializer = DeleteSimulationApplicationOperationSerializer()
            deserializer = DeleteSimulationApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteSimulationApplication"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteSimulationApplicationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteSimulationApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deletes a world template.
     */
    override suspend fun deleteWorldTemplate(input: DeleteWorldTemplateRequest): DeleteWorldTemplateResponse {
        val op = SdkHttpOperation.build<DeleteWorldTemplateRequest, DeleteWorldTemplateResponse> {
            serializer = DeleteWorldTemplateOperationSerializer()
            deserializer = DeleteWorldTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeleteWorldTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeleteWorldTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeleteWorldTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Deregisters a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun deregisterRobot(input: DeregisterRobotRequest): DeregisterRobotResponse {
        val op = SdkHttpOperation.build<DeregisterRobotRequest, DeregisterRobotResponse> {
            serializer = DeregisterRobotOperationSerializer()
            deserializer = DeregisterRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DeregisterRobot"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DeregisterRobotRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DeregisterRobot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a deployment job.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeDeploymentJob(input: DescribeDeploymentJobRequest): DescribeDeploymentJobResponse {
        val op = SdkHttpOperation.build<DescribeDeploymentJobRequest, DescribeDeploymentJobResponse> {
            serializer = DescribeDeploymentJobOperationSerializer()
            deserializer = DescribeDeploymentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeDeploymentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeDeploymentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeDeploymentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a fleet.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeFleet(input: DescribeFleetRequest): DescribeFleetResponse {
        val op = SdkHttpOperation.build<DescribeFleetRequest, DescribeFleetResponse> {
            serializer = DescribeFleetOperationSerializer()
            deserializer = DescribeFleetOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeFleet"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeFleetRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeFleet-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a robot.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun describeRobot(input: DescribeRobotRequest): DescribeRobotResponse {
        val op = SdkHttpOperation.build<DescribeRobotRequest, DescribeRobotResponse> {
            serializer = DescribeRobotOperationSerializer()
            deserializer = DescribeRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRobot"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeRobotRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRobot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a robot application.
     */
    override suspend fun describeRobotApplication(input: DescribeRobotApplicationRequest): DescribeRobotApplicationResponse {
        val op = SdkHttpOperation.build<DescribeRobotApplicationRequest, DescribeRobotApplicationResponse> {
            serializer = DescribeRobotApplicationOperationSerializer()
            deserializer = DescribeRobotApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeRobotApplication"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeRobotApplicationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeRobotApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a simulation application.
     */
    override suspend fun describeSimulationApplication(input: DescribeSimulationApplicationRequest): DescribeSimulationApplicationResponse {
        val op = SdkHttpOperation.build<DescribeSimulationApplicationRequest, DescribeSimulationApplicationResponse> {
            serializer = DescribeSimulationApplicationOperationSerializer()
            deserializer = DescribeSimulationApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSimulationApplication"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeSimulationApplicationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeSimulationApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a simulation job.
     */
    override suspend fun describeSimulationJob(input: DescribeSimulationJobRequest): DescribeSimulationJobResponse {
        val op = SdkHttpOperation.build<DescribeSimulationJobRequest, DescribeSimulationJobResponse> {
            serializer = DescribeSimulationJobOperationSerializer()
            deserializer = DescribeSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSimulationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeSimulationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeSimulationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a simulation job batch.
     */
    override suspend fun describeSimulationJobBatch(input: DescribeSimulationJobBatchRequest): DescribeSimulationJobBatchResponse {
        val op = SdkHttpOperation.build<DescribeSimulationJobBatchRequest, DescribeSimulationJobBatchResponse> {
            serializer = DescribeSimulationJobBatchOperationSerializer()
            deserializer = DescribeSimulationJobBatchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeSimulationJobBatch"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeSimulationJobBatchRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeSimulationJobBatch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a world.
     */
    override suspend fun describeWorld(input: DescribeWorldRequest): DescribeWorldResponse {
        val op = SdkHttpOperation.build<DescribeWorldRequest, DescribeWorldResponse> {
            serializer = DescribeWorldOperationSerializer()
            deserializer = DescribeWorldOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorld"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeWorldRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeWorld-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a world export job.
     */
    override suspend fun describeWorldExportJob(input: DescribeWorldExportJobRequest): DescribeWorldExportJobResponse {
        val op = SdkHttpOperation.build<DescribeWorldExportJobRequest, DescribeWorldExportJobResponse> {
            serializer = DescribeWorldExportJobOperationSerializer()
            deserializer = DescribeWorldExportJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorldExportJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeWorldExportJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeWorldExportJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a world generation job.
     */
    override suspend fun describeWorldGenerationJob(input: DescribeWorldGenerationJobRequest): DescribeWorldGenerationJobResponse {
        val op = SdkHttpOperation.build<DescribeWorldGenerationJobRequest, DescribeWorldGenerationJobResponse> {
            serializer = DescribeWorldGenerationJobOperationSerializer()
            deserializer = DescribeWorldGenerationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorldGenerationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeWorldGenerationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeWorldGenerationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Describes a world template.
     */
    override suspend fun describeWorldTemplate(input: DescribeWorldTemplateRequest): DescribeWorldTemplateResponse {
        val op = SdkHttpOperation.build<DescribeWorldTemplateRequest, DescribeWorldTemplateResponse> {
            serializer = DescribeWorldTemplateOperationSerializer()
            deserializer = DescribeWorldTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "DescribeWorldTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<DescribeWorldTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("DescribeWorldTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Gets the world template body.
     */
    override suspend fun getWorldTemplateBody(input: GetWorldTemplateBodyRequest): GetWorldTemplateBodyResponse {
        val op = SdkHttpOperation.build<GetWorldTemplateBodyRequest, GetWorldTemplateBodyResponse> {
            serializer = GetWorldTemplateBodyOperationSerializer()
            deserializer = GetWorldTemplateBodyOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "GetWorldTemplateBody"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<GetWorldTemplateBodyRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("GetWorldTemplateBody-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of deployment jobs for a fleet. You can optionally provide filters to retrieve specific deployment jobs.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listDeploymentJobs(input: ListDeploymentJobsRequest): ListDeploymentJobsResponse {
        val op = SdkHttpOperation.build<ListDeploymentJobsRequest, ListDeploymentJobsResponse> {
            serializer = ListDeploymentJobsOperationSerializer()
            deserializer = ListDeploymentJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListDeploymentJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListDeploymentJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListDeploymentJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of fleets. You can optionally provide filters to retrieve specific fleets.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listFleets(input: ListFleetsRequest): ListFleetsResponse {
        val op = SdkHttpOperation.build<ListFleetsRequest, ListFleetsResponse> {
            serializer = ListFleetsOperationSerializer()
            deserializer = ListFleetsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListFleets"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListFleetsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListFleets-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of robot application. You can optionally provide filters to retrieve specific robot applications.
     */
    override suspend fun listRobotApplications(input: ListRobotApplicationsRequest): ListRobotApplicationsResponse {
        val op = SdkHttpOperation.build<ListRobotApplicationsRequest, ListRobotApplicationsResponse> {
            serializer = ListRobotApplicationsOperationSerializer()
            deserializer = ListRobotApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRobotApplications"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListRobotApplicationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListRobotApplications-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of robots. You can optionally provide filters to retrieve specific robots.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun listRobots(input: ListRobotsRequest): ListRobotsResponse {
        val op = SdkHttpOperation.build<ListRobotsRequest, ListRobotsResponse> {
            serializer = ListRobotsOperationSerializer()
            deserializer = ListRobotsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListRobots"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListRobotsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListRobots-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of simulation applications. You can optionally provide filters to retrieve specific simulation applications.
     */
    override suspend fun listSimulationApplications(input: ListSimulationApplicationsRequest): ListSimulationApplicationsResponse {
        val op = SdkHttpOperation.build<ListSimulationApplicationsRequest, ListSimulationApplicationsResponse> {
            serializer = ListSimulationApplicationsOperationSerializer()
            deserializer = ListSimulationApplicationsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSimulationApplications"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListSimulationApplicationsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSimulationApplications-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list simulation job batches. You can optionally provide filters to retrieve specific simulation batch jobs.
     */
    override suspend fun listSimulationJobBatches(input: ListSimulationJobBatchesRequest): ListSimulationJobBatchesResponse {
        val op = SdkHttpOperation.build<ListSimulationJobBatchesRequest, ListSimulationJobBatchesResponse> {
            serializer = ListSimulationJobBatchesOperationSerializer()
            deserializer = ListSimulationJobBatchesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSimulationJobBatches"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListSimulationJobBatchesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSimulationJobBatches-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Returns a list of simulation jobs. You can optionally provide filters to retrieve specific simulation jobs.
     */
    override suspend fun listSimulationJobs(input: ListSimulationJobsRequest): ListSimulationJobsResponse {
        val op = SdkHttpOperation.build<ListSimulationJobsRequest, ListSimulationJobsResponse> {
            serializer = ListSimulationJobsOperationSerializer()
            deserializer = ListSimulationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListSimulationJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListSimulationJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListSimulationJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists all tags on a AWS RoboMaker resource.
     */
    override suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse {
        val op = SdkHttpOperation.build<ListTagsForResourceRequest, ListTagsForResourceResponse> {
            serializer = ListTagsForResourceOperationSerializer()
            deserializer = ListTagsForResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListTagsForResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListTagsForResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListTagsForResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists world export jobs.
     */
    override suspend fun listWorldExportJobs(input: ListWorldExportJobsRequest): ListWorldExportJobsResponse {
        val op = SdkHttpOperation.build<ListWorldExportJobsRequest, ListWorldExportJobsResponse> {
            serializer = ListWorldExportJobsOperationSerializer()
            deserializer = ListWorldExportJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorldExportJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorldExportJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorldExportJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists world generator jobs.
     */
    override suspend fun listWorldGenerationJobs(input: ListWorldGenerationJobsRequest): ListWorldGenerationJobsResponse {
        val op = SdkHttpOperation.build<ListWorldGenerationJobsRequest, ListWorldGenerationJobsResponse> {
            serializer = ListWorldGenerationJobsOperationSerializer()
            deserializer = ListWorldGenerationJobsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorldGenerationJobs"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorldGenerationJobsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorldGenerationJobs-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists world templates.
     */
    override suspend fun listWorldTemplates(input: ListWorldTemplatesRequest): ListWorldTemplatesResponse {
        val op = SdkHttpOperation.build<ListWorldTemplatesRequest, ListWorldTemplatesResponse> {
            serializer = ListWorldTemplatesOperationSerializer()
            deserializer = ListWorldTemplatesOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorldTemplates"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorldTemplatesRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorldTemplates-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Lists worlds.
     */
    override suspend fun listWorlds(input: ListWorldsRequest): ListWorldsResponse {
        val op = SdkHttpOperation.build<ListWorldsRequest, ListWorldsResponse> {
            serializer = ListWorldsOperationSerializer()
            deserializer = ListWorldsOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "ListWorlds"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<ListWorldsRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("ListWorlds-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Registers a robot with a fleet.
     *
     * This API is no longer supported and will throw an error if used.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun registerRobot(input: RegisterRobotRequest): RegisterRobotResponse {
        val op = SdkHttpOperation.build<RegisterRobotRequest, RegisterRobotResponse> {
            serializer = RegisterRobotOperationSerializer()
            deserializer = RegisterRobotOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RegisterRobot"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RegisterRobotRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RegisterRobot-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Restarts a running simulation job.
     */
    override suspend fun restartSimulationJob(input: RestartSimulationJobRequest): RestartSimulationJobResponse {
        val op = SdkHttpOperation.build<RestartSimulationJobRequest, RestartSimulationJobResponse> {
            serializer = RestartSimulationJobOperationSerializer()
            deserializer = RestartSimulationJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "RestartSimulationJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<RestartSimulationJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("RestartSimulationJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Starts a new simulation job batch. The batch is defined using one or more `SimulationJobRequest` objects.
     */
    override suspend fun startSimulationJobBatch(input: StartSimulationJobBatchRequest): StartSimulationJobBatchResponse {
        val op = SdkHttpOperation.build<StartSimulationJobBatchRequest, StartSimulationJobBatchResponse> {
            serializer = StartSimulationJobBatchOperationSerializer()
            deserializer = StartSimulationJobBatchOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "StartSimulationJobBatch"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<StartSimulationJobBatchRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("StartSimulationJobBatch-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Syncrhonizes robots in a fleet to the latest deployment. This is helpful if robots were added after a deployment.
     *
     * This API will no longer be supported as of May 2, 2022. Use it to remove resources that were created for Deployment Service.
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    override suspend fun syncDeploymentJob(input: SyncDeploymentJobRequest): SyncDeploymentJobResponse {
        val op = SdkHttpOperation.build<SyncDeploymentJobRequest, SyncDeploymentJobResponse> {
            serializer = SyncDeploymentJobOperationSerializer()
            deserializer = SyncDeploymentJobOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "SyncDeploymentJob"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<SyncDeploymentJobRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("SyncDeploymentJob-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Adds or edits tags for a AWS RoboMaker resource.
     *
     * Each tag consists of a tag key and a tag value. Tag keys and tag values are both required, but tag values can be empty strings.
     *
     * For information about the rules that apply to tag keys and tag values, see [User-Defined Tag Restrictions](https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html) in the *AWS Billing and Cost Management User Guide*.
     */
    override suspend fun tagResource(input: TagResourceRequest): TagResourceResponse {
        val op = SdkHttpOperation.build<TagResourceRequest, TagResourceResponse> {
            serializer = TagResourceOperationSerializer()
            deserializer = TagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "TagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<TagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("TagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Removes the specified tags from the specified AWS RoboMaker resource.
     *
     * To remove a tag, specify the tag key. To change the tag value of an existing tag key, use `TagResource`[](https://docs.aws.amazon.com/robomaker/latest/dg/API_TagResource.html).
     */
    override suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse {
        val op = SdkHttpOperation.build<UntagResourceRequest, UntagResourceResponse> {
            serializer = UntagResourceOperationSerializer()
            deserializer = UntagResourceOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UntagResource"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UntagResourceRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UntagResource-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a robot application.
     */
    override suspend fun updateRobotApplication(input: UpdateRobotApplicationRequest): UpdateRobotApplicationResponse {
        val op = SdkHttpOperation.build<UpdateRobotApplicationRequest, UpdateRobotApplicationResponse> {
            serializer = UpdateRobotApplicationOperationSerializer()
            deserializer = UpdateRobotApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateRobotApplication"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateRobotApplicationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateRobotApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a simulation application.
     */
    override suspend fun updateSimulationApplication(input: UpdateSimulationApplicationRequest): UpdateSimulationApplicationResponse {
        val op = SdkHttpOperation.build<UpdateSimulationApplicationRequest, UpdateSimulationApplicationResponse> {
            serializer = UpdateSimulationApplicationOperationSerializer()
            deserializer = UpdateSimulationApplicationOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateSimulationApplication"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateSimulationApplicationRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateSimulationApplication-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    /**
     * Updates a world template.
     */
    override suspend fun updateWorldTemplate(input: UpdateWorldTemplateRequest): UpdateWorldTemplateResponse {
        val op = SdkHttpOperation.build<UpdateWorldTemplateRequest, UpdateWorldTemplateResponse> {
            serializer = UpdateWorldTemplateOperationSerializer()
            deserializer = UpdateWorldTemplateOperationDeserializer()
            context {
                expectedHttpStatus = 200
                service = serviceName
                operationName = "UpdateWorldTemplate"
            }
        }
        op.execution.retryStrategy = config.retryStrategy
        op.execution.retryPolicy = AwsDefaultRetryPolicy
        mergeServiceDefaults(op.context)
        op.interceptors.add(ResolveEndpoint<UpdateWorldTemplateRequest>(config.endpointProvider) {
            bindAwsBuiltins(config)
        })
        op.install(AwsRetryHeaderMiddleware())
        op.install(UserAgent(awsUserAgentMetadata))
        op.install(RecursionDetection())
        op.execution.signer = AwsHttpSigner {
            this.signer = config.signer
            this.credentialsProvider = config.credentialsProvider
            this.service = "robomaker"
        }
        op.interceptors.addAll(config.interceptors)
        val rootSpan = config.tracer.createRootSpan("UpdateWorldTemplate-${op.context.sdkRequestId}")
        return coroutineContext.withRootTraceSpan(rootSpan) {
            op.roundTrip(client, input)
        }
    }

    override fun close() {
        client.close()
        (config.credentialsProvider as? Closeable)?.close()
    }

    /**
     * merge the defaults configured for the service into the execution context before firing off a request
     */
    private suspend fun mergeServiceDefaults(ctx: ExecutionContext) {
        ctx.putIfAbsent(AwsClientOption.Region, config.region)
        ctx.putIfAbsent(SdkClientOption.ServiceName, serviceName)
        ctx.putIfAbsent(SdkClientOption.LogMode, config.sdkLogMode)
        ctx.putIfAbsent(AwsSigningAttributes.SigningService, "robomaker")
        ctx.putIfAbsent(AwsSigningAttributes.Signer, config.signer)
        ctx.putIfAbsent(AwsSigningAttributes.SigningRegion, config.region)
        ctx.putIfAbsent(AwsSigningAttributes.CredentialsProvider, config.credentialsProvider)
        config.idempotencyTokenProvider?.let { ctx[SdkClientOption.IdempotencyTokenProvider] = it }
    }
}
