// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.serde

import aws.sdk.kotlin.services.resourcegroups.model.FailedResource
import aws.sdk.kotlin.services.resourcegroups.model.PendingResource
import aws.sdk.kotlin.services.resourcegroups.model.ResourceGroupsException
import aws.sdk.kotlin.services.resourcegroups.model.UngroupResourcesResponse
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class UngroupResourcesOperationDeserializer: HttpDeserialize<UngroupResourcesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): UngroupResourcesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwUngroupResourcesError(context, call)
        }
        val builder = UngroupResourcesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeUngroupResourcesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwUngroupResourcesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ResourceGroupsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "MethodNotAllowedException" -> MethodNotAllowedExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ResourceGroupsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeUngroupResourcesOperationBody(builder: UngroupResourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val FAILED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Failed"))
    val PENDING_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Pending"))
    val SUCCEEDED_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Succeeded"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(FAILED_DESCRIPTOR)
        field(PENDING_DESCRIPTOR)
        field(SUCCEEDED_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                FAILED_DESCRIPTOR.index -> builder.failed =
                    deserializer.deserializeList(FAILED_DESCRIPTOR) {
                        val col0 = mutableListOf<FailedResource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeFailedResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                PENDING_DESCRIPTOR.index -> builder.pending =
                    deserializer.deserializeList(PENDING_DESCRIPTOR) {
                        val col0 = mutableListOf<PendingResource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializePendingResourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCEEDED_DESCRIPTOR.index -> builder.succeeded =
                    deserializer.deserializeList(SUCCEEDED_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
