// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.serde

import aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesItem
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesResponse
import aws.sdk.kotlin.services.resourcegroups.model.QueryError
import aws.sdk.kotlin.services.resourcegroups.model.ResourceGroupsException
import aws.sdk.kotlin.services.resourcegroups.model.ResourceIdentifier
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserialize
import aws.smithy.kotlin.runtime.http.readAll
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ListGroupResourcesOperationDeserializer: HttpDeserialize<ListGroupResourcesResponse> {

    override suspend fun deserialize(context: ExecutionContext, call: HttpCall): ListGroupResourcesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwListGroupResourcesError(context, call)
        }
        val builder = ListGroupResourcesResponse.Builder()

        val payload = response.body.readAll()
        if (payload != null) {
            deserializeListGroupResourcesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private suspend fun throwListGroupResourcesError(context: ExecutionContext, call: HttpCall): kotlin.Nothing {
    val payload = call.response.body.readAll()
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ResourceGroupsException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "BadRequestException" -> BadRequestExceptionDeserializer().deserialize(context, wrappedCall)
        "ForbiddenException" -> ForbiddenExceptionDeserializer().deserialize(context, wrappedCall)
        "InternalServerErrorException" -> InternalServerErrorExceptionDeserializer().deserialize(context, wrappedCall)
        "MethodNotAllowedException" -> MethodNotAllowedExceptionDeserializer().deserialize(context, wrappedCall)
        "NotFoundException" -> NotFoundExceptionDeserializer().deserialize(context, wrappedCall)
        "TooManyRequestsException" -> TooManyRequestsExceptionDeserializer().deserialize(context, wrappedCall)
        "UnauthorizedException" -> UnauthorizedExceptionDeserializer().deserialize(context, wrappedCall)
        else -> ResourceGroupsException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeListGroupResourcesOperationBody(builder: ListGroupResourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val NEXTTOKEN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("NextToken"))
    val QUERYERRORS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("QueryErrors"))
    val RESOURCEIDENTIFIERS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("ResourceIdentifiers"))
    val RESOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("Resources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(NEXTTOKEN_DESCRIPTOR)
        field(QUERYERRORS_DESCRIPTOR)
        field(RESOURCEIDENTIFIERS_DESCRIPTOR)
        field(RESOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                NEXTTOKEN_DESCRIPTOR.index -> builder.nextToken = deserializeString()
                QUERYERRORS_DESCRIPTOR.index -> builder.queryErrors =
                    deserializer.deserializeList(QUERYERRORS_DESCRIPTOR) {
                        val col0 = mutableListOf<QueryError>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeQueryErrorDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOURCEIDENTIFIERS_DESCRIPTOR.index -> builder.resourceIdentifiers =
                    deserializer.deserializeList(RESOURCEIDENTIFIERS_DESCRIPTOR) {
                        val col0 = mutableListOf<ResourceIdentifier>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeResourceIdentifierDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                RESOURCES_DESCRIPTOR.index -> builder.resources =
                    deserializer.deserializeList(RESOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<ListGroupResourcesItem>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeListGroupResourcesItemDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
