// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.paginators

import aws.sdk.kotlin.services.resourcegroups.ResourceGroupsClient
import aws.sdk.kotlin.services.resourcegroups.model.GroupIdentifier
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesRequest
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesResponse
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupsRequest
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupsResponse
import aws.sdk.kotlin.services.resourcegroups.model.ResourceIdentifier
import aws.sdk.kotlin.services.resourcegroups.model.SearchResourcesRequest
import aws.sdk.kotlin.services.resourcegroups.model.SearchResourcesResponse
import kotlin.jvm.JvmName
import kotlinx.coroutines.flow.Flow
import kotlinx.coroutines.flow.flow
import kotlinx.coroutines.flow.transform


/**
 * Paginate over [ListGroupResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupResourcesResponse]
 */
public fun ResourceGroupsClient.listGroupResourcesPaginated(initialRequest: ListGroupResourcesRequest = ListGroupResourcesRequest { }): Flow<ListGroupResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupResourcesPaginated.listGroupResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupResourcesResponse]
 */
public fun ResourceGroupsClient.listGroupResourcesPaginated(block: ListGroupResourcesRequest.Builder.() -> Unit): Flow<ListGroupResourcesResponse> =
    listGroupResourcesPaginated(ListGroupResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupResourcesPaginated]
 * to access the nested member [ResourceIdentifier]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceIdentifier]
 */
@JvmName("listGroupResourcesResponseResourceIdentifier")
public fun Flow<ListGroupResourcesResponse>.resourceIdentifiers(): Flow<ResourceIdentifier> =
    transform() { response ->
        response.resourceIdentifiers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [ListGroupsRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun ResourceGroupsClient.listGroupsPaginated(initialRequest: ListGroupsRequest = ListGroupsRequest { }): Flow<ListGroupsResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@listGroupsPaginated.listGroups(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [ListGroupsResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ListGroupsResponse]
 */
public fun ResourceGroupsClient.listGroupsPaginated(block: ListGroupsRequest.Builder.() -> Unit): Flow<ListGroupsResponse> =
    listGroupsPaginated(ListGroupsRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [listGroupsPaginated]
 * to access the nested member [GroupIdentifier]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [GroupIdentifier]
 */
@JvmName("listGroupsResponseGroupIdentifier")
public fun Flow<ListGroupsResponse>.groupIdentifiers(): Flow<GroupIdentifier> =
    transform() { response ->
        response.groupIdentifiers?.forEach {
            emit(it)
        }
    }

/**
 * Paginate over [SearchResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param initialRequest A [SearchResourcesRequest] to start pagination
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResourcesResponse]
 */
public fun ResourceGroupsClient.searchResourcesPaginated(initialRequest: SearchResourcesRequest): Flow<SearchResourcesResponse> =
    flow {
        var cursor: kotlin.String? = null
        var hasNextPage: Boolean = true

        while (hasNextPage) {
            val req = initialRequest.copy {
                this.nextToken = cursor
            }
            val result = this@searchResourcesPaginated.searchResources(req)
            cursor = result.nextToken
            hasNextPage = cursor?.isNotEmpty() == true
            emit(result)
        }
    }

/**
 * Paginate over [SearchResourcesResponse] results.
 *
 * When this operation is called, a [kotlinx.coroutines.Flow] is created. Flows are lazy (cold) so no service
 * calls are made until the flow is collected. This also means there is no guarantee that the request is valid
 * until then. Once you start collecting the flow, the SDK will lazily load response pages by making service
 * calls until there are no pages left or the flow is cancelled. If there are errors in your request, you will
 * see the failures only after you start collection.
 * @param block A builder block used for DSL-style invocation of the operation
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [SearchResourcesResponse]
 */
public fun ResourceGroupsClient.searchResourcesPaginated(block: SearchResourcesRequest.Builder.() -> Unit): Flow<SearchResourcesResponse> =
    searchResourcesPaginated(SearchResourcesRequest.Builder().apply(block).build())

/**
 * This paginator transforms the flow returned by [searchResourcesPaginated]
 * to access the nested member [ResourceIdentifier]
 * @return A [kotlinx.coroutines.flow.Flow] that can collect [ResourceIdentifier]
 */
@JvmName("searchResourcesResponseResourceIdentifier")
public fun Flow<SearchResourcesResponse>.resourceIdentifiers(): Flow<ResourceIdentifier> =
    transform() { response ->
        response.resourceIdentifiers?.forEach {
            emit(it)
        }
    }
