// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



/**
 * A two-part error structure that can occur in `ListGroupResources` or `SearchResources` operations on CloudFront stack-based queries. The error occurs if the CloudFront stack on which the query is based either does not exist, or has a status that renders the stack inactive. A `QueryError` occurrence does not necessarily mean that Resource Groups could not complete the operation, but the resulting group might have no member resources.
 */
public class QueryError private constructor(builder: Builder) {
    /**
     * Specifies the error code that was raised.
     */
    public val errorCode: aws.sdk.kotlin.services.resourcegroups.model.QueryErrorCode? = builder.errorCode
    /**
     * A message that explains the `ErrorCode` value. Messages might state that the specified CloudFront stack does not exist (or no longer exists). For `CLOUDFORMATION_STACK_INACTIVE`, the message typically states that the CloudFront stack has a status that is not (or no longer) active, such as `CREATE_FAILED`.
     */
    public val message: kotlin.String? = builder.message

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.QueryError = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("QueryError(")
        append("errorCode=$errorCode,")
        append("message=$message")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = errorCode?.hashCode() ?: 0
        result = 31 * result + (message?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as QueryError

        if (errorCode != other.errorCode) return false
        if (message != other.message) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.QueryError = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Specifies the error code that was raised.
         */
        public var errorCode: aws.sdk.kotlin.services.resourcegroups.model.QueryErrorCode? = null
        /**
         * A message that explains the `ErrorCode` value. Messages might state that the specified CloudFront stack does not exist (or no longer exists). For `CLOUDFORMATION_STACK_INACTIVE`, the message typically states that the CloudFront stack has a status that is not (or no longer) active, such as `CREATE_FAILED`.
         */
        public var message: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.QueryError) : this() {
            this.errorCode = x.errorCode
            this.message = x.message
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.QueryError = QueryError(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
