// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



public class PutGroupConfigurationRequest private constructor(builder: Builder) {
    /**
     * The new configuration to associate with the specified group. A configuration associates the resource group with an Amazon Web Services service and specifies how the service can interact with the resources in the group. A configuration is an array of GroupConfigurationItem elements.
     *
     * For information about the syntax of a service configuration, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
     *
     * A resource group can contain either a `Configuration` or a `ResourceQuery`, but not both.
     */
    public val configuration: List<GroupConfigurationItem>? = builder.configuration
    /**
     * The name or ARN of the resource group with the configuration that you want to update.
     */
    public val group: kotlin.String? = builder.group

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.PutGroupConfigurationRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PutGroupConfigurationRequest(")
        append("configuration=$configuration,")
        append("group=$group")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (group?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PutGroupConfigurationRequest

        if (configuration != other.configuration) return false
        if (group != other.group) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.PutGroupConfigurationRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The new configuration to associate with the specified group. A configuration associates the resource group with an Amazon Web Services service and specifies how the service can interact with the resources in the group. A configuration is an array of GroupConfigurationItem elements.
         *
         * For information about the syntax of a service configuration, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
         *
         * A resource group can contain either a `Configuration` or a `ResourceQuery`, but not both.
         */
        public var configuration: List<GroupConfigurationItem>? = null
        /**
         * The name or ARN of the resource group with the configuration that you want to update.
         */
        public var group: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.PutGroupConfigurationRequest) : this() {
            this.configuration = x.configuration
            this.group = x.group
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.PutGroupConfigurationRequest = PutGroupConfigurationRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
