// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



public class ListGroupResourcesRequest private constructor(builder: Builder) {
    /**
     * Filters, formatted as ResourceFilter objects, that you want to apply to a `ListGroupResources` operation. Filters the results to include only those of the specified resource types.
     * + `resource-type` - Filter resources by their type. Specify up to five resource types in the format `AWS::ServiceCode::ResourceType`. For example, `AWS::EC2::Instance`, or `AWS::S3::Bucket`.
     *
     * When you specify a `resource-type` filter for `ListGroupResources`, Resource Groups validates your filter resource types against the types that are defined in the query associated with the group. For example, if a group contains only S3 buckets because its query specifies only that resource type, but your `resource-type` filter includes EC2 instances, AWS Resource Groups does not filter for EC2 instances. In this case, a `ListGroupResources` request returns a `BadRequestException` error with a message similar to the following:
     *
     * `The resource types specified as filters in the request are not valid.`
     *
     * The error includes a list of resource types that failed the validation because they are not part of the query associated with the group. This validation doesn't occur when the group query specifies `AWS::AllSupported`, because a group based on such a query can contain any of the allowed resource types for the query type (tag-based or Amazon CloudFront stack-based queries).
     */
    public val filters: List<ResourceFilter>? = builder.filters
    /**
     * The name or the ARN of the resource group
     */
    public val group: kotlin.String? = builder.group
    /**
     * ***Deprecated - don't use this parameter. Use the `Group` request field instead.***
     */
    @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
    public val groupName: kotlin.String? = builder.groupName
    /**
     * The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the `NextToken` response element is present and has a value (is not null). Include that value as the `NextToken` request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check `NextToken` after every operation to ensure that you receive all of the results.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * The parameter for receiving additional results if you receive a `NextToken` response in a previous request. A `NextToken` response indicates that more output is available. Set this parameter to the value provided by a previous call's `NextToken` response to indicate where the output should continue from.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListGroupResourcesRequest(")
        append("filters=$filters,")
        append("group=$group,")
        append("groupName=$groupName,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = filters?.hashCode() ?: 0
        result = 31 * result + (group?.hashCode() ?: 0)
        result = 31 * result + (groupName?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListGroupResourcesRequest

        if (filters != other.filters) return false
        if (group != other.group) return false
        if (groupName != other.groupName) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * Filters, formatted as ResourceFilter objects, that you want to apply to a `ListGroupResources` operation. Filters the results to include only those of the specified resource types.
         * + `resource-type` - Filter resources by their type. Specify up to five resource types in the format `AWS::ServiceCode::ResourceType`. For example, `AWS::EC2::Instance`, or `AWS::S3::Bucket`.
         *
         * When you specify a `resource-type` filter for `ListGroupResources`, Resource Groups validates your filter resource types against the types that are defined in the query associated with the group. For example, if a group contains only S3 buckets because its query specifies only that resource type, but your `resource-type` filter includes EC2 instances, AWS Resource Groups does not filter for EC2 instances. In this case, a `ListGroupResources` request returns a `BadRequestException` error with a message similar to the following:
         *
         * `The resource types specified as filters in the request are not valid.`
         *
         * The error includes a list of resource types that failed the validation because they are not part of the query associated with the group. This validation doesn't occur when the group query specifies `AWS::AllSupported`, because a group based on such a query can contain any of the allowed resource types for the query type (tag-based or Amazon CloudFront stack-based queries).
         */
        public var filters: List<ResourceFilter>? = null
        /**
         * The name or the ARN of the resource group
         */
        public var group: kotlin.String? = null
        /**
         * ***Deprecated - don't use this parameter. Use the `Group` request field instead.***
         */
        @Deprecated("No longer recommended for use. See AWS API documentation for more details.")
        public var groupName: kotlin.String? = null
        /**
         * The total number of results that you want included on each page of the response. If you do not include this parameter, it defaults to a value that is specific to the operation. If additional items exist beyond the maximum you specify, the `NextToken` response element is present and has a value (is not null). Include that value as the `NextToken` request parameter in the next call to the operation to get the next part of the results. Note that the service might return fewer results than the maximum even when there are more results available. You should check `NextToken` after every operation to ensure that you receive all of the results.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * The parameter for receiving additional results if you receive a `NextToken` response in a previous request. A `NextToken` response indicates that more output is available. Set this parameter to the value provided by a previous call's `NextToken` response to indicate where the output should continue from.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesRequest) : this() {
            this.filters = x.filters
            this.group = x.group
            this.groupName = x.groupName
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesRequest = ListGroupResourcesRequest(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
