// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



/**
 * A mapping of a query attached to a resource group that determines the Amazon Web Services resources that are members of the group.
 */
public class GroupQuery private constructor(builder: Builder) {
    /**
     * The name of the resource group that is associated with the specified resource query.
     */
    public val groupName: kotlin.String = requireNotNull(builder.groupName) { "A non-null value must be provided for groupName" }
    /**
     * The resource query that determines which Amazon Web Services resources are members of the associated resource group.
     */
    public val resourceQuery: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery? = builder.resourceQuery

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.GroupQuery = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupQuery(")
        append("groupName=$groupName,")
        append("resourceQuery=$resourceQuery")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = groupName.hashCode()
        result = 31 * result + (resourceQuery?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupQuery

        if (groupName != other.groupName) return false
        if (resourceQuery != other.resourceQuery) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.GroupQuery = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The name of the resource group that is associated with the specified resource query.
         */
        public var groupName: kotlin.String? = null
        /**
         * The resource query that determines which Amazon Web Services resources are members of the associated resource group.
         */
        public var resourceQuery: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.GroupQuery) : this() {
            this.groupName = x.groupName
            this.resourceQuery = x.resourceQuery
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.GroupQuery = GroupQuery(this)

        /**
         * construct an [aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery] inside the given [block]
         */
        public fun resourceQuery(block: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery.Builder.() -> kotlin.Unit) {
            this.resourceQuery = aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (groupName == null) groupName = ""
            return this
        }
    }
}
