// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



/**
 * An item in a group configuration. A group service configuration can have one or more items. For details about group service configuration syntax, see [Service configurations for resource groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
 */
public class GroupConfigurationItem private constructor(builder: Builder) {
    /**
     * A collection of parameters for this group configuration item. For the list of parameters that you can use with each configuration item type, see [Supported resource types and parameters](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html#about-slg-types).
     */
    public val parameters: List<GroupConfigurationParameter>? = builder.parameters
    /**
     * Specifies the type of group configuration item. Each item must have a unique value for `type`. For the list of types that you can specify for a configuration item, see [Supported resource types and parameters](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html#about-slg-types).
     */
    public val type: kotlin.String = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.GroupConfigurationItem = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupConfigurationItem(")
        append("parameters=$parameters,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = parameters?.hashCode() ?: 0
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupConfigurationItem

        if (parameters != other.parameters) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.GroupConfigurationItem = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A collection of parameters for this group configuration item. For the list of parameters that you can use with each configuration item type, see [Supported resource types and parameters](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html#about-slg-types).
         */
        public var parameters: List<GroupConfigurationParameter>? = null
        /**
         * Specifies the type of group configuration item. Each item must have a unique value for `type`. For the list of types that you can specify for a configuration item, see [Supported resource types and parameters](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html#about-slg-types).
         */
        public var type: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.GroupConfigurationItem) : this() {
            this.parameters = x.parameters
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.GroupConfigurationItem = GroupConfigurationItem(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = ""
            return this
        }
    }
}
