// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



/**
 * A service configuration associated with a resource group. The configuration options are determined by the Amazon Web Services service that defines the `Type`, and specifies which resources can be included in the group. You can add a service configuration when you create the group by using CreateGroup, or later by using the PutGroupConfiguration operation. For details about group service configuration syntax, see [Service configurations for resource groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
 */
public class GroupConfiguration private constructor(builder: Builder) {
    /**
     * The configuration currently associated with the group and in effect.
     */
    public val configuration: List<GroupConfigurationItem>? = builder.configuration
    /**
     * If present, the reason why a request to update the group configuration failed.
     */
    public val failureReason: kotlin.String? = builder.failureReason
    /**
     * If present, the new configuration that is in the process of being applied to the group.
     */
    public val proposedConfiguration: List<GroupConfigurationItem>? = builder.proposedConfiguration
    /**
     * The current status of an attempt to update the group configuration.
     */
    public val status: aws.sdk.kotlin.services.resourcegroups.model.GroupConfigurationStatus? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupConfiguration(")
        append("configuration=$configuration,")
        append("failureReason=$failureReason,")
        append("proposedConfiguration=$proposedConfiguration,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (failureReason?.hashCode() ?: 0)
        result = 31 * result + (proposedConfiguration?.hashCode() ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupConfiguration

        if (configuration != other.configuration) return false
        if (failureReason != other.failureReason) return false
        if (proposedConfiguration != other.proposedConfiguration) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The configuration currently associated with the group and in effect.
         */
        public var configuration: List<GroupConfigurationItem>? = null
        /**
         * If present, the reason why a request to update the group configuration failed.
         */
        public var failureReason: kotlin.String? = null
        /**
         * If present, the new configuration that is in the process of being applied to the group.
         */
        public var proposedConfiguration: List<GroupConfigurationItem>? = null
        /**
         * The current status of an attempt to update the group configuration.
         */
        public var status: aws.sdk.kotlin.services.resourcegroups.model.GroupConfigurationStatus? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration) : this() {
            this.configuration = x.configuration
            this.failureReason = x.failureReason
            this.proposedConfiguration = x.proposedConfiguration
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration = GroupConfiguration(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
