// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



/**
 * A resource group that contains Amazon Web Services resources. You can assign resources to the group by associating either of the following elements with the group:
 * + ResourceQuery - Use a resource query to specify a set of tag keys and values. All resources in the same Amazon Web Services Region and Amazon Web Services account that have those keys with the same values are included in the group. You can add a resource query when you create the group, or later by using the PutGroupConfiguration operation.
 * + GroupConfiguration - Use a service configuration to associate the group with an Amazon Web Services service. The configuration specifies which resource types can be included in the group.
 */
public class Group private constructor(builder: Builder) {
    /**
     * The description of the resource group.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The ARN of the resource group.
     */
    public val groupArn: kotlin.String = requireNotNull(builder.groupArn) { "A non-null value must be provided for groupArn" }
    /**
     * The name of the resource group.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.Group = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("Group(")
        append("description=$description,")
        append("groupArn=$groupArn,")
        append("name=$name")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = description?.hashCode() ?: 0
        result = 31 * result + (groupArn.hashCode())
        result = 31 * result + (name.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as Group

        if (description != other.description) return false
        if (groupArn != other.groupArn) return false
        if (name != other.name) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.Group = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the resource group.
         */
        public var description: kotlin.String? = null
        /**
         * The ARN of the resource group.
         */
        public var groupArn: kotlin.String? = null
        /**
         * The name of the resource group.
         */
        public var name: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.Group) : this() {
            this.description = x.description
            this.groupArn = x.groupArn
            this.name = x.name
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.Group = Group(this)

        internal fun correctErrors(): Builder {
            if (groupArn == null) groupArn = ""
            if (name == null) name = ""
            return this
        }
    }
}
