// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



public class CreateGroupResponse private constructor(builder: Builder) {
    /**
     * The description of the resource group.
     */
    public val group: aws.sdk.kotlin.services.resourcegroups.model.Group? = builder.group
    /**
     * The service configuration associated with the resource group. For details about the syntax of a service configuration, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
     */
    public val groupConfiguration: aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration? = builder.groupConfiguration
    /**
     * The resource query associated with the group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
     */
    public val resourceQuery: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery? = builder.resourceQuery
    /**
     * The tags associated with the group.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.CreateGroupResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGroupResponse(")
        append("group=$group,")
        append("groupConfiguration=$groupConfiguration,")
        append("resourceQuery=$resourceQuery,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = group?.hashCode() ?: 0
        result = 31 * result + (groupConfiguration?.hashCode() ?: 0)
        result = 31 * result + (resourceQuery?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGroupResponse

        if (group != other.group) return false
        if (groupConfiguration != other.groupConfiguration) return false
        if (resourceQuery != other.resourceQuery) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.CreateGroupResponse = Builder(this).apply(block).build()

    public class Builder {
        /**
         * The description of the resource group.
         */
        public var group: aws.sdk.kotlin.services.resourcegroups.model.Group? = null
        /**
         * The service configuration associated with the resource group. For details about the syntax of a service configuration, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
         */
        public var groupConfiguration: aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration? = null
        /**
         * The resource query associated with the group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
         */
        public var resourceQuery: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery? = null
        /**
         * The tags associated with the group.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.CreateGroupResponse) : this() {
            this.group = x.group
            this.groupConfiguration = x.groupConfiguration
            this.resourceQuery = x.resourceQuery
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.CreateGroupResponse = CreateGroupResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.resourcegroups.model.Group] inside the given [block]
         */
        public fun group(block: aws.sdk.kotlin.services.resourcegroups.model.Group.Builder.() -> kotlin.Unit) {
            this.group = aws.sdk.kotlin.services.resourcegroups.model.Group.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration] inside the given [block]
         */
        public fun groupConfiguration(block: aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration.Builder.() -> kotlin.Unit) {
            this.groupConfiguration = aws.sdk.kotlin.services.resourcegroups.model.GroupConfiguration.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery] inside the given [block]
         */
        public fun resourceQuery(block: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery.Builder.() -> kotlin.Unit) {
            this.resourceQuery = aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
