// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups.model



public class CreateGroupRequest private constructor(builder: Builder) {
    /**
     * A configuration associates the resource group with an Amazon Web Services service and specifies how the service can interact with the resources in the group. A configuration is an array of GroupConfigurationItem elements. For details about the syntax of service configurations, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
     *
     * A resource group can contain either a `Configuration` or a `ResourceQuery`, but not both.
     */
    public val configuration: List<GroupConfigurationItem>? = builder.configuration
    /**
     * The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores, periods, and spaces.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The name of the group, which is the identifier of the group in other operations. You can't change the name of a resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and underscores. The name cannot start with `AWS` or `aws`; these are reserved. A resource group name must be unique within each Amazon Web Services Region in your Amazon Web Services account.
     */
    public val name: kotlin.String? = builder.name
    /**
     * The resource query that determines which Amazon Web Services resources are members of this group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
     *
     * A resource group can contain either a `ResourceQuery` or a `Configuration`, but not both.
     */
    public val resourceQuery: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery? = builder.resourceQuery
    /**
     * The tags to add to the group. A tag is key-value pair string.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resourcegroups.model.CreateGroupRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateGroupRequest(")
        append("configuration=$configuration,")
        append("description=$description,")
        append("name=$name,")
        append("resourceQuery=$resourceQuery,")
        append("tags=$tags")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = configuration?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (resourceQuery?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateGroupRequest

        if (configuration != other.configuration) return false
        if (description != other.description) return false
        if (name != other.name) return false
        if (resourceQuery != other.resourceQuery) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resourcegroups.model.CreateGroupRequest = Builder(this).apply(block).build()

    public class Builder {
        /**
         * A configuration associates the resource group with an Amazon Web Services service and specifies how the service can interact with the resources in the group. A configuration is an array of GroupConfigurationItem elements. For details about the syntax of service configurations, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
         *
         * A resource group can contain either a `Configuration` or a `ResourceQuery`, but not both.
         */
        public var configuration: List<GroupConfigurationItem>? = null
        /**
         * The description of the resource group. Descriptions can consist of letters, numbers, hyphens, underscores, periods, and spaces.
         */
        public var description: kotlin.String? = null
        /**
         * The name of the group, which is the identifier of the group in other operations. You can't change the name of a resource group after you create it. A resource group name can consist of letters, numbers, hyphens, periods, and underscores. The name cannot start with `AWS` or `aws`; these are reserved. A resource group name must be unique within each Amazon Web Services Region in your Amazon Web Services account.
         */
        public var name: kotlin.String? = null
        /**
         * The resource query that determines which Amazon Web Services resources are members of this group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
         *
         * A resource group can contain either a `ResourceQuery` or a `Configuration`, but not both.
         */
        public var resourceQuery: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery? = null
        /**
         * The tags to add to the group. A tag is key-value pair string.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resourcegroups.model.CreateGroupRequest) : this() {
            this.configuration = x.configuration
            this.description = x.description
            this.name = x.name
            this.resourceQuery = x.resourceQuery
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resourcegroups.model.CreateGroupRequest = CreateGroupRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery] inside the given [block]
         */
        public fun resourceQuery(block: aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery.Builder.() -> kotlin.Unit) {
            this.resourceQuery = aws.sdk.kotlin.services.resourcegroups.model.ResourceQuery.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
