// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resourcegroups

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.client.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsDefaultRetryPolicy
import aws.sdk.kotlin.services.resourcegroups.auth.DefaultResourceGroupsAuthSchemeProvider
import aws.sdk.kotlin.services.resourcegroups.auth.ResourceGroupsAuthSchemeProvider
import aws.sdk.kotlin.services.resourcegroups.endpoints.DefaultResourceGroupsEndpointProvider
import aws.sdk.kotlin.services.resourcegroups.endpoints.ResourceGroupsEndpointParameters
import aws.sdk.kotlin.services.resourcegroups.endpoints.ResourceGroupsEndpointProvider
import aws.sdk.kotlin.services.resourcegroups.model.CreateGroupRequest
import aws.sdk.kotlin.services.resourcegroups.model.CreateGroupResponse
import aws.sdk.kotlin.services.resourcegroups.model.DeleteGroupRequest
import aws.sdk.kotlin.services.resourcegroups.model.DeleteGroupResponse
import aws.sdk.kotlin.services.resourcegroups.model.GetAccountSettingsRequest
import aws.sdk.kotlin.services.resourcegroups.model.GetAccountSettingsResponse
import aws.sdk.kotlin.services.resourcegroups.model.GetGroupConfigurationRequest
import aws.sdk.kotlin.services.resourcegroups.model.GetGroupConfigurationResponse
import aws.sdk.kotlin.services.resourcegroups.model.GetGroupQueryRequest
import aws.sdk.kotlin.services.resourcegroups.model.GetGroupQueryResponse
import aws.sdk.kotlin.services.resourcegroups.model.GetGroupRequest
import aws.sdk.kotlin.services.resourcegroups.model.GetGroupResponse
import aws.sdk.kotlin.services.resourcegroups.model.GetTagsRequest
import aws.sdk.kotlin.services.resourcegroups.model.GetTagsResponse
import aws.sdk.kotlin.services.resourcegroups.model.GroupResourcesRequest
import aws.sdk.kotlin.services.resourcegroups.model.GroupResourcesResponse
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesRequest
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupResourcesResponse
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupsRequest
import aws.sdk.kotlin.services.resourcegroups.model.ListGroupsResponse
import aws.sdk.kotlin.services.resourcegroups.model.PutGroupConfigurationRequest
import aws.sdk.kotlin.services.resourcegroups.model.PutGroupConfigurationResponse
import aws.sdk.kotlin.services.resourcegroups.model.SearchResourcesRequest
import aws.sdk.kotlin.services.resourcegroups.model.SearchResourcesResponse
import aws.sdk.kotlin.services.resourcegroups.model.TagRequest
import aws.sdk.kotlin.services.resourcegroups.model.TagResponse
import aws.sdk.kotlin.services.resourcegroups.model.UngroupResourcesRequest
import aws.sdk.kotlin.services.resourcegroups.model.UngroupResourcesResponse
import aws.sdk.kotlin.services.resourcegroups.model.UntagRequest
import aws.sdk.kotlin.services.resourcegroups.model.UntagResponse
import aws.sdk.kotlin.services.resourcegroups.model.UpdateAccountSettingsRequest
import aws.sdk.kotlin.services.resourcegroups.model.UpdateAccountSettingsResponse
import aws.sdk.kotlin.services.resourcegroups.model.UpdateGroupQueryRequest
import aws.sdk.kotlin.services.resourcegroups.model.UpdateGroupQueryResponse
import aws.sdk.kotlin.services.resourcegroups.model.UpdateGroupRequest
import aws.sdk.kotlin.services.resourcegroups.model.UpdateGroupResponse
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.SdkClientFactory
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic


public const val ServiceId: String = "Resource Groups"
public const val SdkVersion: String = "0.34.4-beta"

/**
 * Resource Groups lets you organize Amazon Web Services resources such as Amazon Elastic Compute Cloud instances, Amazon Relational Database Service databases, and Amazon Simple Storage Service buckets into groups using criteria that you define as tags. A resource group is a collection of resources that match the resource types specified in a query, and share one or more tags or portions of tags. You can create a group of resources based on their roles in your cloud infrastructure, lifecycle stages, regions, application layers, or virtually any criteria. Resource Groups enable you to automate management tasks, such as those in Amazon Web Services Systems Manager Automation documents, on tag-related resources in Amazon Web Services Systems Manager. Groups of tagged resources also let you quickly view a custom console in Amazon Web Services Systems Manager that shows Config compliance and other monitoring data about member resources.
 *
 * To create a resource group, build a resource query, and specify tags that identify the criteria that members of the group have in common. Tags are key-value pairs.
 *
 * For more information about Resource Groups, see the [Resource Groups User Guide](https://docs.aws.amazon.com/ARG/latest/userguide/welcome.html).
 *
 * Resource Groups uses a REST-compliant API that you can use to perform the following types of operations.
 * + Create, Read, Update, and Delete (CRUD) operations on resource groups and resource query entities
 * + Applying, editing, and removing tags from resource groups
 * + Resolving resource group member ARNs so they can be returned as search results
 * + Getting data about resources that are members of a group
 * + Searching Amazon Web Services resources based on a resource query
 */
public interface ResourceGroupsClient : SdkClient {
    /**
     * ResourceGroupsClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ResourceGroupsClient, Builder>() {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override suspend fun finalizeConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>) {
            builder.config.interceptors.add(0, ClockSkewInterceptor())
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "ResourceGroups",
                "RESOURCE_GROUPS",
                "resource_groups",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ResourceGroupsClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ResourceGroupsClient = DefaultResourceGroupsClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region
        public val authSchemeProvider: ResourceGroupsAuthSchemeProvider = builder.authSchemeProvider ?: DefaultResourceGroupsAuthSchemeProvider
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ResourceGroupsEndpointProvider = builder.endpointProvider ?: DefaultResourceGroupsEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsDefaultRetryPolicy
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            authSchemeProvider = this@Config.authSchemeProvider
            authSchemes = this@Config.authSchemes
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "Resource Groups"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more
             * information
             */
            override var region: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ResourceGroupsAuthSchemeProvider? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ResourceGroupsEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Creates a resource group with the specified name and description. You can optionally include either a resource query or a service configuration. For more information about constructing a resource query, see [Build queries and groups in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/getting_started-query.html) in the *Resource Groups User Guide*. For more information about service-linked groups and service configurations, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:CreateGroup`
     */
    public suspend fun createGroup(input: CreateGroupRequest): CreateGroupResponse

    /**
     * Deletes the specified resource group. Deleting a resource group does not delete any resources that are members of the group; it only deletes the group structure.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:DeleteGroup`
     */
    public suspend fun deleteGroup(input: DeleteGroupRequest = DeleteGroupRequest { }): DeleteGroupResponse

    /**
     * Retrieves the current status of optional features in Resource Groups.
     */
    public suspend fun getAccountSettings(input: GetAccountSettingsRequest = GetAccountSettingsRequest { }): GetAccountSettingsResponse

    /**
     * Returns information about a specified resource group.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:GetGroup`
     */
    public suspend fun getGroup(input: GetGroupRequest = GetGroupRequest { }): GetGroupResponse

    /**
     * Retrieves the service configuration associated with the specified resource group. For details about the service configuration syntax, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:GetGroupConfiguration`
     */
    public suspend fun getGroupConfiguration(input: GetGroupConfigurationRequest = GetGroupConfigurationRequest { }): GetGroupConfigurationResponse

    /**
     * Retrieves the resource query associated with the specified resource group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:GetGroupQuery`
     */
    public suspend fun getGroupQuery(input: GetGroupQueryRequest = GetGroupQueryRequest { }): GetGroupQueryResponse

    /**
     * Returns a list of tags that are associated with a resource group, specified by an ARN.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:GetTags`
     */
    public suspend fun getTags(input: GetTagsRequest): GetTagsResponse

    /**
     * Adds the specified resources to the specified group.
     *
     * You can use this operation with only resource groups that are configured with the following types:
     * + `AWS::EC2::HostManagement`
     * + `AWS::EC2::CapacityReservationPool`
     * Other resource group type and resource types aren't currently supported by this operation.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:GroupResources`
     */
    public suspend fun groupResources(input: GroupResourcesRequest): GroupResourcesResponse

    /**
     * Returns a list of ARNs of the resources that are members of a specified resource group.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:ListGroupResources`
     * + `cloudformation:DescribeStacks`
     * + `cloudformation:ListStackResources`
     * + `tag:GetResources`
     */
    public suspend fun listGroupResources(input: ListGroupResourcesRequest = ListGroupResourcesRequest { }): ListGroupResourcesResponse

    /**
     * Returns a list of existing Resource Groups in your account.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:ListGroups`
     */
    public suspend fun listGroups(input: ListGroupsRequest = ListGroupsRequest { }): ListGroupsResponse

    /**
     * Attaches a service configuration to the specified group. This occurs asynchronously, and can take time to complete. You can use GetGroupConfiguration to check the status of the update.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:PutGroupConfiguration`
     */
    public suspend fun putGroupConfiguration(input: PutGroupConfigurationRequest = PutGroupConfigurationRequest { }): PutGroupConfigurationResponse

    /**
     * Returns a list of Amazon Web Services resource identifiers that matches the specified query. The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery operation.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:SearchResources`
     * + `cloudformation:DescribeStacks`
     * + `cloudformation:ListStackResources`
     * + `tag:GetResources`
     */
    public suspend fun searchResources(input: SearchResourcesRequest): SearchResourcesResponse

    /**
     * Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they are not specified in the request parameters.
     *
     * Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:Tag`
     */
    public suspend fun tag(input: TagRequest): TagResponse

    /**
     * Removes the specified resources from the specified group. This operation works only with static groups that you populated using the GroupResources operation. It doesn't work with any resource groups that are automatically populated by tag-based or CloudFormation stack-based queries.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:UngroupResources`
     */
    public suspend fun ungroupResources(input: UngroupResourcesRequest): UngroupResourcesResponse

    /**
     * Deletes tags from a specified resource group.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:Untag`
     */
    public suspend fun untag(input: UntagRequest): UntagResponse

    /**
     * Turns on or turns off optional features in Resource Groups.
     *
     * The preceding example shows that the request to turn on group lifecycle events is `IN_PROGRESS`. You can call the GetAccountSettings operation to check for completion by looking for `GroupLifecycleEventsStatus` to change to `ACTIVE`.
     */
    public suspend fun updateAccountSettings(input: UpdateAccountSettingsRequest = UpdateAccountSettingsRequest { }): UpdateAccountSettingsResponse

    /**
     * Updates the description for an existing group. You cannot update the name of a resource group.
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:UpdateGroup`
     */
    public suspend fun updateGroup(input: UpdateGroupRequest = UpdateGroupRequest { }): UpdateGroupResponse

    /**
     * Updates the resource query of a group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
     *
     * **Minimum permissions**
     *
     * To run this command, you must have the following permissions:
     * + `resource-groups:UpdateGroupQuery`
     */
    public suspend fun updateGroupQuery(input: UpdateGroupQueryRequest): UpdateGroupQueryResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ResourceGroupsClient.withConfig(block: ResourceGroupsClient.Config.Builder.() -> Unit): ResourceGroupsClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultResourceGroupsClient(newConfig)
}

/**
 * Creates a resource group with the specified name and description. You can optionally include either a resource query or a service configuration. For more information about constructing a resource query, see [Build queries and groups in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/getting_started-query.html) in the *Resource Groups User Guide*. For more information about service-linked groups and service configurations, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:CreateGroup`
 */
public suspend inline fun ResourceGroupsClient.createGroup(crossinline block: CreateGroupRequest.Builder.() -> Unit): CreateGroupResponse = createGroup(CreateGroupRequest.Builder().apply(block).build())

/**
 * Deletes the specified resource group. Deleting a resource group does not delete any resources that are members of the group; it only deletes the group structure.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:DeleteGroup`
 */
public suspend inline fun ResourceGroupsClient.deleteGroup(crossinline block: DeleteGroupRequest.Builder.() -> Unit): DeleteGroupResponse = deleteGroup(DeleteGroupRequest.Builder().apply(block).build())

/**
 * Retrieves the current status of optional features in Resource Groups.
 */
public suspend inline fun ResourceGroupsClient.getAccountSettings(crossinline block: GetAccountSettingsRequest.Builder.() -> Unit): GetAccountSettingsResponse = getAccountSettings(GetAccountSettingsRequest.Builder().apply(block).build())

/**
 * Returns information about a specified resource group.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:GetGroup`
 */
public suspend inline fun ResourceGroupsClient.getGroup(crossinline block: GetGroupRequest.Builder.() -> Unit): GetGroupResponse = getGroup(GetGroupRequest.Builder().apply(block).build())

/**
 * Retrieves the service configuration associated with the specified resource group. For details about the service configuration syntax, see [Service configurations for Resource Groups](https://docs.aws.amazon.com/ARG/latest/APIReference/about-slg.html).
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:GetGroupConfiguration`
 */
public suspend inline fun ResourceGroupsClient.getGroupConfiguration(crossinline block: GetGroupConfigurationRequest.Builder.() -> Unit): GetGroupConfigurationResponse = getGroupConfiguration(GetGroupConfigurationRequest.Builder().apply(block).build())

/**
 * Retrieves the resource query associated with the specified resource group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:GetGroupQuery`
 */
public suspend inline fun ResourceGroupsClient.getGroupQuery(crossinline block: GetGroupQueryRequest.Builder.() -> Unit): GetGroupQueryResponse = getGroupQuery(GetGroupQueryRequest.Builder().apply(block).build())

/**
 * Returns a list of tags that are associated with a resource group, specified by an ARN.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:GetTags`
 */
public suspend inline fun ResourceGroupsClient.getTags(crossinline block: GetTagsRequest.Builder.() -> Unit): GetTagsResponse = getTags(GetTagsRequest.Builder().apply(block).build())

/**
 * Adds the specified resources to the specified group.
 *
 * You can use this operation with only resource groups that are configured with the following types:
 * + `AWS::EC2::HostManagement`
 * + `AWS::EC2::CapacityReservationPool`
 * Other resource group type and resource types aren't currently supported by this operation.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:GroupResources`
 */
public suspend inline fun ResourceGroupsClient.groupResources(crossinline block: GroupResourcesRequest.Builder.() -> Unit): GroupResourcesResponse = groupResources(GroupResourcesRequest.Builder().apply(block).build())

/**
 * Returns a list of ARNs of the resources that are members of a specified resource group.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:ListGroupResources`
 * + `cloudformation:DescribeStacks`
 * + `cloudformation:ListStackResources`
 * + `tag:GetResources`
 */
public suspend inline fun ResourceGroupsClient.listGroupResources(crossinline block: ListGroupResourcesRequest.Builder.() -> Unit): ListGroupResourcesResponse = listGroupResources(ListGroupResourcesRequest.Builder().apply(block).build())

/**
 * Returns a list of existing Resource Groups in your account.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:ListGroups`
 */
public suspend inline fun ResourceGroupsClient.listGroups(crossinline block: ListGroupsRequest.Builder.() -> Unit): ListGroupsResponse = listGroups(ListGroupsRequest.Builder().apply(block).build())

/**
 * Attaches a service configuration to the specified group. This occurs asynchronously, and can take time to complete. You can use GetGroupConfiguration to check the status of the update.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:PutGroupConfiguration`
 */
public suspend inline fun ResourceGroupsClient.putGroupConfiguration(crossinline block: PutGroupConfigurationRequest.Builder.() -> Unit): PutGroupConfigurationResponse = putGroupConfiguration(PutGroupConfigurationRequest.Builder().apply(block).build())

/**
 * Returns a list of Amazon Web Services resource identifiers that matches the specified query. The query uses the same format as a resource query in a CreateGroup or UpdateGroupQuery operation.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:SearchResources`
 * + `cloudformation:DescribeStacks`
 * + `cloudformation:ListStackResources`
 * + `tag:GetResources`
 */
public suspend inline fun ResourceGroupsClient.searchResources(crossinline block: SearchResourcesRequest.Builder.() -> Unit): SearchResourcesResponse = searchResources(SearchResourcesRequest.Builder().apply(block).build())

/**
 * Adds tags to a resource group with the specified ARN. Existing tags on a resource group are not changed if they are not specified in the request parameters.
 *
 * Do not store personally identifiable information (PII) or other confidential or sensitive information in tags. We use tags to provide you with billing and administration services. Tags are not intended to be used for private or sensitive data.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:Tag`
 */
public suspend inline fun ResourceGroupsClient.tag(crossinline block: TagRequest.Builder.() -> Unit): TagResponse = tag(TagRequest.Builder().apply(block).build())

/**
 * Removes the specified resources from the specified group. This operation works only with static groups that you populated using the GroupResources operation. It doesn't work with any resource groups that are automatically populated by tag-based or CloudFormation stack-based queries.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:UngroupResources`
 */
public suspend inline fun ResourceGroupsClient.ungroupResources(crossinline block: UngroupResourcesRequest.Builder.() -> Unit): UngroupResourcesResponse = ungroupResources(UngroupResourcesRequest.Builder().apply(block).build())

/**
 * Deletes tags from a specified resource group.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:Untag`
 */
public suspend inline fun ResourceGroupsClient.untag(crossinline block: UntagRequest.Builder.() -> Unit): UntagResponse = untag(UntagRequest.Builder().apply(block).build())

/**
 * Turns on or turns off optional features in Resource Groups.
 *
 * The preceding example shows that the request to turn on group lifecycle events is `IN_PROGRESS`. You can call the GetAccountSettings operation to check for completion by looking for `GroupLifecycleEventsStatus` to change to `ACTIVE`.
 */
public suspend inline fun ResourceGroupsClient.updateAccountSettings(crossinline block: UpdateAccountSettingsRequest.Builder.() -> Unit): UpdateAccountSettingsResponse = updateAccountSettings(UpdateAccountSettingsRequest.Builder().apply(block).build())

/**
 * Updates the description for an existing group. You cannot update the name of a resource group.
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:UpdateGroup`
 */
public suspend inline fun ResourceGroupsClient.updateGroup(crossinline block: UpdateGroupRequest.Builder.() -> Unit): UpdateGroupResponse = updateGroup(UpdateGroupRequest.Builder().apply(block).build())

/**
 * Updates the resource query of a group. For more information about resource queries, see [Create a tag-based group in Resource Groups](https://docs.aws.amazon.com/ARG/latest/userguide/gettingstarted-query.html#gettingstarted-query-cli-tag).
 *
 * **Minimum permissions**
 *
 * To run this command, you must have the following permissions:
 * + `resource-groups:UpdateGroupQuery`
 */
public suspend inline fun ResourceGroupsClient.updateGroupQuery(crossinline block: UpdateGroupQueryRequest.Builder.() -> Unit): UpdateGroupQueryResponse = updateGroupQuery(UpdateGroupQueryRequest.Builder().apply(block).build())
