// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.serde

import aws.sdk.kotlin.services.resiliencehub.model.EksSource
import aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse
import aws.sdk.kotlin.services.resiliencehub.model.ResiliencehubException
import aws.sdk.kotlin.services.resiliencehub.model.ResourceImportStatusType
import aws.sdk.kotlin.services.resiliencehub.model.TerraformSource
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class ImportResourcesToDraftAppVersionOperationDeserializer: HttpDeserializer.NonStreaming<ImportResourcesToDraftAppVersionResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ImportResourcesToDraftAppVersionResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwImportResourcesToDraftAppVersionError(context, call, payload)
        }
        val builder = ImportResourcesToDraftAppVersionResponse.Builder()

        if (payload != null) {
            deserializeImportResourcesToDraftAppVersionOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwImportResourcesToDraftAppVersionError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ResiliencehubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ServiceQuotaExceededException" -> ServiceQuotaExceededExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ResiliencehubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeImportResourcesToDraftAppVersionOperationBody(builder: ImportResourcesToDraftAppVersionResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appArn"))
    val APPVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appVersion"))
    val EKSSOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("eksSources"))
    val SOURCEARNS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("sourceArns"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val TERRAFORMSOURCES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("terraformSources"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPARN_DESCRIPTOR)
        field(APPVERSION_DESCRIPTOR)
        field(EKSSOURCES_DESCRIPTOR)
        field(SOURCEARNS_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(TERRAFORMSOURCES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPARN_DESCRIPTOR.index -> builder.appArn = deserializeString()
                APPVERSION_DESCRIPTOR.index -> builder.appVersion = deserializeString()
                EKSSOURCES_DESCRIPTOR.index -> builder.eksSources =
                    deserializer.deserializeList(EKSSOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<EksSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeEksSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SOURCEARNS_DESCRIPTOR.index -> builder.sourceArns =
                    deserializer.deserializeList(SOURCEARNS_DESCRIPTOR) {
                        val col0 = mutableListOf<String>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeString() } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ResourceImportStatusType.fromValue(it) }
                TERRAFORMSOURCES_DESCRIPTOR.index -> builder.terraformSources =
                    deserializer.deserializeList(TERRAFORMSOURCES_DESCRIPTOR) {
                        val col0 = mutableListOf<TerraformSource>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeTerraformSourceDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
