// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.serde

import aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse
import aws.sdk.kotlin.services.resiliencehub.model.ErrorDetail
import aws.sdk.kotlin.services.resiliencehub.model.ResiliencehubException
import aws.sdk.kotlin.services.resiliencehub.model.ResourceImportStatusType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import aws.smithy.kotlin.runtime.time.Instant
import aws.smithy.kotlin.runtime.time.TimestampFormat
import kotlin.collections.mutableListOf


internal class DescribeDraftAppVersionResourcesImportStatusOperationDeserializer: HttpDeserializer.NonStreaming<DescribeDraftAppVersionResourcesImportStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): DescribeDraftAppVersionResourcesImportStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwDescribeDraftAppVersionResourcesImportStatusError(context, call, payload)
        }
        val builder = DescribeDraftAppVersionResourcesImportStatusResponse.Builder()

        if (payload != null) {
            deserializeDescribeDraftAppVersionResourcesImportStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwDescribeDraftAppVersionResourcesImportStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ResiliencehubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ResiliencehubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeDescribeDraftAppVersionResourcesImportStatusOperationBody(builder: DescribeDraftAppVersionResourcesImportStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appArn"))
    val APPVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appVersion"))
    val ERRORDETAILS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("errorDetails"))
    val ERRORMESSAGE_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("errorMessage"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val STATUSCHANGETIME_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Timestamp, JsonSerialName("statusChangeTime"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPARN_DESCRIPTOR)
        field(APPVERSION_DESCRIPTOR)
        field(ERRORDETAILS_DESCRIPTOR)
        field(ERRORMESSAGE_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
        field(STATUSCHANGETIME_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPARN_DESCRIPTOR.index -> builder.appArn = deserializeString()
                APPVERSION_DESCRIPTOR.index -> builder.appVersion = deserializeString()
                ERRORDETAILS_DESCRIPTOR.index -> builder.errorDetails =
                    deserializer.deserializeList(ERRORDETAILS_DESCRIPTOR) {
                        val col0 = mutableListOf<ErrorDetail>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeErrorDetailDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                ERRORMESSAGE_DESCRIPTOR.index -> builder.errorMessage = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ResourceImportStatusType.fromValue(it) }
                STATUSCHANGETIME_DESCRIPTOR.index -> builder.statusChangeTime = deserializeInstant(TimestampFormat.EPOCH_SECONDS)
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
