// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.serde

import aws.sdk.kotlin.services.resiliencehub.model.BatchUpdateRecommendationStatusFailedEntry
import aws.sdk.kotlin.services.resiliencehub.model.BatchUpdateRecommendationStatusResponse
import aws.sdk.kotlin.services.resiliencehub.model.BatchUpdateRecommendationStatusSuccessfulEntry
import aws.sdk.kotlin.services.resiliencehub.model.ResiliencehubException
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct
import kotlin.collections.mutableListOf


internal class BatchUpdateRecommendationStatusOperationDeserializer: HttpDeserializer.NonStreaming<BatchUpdateRecommendationStatusResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): BatchUpdateRecommendationStatusResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwBatchUpdateRecommendationStatusError(context, call, payload)
        }
        val builder = BatchUpdateRecommendationStatusResponse.Builder()

        if (payload != null) {
            deserializeBatchUpdateRecommendationStatusOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwBatchUpdateRecommendationStatusError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ResiliencehubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ResiliencehubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeBatchUpdateRecommendationStatusOperationBody(builder: BatchUpdateRecommendationStatusResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appArn"))
    val FAILEDENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("failedEntries"))
    val SUCCESSFULENTRIES_DESCRIPTOR = SdkFieldDescriptor(SerialKind.List, JsonSerialName("successfulEntries"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPARN_DESCRIPTOR)
        field(FAILEDENTRIES_DESCRIPTOR)
        field(SUCCESSFULENTRIES_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPARN_DESCRIPTOR.index -> builder.appArn = deserializeString()
                FAILEDENTRIES_DESCRIPTOR.index -> builder.failedEntries =
                    deserializer.deserializeList(FAILEDENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchUpdateRecommendationStatusFailedEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchUpdateRecommendationStatusFailedEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                SUCCESSFULENTRIES_DESCRIPTOR.index -> builder.successfulEntries =
                    deserializer.deserializeList(SUCCESSFULENTRIES_DESCRIPTOR) {
                        val col0 = mutableListOf<BatchUpdateRecommendationStatusSuccessfulEntry>()
                        while (hasNextElement()) {
                            val el0 = if (nextHasValue()) { deserializeBatchUpdateRecommendationStatusSuccessfulEntryDocument(deserializer) } else { deserializeNull(); continue }
                            col0.add(el0)
                        }
                        col0
                    }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
