// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a resource mapping.
 */
public class ResourceMapping private constructor(builder: Builder) {
    /**
     * Name of the application this resource is mapped to when the `mappingType` is `AppRegistryApp`.
     */
    public val appRegistryAppName: kotlin.String? = builder.appRegistryAppName
    /**
     * Name of the Amazon Elastic Kubernetes Service cluster and namespace that this resource is mapped to when the `mappingType` is `EKS`.
     *
     * This parameter accepts values in "eks-cluster/namespace" format.
     */
    public val eksSourceName: kotlin.String? = builder.eksSourceName
    /**
     * Name of the CloudFormation stack this resource is mapped to when the `mappingType` is `CfnStack`.
     */
    public val logicalStackName: kotlin.String? = builder.logicalStackName
    /**
     * Specifies the type of resource mapping.
     */
    public val mappingType: aws.sdk.kotlin.services.resiliencehub.model.ResourceMappingType = requireNotNull(builder.mappingType) { "A non-null value must be provided for mappingType" }
    /**
     * Identifier of the physical resource.
     */
    public val physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = builder.physicalResourceId
    /**
     * Name of the Resource Groups that this resource is mapped to when the `mappingType` is `ResourceGroup`.
     */
    public val resourceGroupName: kotlin.String? = builder.resourceGroupName
    /**
     * Name of the resource that this resource is mapped to when the `mappingType` is `Resource`.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * Name of the Terraform source that this resource is mapped to when the `mappingType` is `Terraform`.
     */
    public val terraformSourceName: kotlin.String? = builder.terraformSourceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ResourceMapping = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceMapping(")
        append("appRegistryAppName=$appRegistryAppName,")
        append("eksSourceName=$eksSourceName,")
        append("logicalStackName=$logicalStackName,")
        append("mappingType=$mappingType,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceGroupName=$resourceGroupName,")
        append("resourceName=$resourceName,")
        append("terraformSourceName=$terraformSourceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appRegistryAppName?.hashCode() ?: 0
        result = 31 * result + (eksSourceName?.hashCode() ?: 0)
        result = 31 * result + (logicalStackName?.hashCode() ?: 0)
        result = 31 * result + (mappingType.hashCode())
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (terraformSourceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceMapping

        if (appRegistryAppName != other.appRegistryAppName) return false
        if (eksSourceName != other.eksSourceName) return false
        if (logicalStackName != other.logicalStackName) return false
        if (mappingType != other.mappingType) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (resourceName != other.resourceName) return false
        if (terraformSourceName != other.terraformSourceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ResourceMapping = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of the application this resource is mapped to when the `mappingType` is `AppRegistryApp`.
         */
        public var appRegistryAppName: kotlin.String? = null
        /**
         * Name of the Amazon Elastic Kubernetes Service cluster and namespace that this resource is mapped to when the `mappingType` is `EKS`.
         *
         * This parameter accepts values in "eks-cluster/namespace" format.
         */
        public var eksSourceName: kotlin.String? = null
        /**
         * Name of the CloudFormation stack this resource is mapped to when the `mappingType` is `CfnStack`.
         */
        public var logicalStackName: kotlin.String? = null
        /**
         * Specifies the type of resource mapping.
         */
        public var mappingType: aws.sdk.kotlin.services.resiliencehub.model.ResourceMappingType? = null
        /**
         * Identifier of the physical resource.
         */
        public var physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = null
        /**
         * Name of the Resource Groups that this resource is mapped to when the `mappingType` is `ResourceGroup`.
         */
        public var resourceGroupName: kotlin.String? = null
        /**
         * Name of the resource that this resource is mapped to when the `mappingType` is `Resource`.
         */
        public var resourceName: kotlin.String? = null
        /**
         * Name of the Terraform source that this resource is mapped to when the `mappingType` is `Terraform`.
         */
        public var terraformSourceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ResourceMapping) : this() {
            this.appRegistryAppName = x.appRegistryAppName
            this.eksSourceName = x.eksSourceName
            this.logicalStackName = x.logicalStackName
            this.mappingType = x.mappingType
            this.physicalResourceId = x.physicalResourceId
            this.resourceGroupName = x.resourceGroupName
            this.resourceName = x.resourceName
            this.terraformSourceName = x.terraformSourceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ResourceMapping = ResourceMapping(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId] inside the given [block]
         */
        public fun physicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.Builder.() -> kotlin.Unit) {
            this.physicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (mappingType == null) mappingType = ResourceMappingType.SdkUnknown("no value provided")
            return this
        }
    }
}
