// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Indicates the resources that have drifted in the current application version.
 */
public class ResourceDrift private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the application whose resources have drifted. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * Version of the application whose resources have drifted.
     */
    public val appVersion: kotlin.String? = builder.appVersion
    /**
     * Indicates if the resource was added or removed.
     */
    public val diffType: aws.sdk.kotlin.services.resiliencehub.model.DifferenceType? = builder.diffType
    /**
     * Reference identifier of the resource drift.
     */
    public val referenceId: kotlin.String? = builder.referenceId
    /**
     * Identifier of the drifted resource.
     */
    public val resourceIdentifier: aws.sdk.kotlin.services.resiliencehub.model.ResourceIdentifier? = builder.resourceIdentifier

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ResourceDrift = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ResourceDrift(")
        append("appArn=$appArn,")
        append("appVersion=$appVersion,")
        append("diffType=$diffType,")
        append("referenceId=$referenceId,")
        append("resourceIdentifier=$resourceIdentifier")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (appVersion?.hashCode() ?: 0)
        result = 31 * result + (diffType?.hashCode() ?: 0)
        result = 31 * result + (referenceId?.hashCode() ?: 0)
        result = 31 * result + (resourceIdentifier?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ResourceDrift

        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false
        if (diffType != other.diffType) return false
        if (referenceId != other.referenceId) return false
        if (resourceIdentifier != other.resourceIdentifier) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ResourceDrift = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the application whose resources have drifted. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Version of the application whose resources have drifted.
         */
        public var appVersion: kotlin.String? = null
        /**
         * Indicates if the resource was added or removed.
         */
        public var diffType: aws.sdk.kotlin.services.resiliencehub.model.DifferenceType? = null
        /**
         * Reference identifier of the resource drift.
         */
        public var referenceId: kotlin.String? = null
        /**
         * Identifier of the drifted resource.
         */
        public var resourceIdentifier: aws.sdk.kotlin.services.resiliencehub.model.ResourceIdentifier? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ResourceDrift) : this() {
            this.appArn = x.appArn
            this.appVersion = x.appVersion
            this.diffType = x.diffType
            this.referenceId = x.referenceId
            this.resourceIdentifier = x.resourceIdentifier
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ResourceDrift = ResourceDrift(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.ResourceIdentifier] inside the given [block]
         */
        public fun resourceIdentifier(block: aws.sdk.kotlin.services.resiliencehub.model.ResourceIdentifier.Builder.() -> kotlin.Unit) {
            this.resourceIdentifier = aws.sdk.kotlin.services.resiliencehub.model.ResourceIdentifier.invoke(block)
        }

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
