// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class RemoveDraftAppVersionResourceMappingsRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * The names of the registered applications you want to remove from the resource mappings.
     */
    public val appRegistryAppNames: List<String>? = builder.appRegistryAppNames
    /**
     * The names of the Amazon Elastic Kubernetes Service clusters and namespaces you want to remove from the resource mappings.
     *
     * This parameter accepts values in "eks-cluster/namespace" format.
     */
    public val eksSourceNames: List<String>? = builder.eksSourceNames
    /**
     * The names of the CloudFormation stacks you want to remove from the resource mappings.
     */
    public val logicalStackNames: List<String>? = builder.logicalStackNames
    /**
     * The names of the resource groups you want to remove from the resource mappings.
     */
    public val resourceGroupNames: List<String>? = builder.resourceGroupNames
    /**
     * The names of the resources you want to remove from the resource mappings.
     */
    public val resourceNames: List<String>? = builder.resourceNames
    /**
     * The names of the Terraform sources you want to remove from the resource mappings.
     */
    public val terraformSourceNames: List<String>? = builder.terraformSourceNames

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("RemoveDraftAppVersionResourceMappingsRequest(")
        append("appArn=$appArn,")
        append("appRegistryAppNames=$appRegistryAppNames,")
        append("eksSourceNames=$eksSourceNames,")
        append("logicalStackNames=$logicalStackNames,")
        append("resourceGroupNames=$resourceGroupNames,")
        append("resourceNames=$resourceNames,")
        append("terraformSourceNames=$terraformSourceNames")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appRegistryAppNames?.hashCode() ?: 0)
        result = 31 * result + (eksSourceNames?.hashCode() ?: 0)
        result = 31 * result + (logicalStackNames?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupNames?.hashCode() ?: 0)
        result = 31 * result + (resourceNames?.hashCode() ?: 0)
        result = 31 * result + (terraformSourceNames?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as RemoveDraftAppVersionResourceMappingsRequest

        if (appArn != other.appArn) return false
        if (appRegistryAppNames != other.appRegistryAppNames) return false
        if (eksSourceNames != other.eksSourceNames) return false
        if (logicalStackNames != other.logicalStackNames) return false
        if (resourceGroupNames != other.resourceGroupNames) return false
        if (resourceNames != other.resourceNames) return false
        if (terraformSourceNames != other.terraformSourceNames) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * The names of the registered applications you want to remove from the resource mappings.
         */
        public var appRegistryAppNames: List<String>? = null
        /**
         * The names of the Amazon Elastic Kubernetes Service clusters and namespaces you want to remove from the resource mappings.
         *
         * This parameter accepts values in "eks-cluster/namespace" format.
         */
        public var eksSourceNames: List<String>? = null
        /**
         * The names of the CloudFormation stacks you want to remove from the resource mappings.
         */
        public var logicalStackNames: List<String>? = null
        /**
         * The names of the resource groups you want to remove from the resource mappings.
         */
        public var resourceGroupNames: List<String>? = null
        /**
         * The names of the resources you want to remove from the resource mappings.
         */
        public var resourceNames: List<String>? = null
        /**
         * The names of the Terraform sources you want to remove from the resource mappings.
         */
        public var terraformSourceNames: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest) : this() {
            this.appArn = x.appArn
            this.appRegistryAppNames = x.appRegistryAppNames
            this.eksSourceNames = x.eksSourceNames
            this.logicalStackNames = x.logicalStackNames
            this.resourceGroupNames = x.resourceGroupNames
            this.resourceNames = x.resourceNames
            this.terraformSourceNames = x.terraformSourceNames
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest = RemoveDraftAppVersionResourceMappingsRequest(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            return this
        }
    }
}
