// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a physical resource identifier.
 */
public class PhysicalResourceId private constructor(builder: Builder) {
    /**
     * The Amazon Web Services account that owns the physical resource.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * The Amazon Web Services Region that the physical resource is located in.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * Identifier of the physical resource.
     */
    public val identifier: kotlin.String = requireNotNull(builder.identifier) { "A non-null value must be provided for identifier" }
    /**
     * Specifies the type of physical resource identifier.
     *
     * ## Arn
     * The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:
     * + `AWS::ECS::Service`
     * + `AWS::EFS::FileSystem`
     * + `AWS::ElasticLoadBalancingV2::LoadBalancer`
     * + `AWS::Lambda::Function`
     * + `AWS::SNS::Topic`
     *
     * ## Native
     * The resource identifier is an Resilience Hub-native identifier and it can identify the following list of resources:
     * + `AWS::ApiGateway::RestApi`
     * + `AWS::ApiGatewayV2::Api`
     * + `AWS::AutoScaling::AutoScalingGroup`
     * + `AWS::DocDB::DBCluster`
     * + `AWS::DocDB::DBGlobalCluster`
     * + `AWS::DocDB::DBInstance`
     * + `AWS::DynamoDB::GlobalTable`
     * + `AWS::DynamoDB::Table`
     * + `AWS::EC2::EC2Fleet`
     * + `AWS::EC2::Instance`
     * + `AWS::EC2::NatGateway`
     * + `AWS::EC2::Volume`
     * + `AWS::ElasticLoadBalancing::LoadBalancer`
     * + `AWS::RDS::DBCluster`
     * + `AWS::RDS::DBInstance`
     * + `AWS::RDS::GlobalCluster`
     * + `AWS::Route53::RecordSet`
     * + `AWS::S3::Bucket`
     * + `AWS::SQS::Queue`
     */
    public val type: aws.sdk.kotlin.services.resiliencehub.model.PhysicalIdentifierType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PhysicalResourceId(")
        append("awsAccountId=$awsAccountId,")
        append("awsRegion=$awsRegion,")
        append("identifier=$identifier,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = awsAccountId?.hashCode() ?: 0
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (identifier.hashCode())
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PhysicalResourceId

        if (awsAccountId != other.awsAccountId) return false
        if (awsRegion != other.awsRegion) return false
        if (identifier != other.identifier) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The Amazon Web Services account that owns the physical resource.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * The Amazon Web Services Region that the physical resource is located in.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * Identifier of the physical resource.
         */
        public var identifier: kotlin.String? = null
        /**
         * Specifies the type of physical resource identifier.
         *
         * ## Arn
         * The resource identifier is an Amazon Resource Name (ARN) and it can identify the following list of resources:
         * + `AWS::ECS::Service`
         * + `AWS::EFS::FileSystem`
         * + `AWS::ElasticLoadBalancingV2::LoadBalancer`
         * + `AWS::Lambda::Function`
         * + `AWS::SNS::Topic`
         *
         * ## Native
         * The resource identifier is an Resilience Hub-native identifier and it can identify the following list of resources:
         * + `AWS::ApiGateway::RestApi`
         * + `AWS::ApiGatewayV2::Api`
         * + `AWS::AutoScaling::AutoScalingGroup`
         * + `AWS::DocDB::DBCluster`
         * + `AWS::DocDB::DBGlobalCluster`
         * + `AWS::DocDB::DBInstance`
         * + `AWS::DynamoDB::GlobalTable`
         * + `AWS::DynamoDB::Table`
         * + `AWS::EC2::EC2Fleet`
         * + `AWS::EC2::Instance`
         * + `AWS::EC2::NatGateway`
         * + `AWS::EC2::Volume`
         * + `AWS::ElasticLoadBalancing::LoadBalancer`
         * + `AWS::RDS::DBCluster`
         * + `AWS::RDS::DBInstance`
         * + `AWS::RDS::GlobalCluster`
         * + `AWS::Route53::RecordSet`
         * + `AWS::S3::Bucket`
         * + `AWS::SQS::Queue`
         */
        public var type: aws.sdk.kotlin.services.resiliencehub.model.PhysicalIdentifierType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId) : this() {
            this.awsAccountId = x.awsAccountId
            this.awsRegion = x.awsRegion
            this.identifier = x.identifier
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId = PhysicalResourceId(this)

        internal fun correctErrors(): Builder {
            if (identifier == null) identifier = ""
            if (type == null) type = PhysicalIdentifierType.SdkUnknown("no value provided")
            return this
        }
    }
}
