// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines the roles and credentials that Resilience Hub would use while creating the application, importing its resources, and running an assessment.
 */
public class PermissionModel private constructor(builder: Builder) {
    /**
     * Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used for querying purposes while importing resources and assessing your application.
     *
     * + These ARNs are required only when your resources are in other accounts and you have different role name in these accounts. Else, the invoker role name will be used in the other accounts.
     * + These roles must have a trust policy with `iam:AssumeRole` permission to the invoker role in the primary account.
     */
    public val crossAccountRoleArns: List<String>? = builder.crossAccountRoleArns
    /**
     * Existing Amazon Web Services IAM role name in the primary Amazon Web Services account that will be assumed by Resilience Hub Service Principle to obtain a read-only access to your application resources while running an assessment.
     *
     * If your IAM role includes a path, you must include the path in the `invokerRoleName` parameter. For example, if your IAM role's ARN is `arn:aws:iam:123456789012:role/my-path/role-name`, you should pass `my-path/role-name`.
     *
     * + You must have `iam:passRole` permission for this role while creating or updating the application.
     * + Currently, `invokerRoleName` accepts only `[A-Za-z0-9_+=,.@-]` characters.
     */
    public val invokerRoleName: kotlin.String? = builder.invokerRoleName
    /**
     * Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing role in your Amazon Web Services account, or by using the credentials of the current IAM user.
     */
    public val type: aws.sdk.kotlin.services.resiliencehub.model.PermissionModelType = requireNotNull(builder.type) { "A non-null value must be provided for type" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.PermissionModel = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("PermissionModel(")
        append("crossAccountRoleArns=$crossAccountRoleArns,")
        append("invokerRoleName=$invokerRoleName,")
        append("type=$type")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = crossAccountRoleArns?.hashCode() ?: 0
        result = 31 * result + (invokerRoleName?.hashCode() ?: 0)
        result = 31 * result + (type.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as PermissionModel

        if (crossAccountRoleArns != other.crossAccountRoleArns) return false
        if (invokerRoleName != other.invokerRoleName) return false
        if (type != other.type) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.PermissionModel = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Defines a list of role Amazon Resource Names (ARNs) to be used in other accounts. These ARNs are used for querying purposes while importing resources and assessing your application.
         *
         * + These ARNs are required only when your resources are in other accounts and you have different role name in these accounts. Else, the invoker role name will be used in the other accounts.
         * + These roles must have a trust policy with `iam:AssumeRole` permission to the invoker role in the primary account.
         */
        public var crossAccountRoleArns: List<String>? = null
        /**
         * Existing Amazon Web Services IAM role name in the primary Amazon Web Services account that will be assumed by Resilience Hub Service Principle to obtain a read-only access to your application resources while running an assessment.
         *
         * If your IAM role includes a path, you must include the path in the `invokerRoleName` parameter. For example, if your IAM role's ARN is `arn:aws:iam:123456789012:role/my-path/role-name`, you should pass `my-path/role-name`.
         *
         * + You must have `iam:passRole` permission for this role while creating or updating the application.
         * + Currently, `invokerRoleName` accepts only `[A-Za-z0-9_+=,.@-]` characters.
         */
        public var invokerRoleName: kotlin.String? = null
        /**
         * Defines how Resilience Hub scans your resources. It can scan for the resources by using a pre-existing role in your Amazon Web Services account, or by using the credentials of the current IAM user.
         */
        public var type: aws.sdk.kotlin.services.resiliencehub.model.PermissionModelType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel) : this() {
            this.crossAccountRoleArns = x.crossAccountRoleArns
            this.invokerRoleName = x.invokerRoleName
            this.type = x.type
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.PermissionModel = PermissionModel(this)

        internal fun correctErrors(): Builder {
            if (type == null) type = PermissionModelType.SdkUnknown("no value provided")
            return this
        }
    }
}
