// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a logical resource identifier.
 */
public class LogicalResourceId private constructor(builder: Builder) {
    /**
     * Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
     *
     * This parameter accepts values in "eks-cluster/namespace" format.
     */
    public val eksSourceName: kotlin.String? = builder.eksSourceName
    /**
     * Identifier of the resource.
     */
    public val identifier: kotlin.String = requireNotNull(builder.identifier) { "A non-null value must be provided for identifier" }
    /**
     * The name of the CloudFormation stack this resource belongs to.
     */
    public val logicalStackName: kotlin.String? = builder.logicalStackName
    /**
     * The name of the resource group that this resource belongs to.
     */
    public val resourceGroupName: kotlin.String? = builder.resourceGroupName
    /**
     * The name of the Terraform S3 state file this resource belongs to.
     */
    public val terraformSourceName: kotlin.String? = builder.terraformSourceName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("LogicalResourceId(")
        append("eksSourceName=$eksSourceName,")
        append("identifier=$identifier,")
        append("logicalStackName=$logicalStackName,")
        append("resourceGroupName=$resourceGroupName,")
        append("terraformSourceName=$terraformSourceName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eksSourceName?.hashCode() ?: 0
        result = 31 * result + (identifier.hashCode())
        result = 31 * result + (logicalStackName?.hashCode() ?: 0)
        result = 31 * result + (resourceGroupName?.hashCode() ?: 0)
        result = 31 * result + (terraformSourceName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as LogicalResourceId

        if (eksSourceName != other.eksSourceName) return false
        if (identifier != other.identifier) return false
        if (logicalStackName != other.logicalStackName) return false
        if (resourceGroupName != other.resourceGroupName) return false
        if (terraformSourceName != other.terraformSourceName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of the Amazon Elastic Kubernetes Service cluster and namespace this resource belongs to.
         *
         * This parameter accepts values in "eks-cluster/namespace" format.
         */
        public var eksSourceName: kotlin.String? = null
        /**
         * Identifier of the resource.
         */
        public var identifier: kotlin.String? = null
        /**
         * The name of the CloudFormation stack this resource belongs to.
         */
        public var logicalStackName: kotlin.String? = null
        /**
         * The name of the resource group that this resource belongs to.
         */
        public var resourceGroupName: kotlin.String? = null
        /**
         * The name of the Terraform S3 state file this resource belongs to.
         */
        public var terraformSourceName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId) : this() {
            this.eksSourceName = x.eksSourceName
            this.identifier = x.identifier
            this.logicalStackName = x.logicalStackName
            this.resourceGroupName = x.resourceGroupName
            this.terraformSourceName = x.terraformSourceName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId = LogicalResourceId(this)

        internal fun correctErrors(): Builder {
            if (identifier == null) identifier = ""
            return this
        }
    }
}
