// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

public class ListAppVersionsRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Upper limit of the time range to filter the application versions.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Maximum number of results to include in the response. If more results exist than the specified `MaxResults` value, a token is included in the response so that the remaining results can be retrieved.
     */
    public val maxResults: kotlin.Int? = builder.maxResults
    /**
     * Null, or the token from a previous call to get the next set of results.
     */
    public val nextToken: kotlin.String? = builder.nextToken
    /**
     * Lower limit of the time range to filter the application versions.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionsRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAppVersionsRequest(")
        append("appArn=$appArn,")
        append("endTime=$endTime,")
        append("maxResults=$maxResults,")
        append("nextToken=$nextToken,")
        append("startTime=$startTime")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (maxResults ?: 0)
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        result = 31 * result + (startTime?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAppVersionsRequest

        if (appArn != other.appArn) return false
        if (endTime != other.endTime) return false
        if (maxResults != other.maxResults) return false
        if (nextToken != other.nextToken) return false
        if (startTime != other.startTime) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionsRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Upper limit of the time range to filter the application versions.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Maximum number of results to include in the response. If more results exist than the specified `MaxResults` value, a token is included in the response so that the remaining results can be retrieved.
         */
        public var maxResults: kotlin.Int? = null
        /**
         * Null, or the token from a previous call to get the next set of results.
         */
        public var nextToken: kotlin.String? = null
        /**
         * Lower limit of the time range to filter the application versions.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionsRequest) : this() {
            this.appArn = x.appArn
            this.endTime = x.endTime
            this.maxResults = x.maxResults
            this.nextToken = x.nextToken
            this.startTime = x.startTime
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionsRequest = ListAppVersionsRequest(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            return this
        }
    }
}
