// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class ListAppVersionAppComponentsResponse private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Defines an Application Component.
     */
    public val appComponents: List<AppComponent>? = builder.appComponents
    /**
     * Resilience Hub application version.
     */
    public val appVersion: kotlin.String = requireNotNull(builder.appVersion) { "A non-null value must be provided for appVersion" }
    /**
     * Token for the next set of results, or null if there are no more results.
     */
    public val nextToken: kotlin.String? = builder.nextToken

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionAppComponentsResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ListAppVersionAppComponentsResponse(")
        append("appArn=$appArn,")
        append("appComponents=$appComponents,")
        append("appVersion=$appVersion,")
        append("nextToken=$nextToken")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appComponents?.hashCode() ?: 0)
        result = 31 * result + (appVersion.hashCode())
        result = 31 * result + (nextToken?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ListAppVersionAppComponentsResponse

        if (appArn != other.appArn) return false
        if (appComponents != other.appComponents) return false
        if (appVersion != other.appVersion) return false
        if (nextToken != other.nextToken) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionAppComponentsResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Defines an Application Component.
         */
        public var appComponents: List<AppComponent>? = null
        /**
         * Resilience Hub application version.
         */
        public var appVersion: kotlin.String? = null
        /**
         * Token for the next set of results, or null if there are no more results.
         */
        public var nextToken: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionAppComponentsResponse) : this() {
            this.appArn = x.appArn
            this.appComponents = x.appComponents
            this.appVersion = x.appVersion
            this.nextToken = x.nextToken
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionAppComponentsResponse = ListAppVersionAppComponentsResponse(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appVersion == null) appVersion = ""
            return this
        }
    }
}
