// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Indicates the resource that will be grouped in the recommended Application Component (AppComponent).
 */
public class GroupingResource private constructor(builder: Builder) {
    /**
     * Indicates the logical identifier of the resource.
     */
    public val logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = builder.logicalResourceId
    /**
     * Indicates the physical identifier of the resource.
     */
    public val physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = builder.physicalResourceId
    /**
     * Indicates the resource name.
     */
    public val resourceName: kotlin.String = requireNotNull(builder.resourceName) { "A non-null value must be provided for resourceName" }
    /**
     * Indicates the resource type.
     */
    public val resourceType: kotlin.String = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }
    /**
     * Indicates the identifier of the source AppComponents in which the resources were previously grouped into.
     */
    public val sourceAppComponentIds: List<String> = requireNotNull(builder.sourceAppComponentIds) { "A non-null value must be provided for sourceAppComponentIds" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.GroupingResource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupingResource(")
        append("logicalResourceId=$logicalResourceId,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType,")
        append("sourceAppComponentIds=$sourceAppComponentIds")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = logicalResourceId?.hashCode() ?: 0
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceName.hashCode())
        result = 31 * result + (resourceType.hashCode())
        result = 31 * result + (sourceAppComponentIds.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupingResource

        if (logicalResourceId != other.logicalResourceId) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false
        if (sourceAppComponentIds != other.sourceAppComponentIds) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.GroupingResource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the logical identifier of the resource.
         */
        public var logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = null
        /**
         * Indicates the physical identifier of the resource.
         */
        public var physicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId? = null
        /**
         * Indicates the resource name.
         */
        public var resourceName: kotlin.String? = null
        /**
         * Indicates the resource type.
         */
        public var resourceType: kotlin.String? = null
        /**
         * Indicates the identifier of the source AppComponents in which the resources were previously grouped into.
         */
        public var sourceAppComponentIds: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.GroupingResource) : this() {
            this.logicalResourceId = x.logicalResourceId
            this.physicalResourceId = x.physicalResourceId
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
            this.sourceAppComponentIds = x.sourceAppComponentIds
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.GroupingResource = GroupingResource(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId] inside the given [block]
         */
        public fun logicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.Builder.() -> kotlin.Unit) {
            this.logicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId] inside the given [block]
         */
        public fun physicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.Builder.() -> kotlin.Unit) {
            this.physicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.PhysicalResourceId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (resourceName == null) resourceName = ""
            if (resourceType == null) resourceType = ""
            if (sourceAppComponentIds == null) sourceAppComponentIds = emptyList()
            return this
        }
    }
}
