// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Creates a new grouping recommendation.
 */
public class GroupingRecommendation private constructor(builder: Builder) {
    /**
     * Indicates the confidence level of Resilience Hub on the grouping recommendation.
     */
    public val confidenceLevel: aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendationConfidenceLevel = requireNotNull(builder.confidenceLevel) { "A non-null value must be provided for confidenceLevel" }
    /**
     * Indicates the creation time of the grouping recommendation.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * Indicates the name of the recommended Application Component (AppComponent).
     */
    public val groupingAppComponent: aws.sdk.kotlin.services.resiliencehub.model.GroupingAppComponent? = builder.groupingAppComponent
    /**
     * Indicates all the reasons available for rejecting a grouping recommendation.
     */
    public val groupingRecommendationId: kotlin.String = requireNotNull(builder.groupingRecommendationId) { "A non-null value must be provided for groupingRecommendationId" }
    /**
     * Indicates all the reasons available for rejecting a grouping recommendation.
     */
    public val recommendationReasons: List<String> = requireNotNull(builder.recommendationReasons) { "A non-null value must be provided for recommendationReasons" }
    /**
     * Indicates the reason you had selected while rejecting a grouping recommendation.
     */
    public val rejectionReason: aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendationRejectionReason? = builder.rejectionReason
    /**
     * Indicates the resources that are grouped in a recommended AppComponent.
     */
    public val resources: List<GroupingResource> = requireNotNull(builder.resources) { "A non-null value must be provided for resources" }
    /**
     * Indicates the confidence level of the grouping recommendation.
     */
    public val score: kotlin.Double = builder.score
    /**
     * Indicates the status of grouping resources into AppComponents.
     */
    public val status: aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendationStatusType = requireNotNull(builder.status) { "A non-null value must be provided for status" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("GroupingRecommendation(")
        append("confidenceLevel=$confidenceLevel,")
        append("creationTime=$creationTime,")
        append("groupingAppComponent=$groupingAppComponent,")
        append("groupingRecommendationId=$groupingRecommendationId,")
        append("recommendationReasons=$recommendationReasons,")
        append("rejectionReason=$rejectionReason,")
        append("resources=$resources,")
        append("score=$score,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = confidenceLevel.hashCode()
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (groupingAppComponent?.hashCode() ?: 0)
        result = 31 * result + (groupingRecommendationId.hashCode())
        result = 31 * result + (recommendationReasons.hashCode())
        result = 31 * result + (rejectionReason?.hashCode() ?: 0)
        result = 31 * result + (resources.hashCode())
        result = 31 * result + (score.hashCode())
        result = 31 * result + (status.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as GroupingRecommendation

        if (confidenceLevel != other.confidenceLevel) return false
        if (creationTime != other.creationTime) return false
        if (groupingAppComponent != other.groupingAppComponent) return false
        if (groupingRecommendationId != other.groupingRecommendationId) return false
        if (recommendationReasons != other.recommendationReasons) return false
        if (rejectionReason != other.rejectionReason) return false
        if (resources != other.resources) return false
        if (!(score?.equals(other.score) ?: (other.score == null))) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the confidence level of Resilience Hub on the grouping recommendation.
         */
        public var confidenceLevel: aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendationConfidenceLevel? = null
        /**
         * Indicates the creation time of the grouping recommendation.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Indicates the name of the recommended Application Component (AppComponent).
         */
        public var groupingAppComponent: aws.sdk.kotlin.services.resiliencehub.model.GroupingAppComponent? = null
        /**
         * Indicates all the reasons available for rejecting a grouping recommendation.
         */
        public var groupingRecommendationId: kotlin.String? = null
        /**
         * Indicates all the reasons available for rejecting a grouping recommendation.
         */
        public var recommendationReasons: List<String>? = null
        /**
         * Indicates the reason you had selected while rejecting a grouping recommendation.
         */
        public var rejectionReason: aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendationRejectionReason? = null
        /**
         * Indicates the resources that are grouped in a recommended AppComponent.
         */
        public var resources: List<GroupingResource>? = null
        /**
         * Indicates the confidence level of the grouping recommendation.
         */
        public var score: kotlin.Double = 0.0
        /**
         * Indicates the status of grouping resources into AppComponents.
         */
        public var status: aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendationStatusType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendation) : this() {
            this.confidenceLevel = x.confidenceLevel
            this.creationTime = x.creationTime
            this.groupingAppComponent = x.groupingAppComponent
            this.groupingRecommendationId = x.groupingRecommendationId
            this.recommendationReasons = x.recommendationReasons
            this.rejectionReason = x.rejectionReason
            this.resources = x.resources
            this.score = x.score
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.GroupingRecommendation = GroupingRecommendation(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.GroupingAppComponent] inside the given [block]
         */
        public fun groupingAppComponent(block: aws.sdk.kotlin.services.resiliencehub.model.GroupingAppComponent.Builder.() -> kotlin.Unit) {
            this.groupingAppComponent = aws.sdk.kotlin.services.resiliencehub.model.GroupingAppComponent.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (confidenceLevel == null) confidenceLevel = GroupingRecommendationConfidenceLevel.SdkUnknown("no value provided")
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (groupingRecommendationId == null) groupingRecommendationId = ""
            if (recommendationReasons == null) recommendationReasons = emptyList()
            if (resources == null) resources = emptyList()
            if (status == null) status = GroupingRecommendationStatusType.SdkUnknown("no value provided")
            return this
        }
    }
}
