// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Indicates an event you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for **Drift detected** and **Scheduled assessment failure** events.
 */
public class EventSubscription private constructor(builder: Builder) {
    /**
     * The type of event you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for **Drift detected** (`DriftDetected`) and **Scheduled assessment failure** (`ScheduledAssessmentFailure`) events.
     */
    public val eventType: aws.sdk.kotlin.services.resiliencehub.model.EventType = requireNotNull(builder.eventType) { "A non-null value must be provided for eventType" }
    /**
     * Unique name to identify an event subscription.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic. The format for this ARN is: `arn:partition:sns:region:account:topic-name`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val snsTopicArn: kotlin.String? = builder.snsTopicArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.EventSubscription = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EventSubscription(")
        append("eventType=$eventType,")
        append("name=$name,")
        append("snsTopicArn=$snsTopicArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eventType.hashCode()
        result = 31 * result + (name.hashCode())
        result = 31 * result + (snsTopicArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EventSubscription

        if (eventType != other.eventType) return false
        if (name != other.name) return false
        if (snsTopicArn != other.snsTopicArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.EventSubscription = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * The type of event you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for **Drift detected** (`DriftDetected`) and **Scheduled assessment failure** (`ScheduledAssessmentFailure`) events.
         */
        public var eventType: aws.sdk.kotlin.services.resiliencehub.model.EventType? = null
        /**
         * Unique name to identify an event subscription.
         */
        public var name: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of the Amazon Simple Notification Service topic. The format for this ARN is: `arn:partition:sns:region:account:topic-name`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var snsTopicArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.EventSubscription) : this() {
            this.eventType = x.eventType
            this.name = x.name
            this.snsTopicArn = x.snsTopicArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.EventSubscription = EventSubscription(this)

        internal fun correctErrors(): Builder {
            if (eventType == null) eventType = EventType.SdkUnknown("no value provided")
            if (name == null) name = ""
            return this
        }
    }
}
