// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * The input source of the Amazon Elastic Kubernetes Service cluster.
 */
public class EksSource private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster. The format for this ARN is: arn:`aws`:eks:`region`:`account-id`:cluster/`cluster-name`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val eksClusterArn: kotlin.String = requireNotNull(builder.eksClusterArn) { "A non-null value must be provided for eksClusterArn" }
    /**
     * The list of namespaces located on your Amazon Elastic Kubernetes Service cluster.
     */
    public val namespaces: List<String> = requireNotNull(builder.namespaces) { "A non-null value must be provided for namespaces" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.EksSource = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("EksSource(")
        append("eksClusterArn=$eksClusterArn,")
        append("namespaces=$namespaces")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = eksClusterArn.hashCode()
        result = 31 * result + (namespaces.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as EksSource

        if (eksClusterArn != other.eksClusterArn) return false
        if (namespaces != other.namespaces) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.EksSource = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Amazon Elastic Kubernetes Service cluster. The format for this ARN is: arn:`aws`:eks:`region`:`account-id`:cluster/`cluster-name`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var eksClusterArn: kotlin.String? = null
        /**
         * The list of namespaces located on your Amazon Elastic Kubernetes Service cluster.
         */
        public var namespaces: List<String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.EksSource) : this() {
            this.eksClusterArn = x.eksClusterArn
            this.namespaces = x.namespaces
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.EksSource = EksSource(this)

        internal fun correctErrors(): Builder {
            if (eksClusterArn == null) eksClusterArn = ""
            if (namespaces == null) namespaces = emptyList()
            return this
        }
    }
}
