// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DescribeAppVersionResponse private constructor(builder: Builder) {
    /**
     * Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
     *
     * Currently, this parameter supports only failover region and account.
     */
    public val additionalInfo: Map<String, List<String>>? = builder.additionalInfo
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Resilience Hub application version.
     */
    public val appVersion: kotlin.String = requireNotNull(builder.appVersion) { "A non-null value must be provided for appVersion" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DescribeAppVersionResponse(")
        append("additionalInfo=$additionalInfo,")
        append("appArn=$appArn,")
        append("appVersion=$appVersion")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (appArn.hashCode())
        result = 31 * result + (appVersion.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DescribeAppVersionResponse

        if (additionalInfo != other.additionalInfo) return false
        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Additional configuration parameters for an Resilience Hub application. If you want to implement `additionalInfo` through the Resilience Hub console rather than using an API call, see [Configure the application configuration parameters](https://docs.aws.amazon.com/resilience-hub/latest/userguide/app-config-param.html).
         *
         * Currently, this parameter supports only failover region and account.
         */
        public var additionalInfo: Map<String, List<String>>? = null
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Resilience Hub application version.
         */
        public var appVersion: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResponse) : this() {
            this.additionalInfo = x.additionalInfo
            this.appArn = x.appArn
            this.appVersion = x.appVersion
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResponse = DescribeAppVersionResponse(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appVersion == null) appVersion = ""
            return this
        }
    }
}
