// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class DeleteAppInputSourceRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The namespace on your Amazon Elastic Kubernetes Service cluster that you want to delete from the Resilience Hub application.
     */
    public val eksSourceClusterNamespace: aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace? = builder.eksSourceClusterNamespace
    /**
     * The Amazon Resource Name (ARN) of the imported resource you want to remove from the Resilience Hub application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val sourceArn: kotlin.String? = builder.sourceArn
    /**
     * The imported Terraform s3 state ﬁle you want to remove from the Resilience Hub application.
     */
    public val terraformSource: aws.sdk.kotlin.services.resiliencehub.model.TerraformSource? = builder.terraformSource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.DeleteAppInputSourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("DeleteAppInputSourceRequest(")
        append("appArn=$appArn,")
        append("clientToken=$clientToken,")
        append("eksSourceClusterNamespace=$eksSourceClusterNamespace,")
        append("sourceArn=$sourceArn,")
        append("terraformSource=$terraformSource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (eksSourceClusterNamespace?.hashCode() ?: 0)
        result = 31 * result + (sourceArn?.hashCode() ?: 0)
        result = 31 * result + (terraformSource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as DeleteAppInputSourceRequest

        if (appArn != other.appArn) return false
        if (clientToken != other.clientToken) return false
        if (eksSourceClusterNamespace != other.eksSourceClusterNamespace) return false
        if (sourceArn != other.sourceArn) return false
        if (terraformSource != other.terraformSource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.DeleteAppInputSourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The namespace on your Amazon Elastic Kubernetes Service cluster that you want to delete from the Resilience Hub application.
         */
        public var eksSourceClusterNamespace: aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace? = null
        /**
         * The Amazon Resource Name (ARN) of the imported resource you want to remove from the Resilience Hub application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var sourceArn: kotlin.String? = null
        /**
         * The imported Terraform s3 state ﬁle you want to remove from the Resilience Hub application.
         */
        public var terraformSource: aws.sdk.kotlin.services.resiliencehub.model.TerraformSource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.DeleteAppInputSourceRequest) : this() {
            this.appArn = x.appArn
            this.clientToken = x.clientToken
            this.eksSourceClusterNamespace = x.eksSourceClusterNamespace
            this.sourceArn = x.sourceArn
            this.terraformSource = x.terraformSource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.DeleteAppInputSourceRequest = DeleteAppInputSourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace] inside the given [block]
         */
        public fun eksSourceClusterNamespace(block: aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace.Builder.() -> kotlin.Unit) {
            this.eksSourceClusterNamespace = aws.sdk.kotlin.services.resiliencehub.model.EksSourceClusterNamespace.invoke(block)
        }

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.TerraformSource] inside the given [block]
         */
        public fun terraformSource(block: aws.sdk.kotlin.services.resiliencehub.model.TerraformSource.Builder.() -> kotlin.Unit) {
            this.terraformSource = aws.sdk.kotlin.services.resiliencehub.model.TerraformSource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            return this
        }
    }
}
