// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateRecommendationTemplateRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val assessmentArn: kotlin.String = requireNotNull(builder.assessmentArn) { "A non-null value must be provided for assessmentArn" }
    /**
     * The name of the Amazon S3 bucket that will contain the recommendation template.
     */
    public val bucketName: kotlin.String? = builder.bucketName
    /**
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * The format for the recommendation template.
     *
     * ## CfnJson
     * The template is CloudFormation JSON.
     *
     * ## CfnYaml
     * The template is CloudFormation YAML.
     */
    public val format: aws.sdk.kotlin.services.resiliencehub.model.TemplateFormat? = builder.format
    /**
     * The name for the recommendation template.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * Identifiers for the recommendations used to create a recommendation template.
     */
    public val recommendationIds: List<String>? = builder.recommendationIds
    /**
     * An array of strings that specify the recommendation template type or types.
     *
     * ## Alarm
     * The template is an AlarmRecommendation template.
     *
     * ## Sop
     * The template is a SopRecommendation template.
     *
     * ## Test
     * The template is a TestRecommendation template.
     */
    public val recommendationTypes: List<RenderRecommendationType>? = builder.recommendationTypes
    /**
     * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
     */
    public val tags: Map<String, String>? = builder.tags

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.CreateRecommendationTemplateRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateRecommendationTemplateRequest(")
        append("assessmentArn=$assessmentArn,")
        append("bucketName=$bucketName,")
        append("clientToken=$clientToken,")
        append("format=$format,")
        append("name=$name,")
        append("recommendationIds=$recommendationIds,")
        append("recommendationTypes=$recommendationTypes,")
        append("tags=*** Sensitive Data Redacted ***")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = assessmentArn.hashCode()
        result = 31 * result + (bucketName?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (format?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (recommendationIds?.hashCode() ?: 0)
        result = 31 * result + (recommendationTypes?.hashCode() ?: 0)
        result = 31 * result + (tags?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateRecommendationTemplateRequest

        if (assessmentArn != other.assessmentArn) return false
        if (bucketName != other.bucketName) return false
        if (clientToken != other.clientToken) return false
        if (format != other.format) return false
        if (name != other.name) return false
        if (recommendationIds != other.recommendationIds) return false
        if (recommendationTypes != other.recommendationTypes) return false
        if (tags != other.tags) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.CreateRecommendationTemplateRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var assessmentArn: kotlin.String? = null
        /**
         * The name of the Amazon S3 bucket that will contain the recommendation template.
         */
        public var bucketName: kotlin.String? = null
        /**
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
         */
        public var clientToken: kotlin.String? = null
        /**
         * The format for the recommendation template.
         *
         * ## CfnJson
         * The template is CloudFormation JSON.
         *
         * ## CfnYaml
         * The template is CloudFormation YAML.
         */
        public var format: aws.sdk.kotlin.services.resiliencehub.model.TemplateFormat? = null
        /**
         * The name for the recommendation template.
         */
        public var name: kotlin.String? = null
        /**
         * Identifiers for the recommendations used to create a recommendation template.
         */
        public var recommendationIds: List<String>? = null
        /**
         * An array of strings that specify the recommendation template type or types.
         *
         * ## Alarm
         * The template is an AlarmRecommendation template.
         *
         * ## Sop
         * The template is a SopRecommendation template.
         *
         * ## Test
         * The template is a TestRecommendation template.
         */
        public var recommendationTypes: List<RenderRecommendationType>? = null
        /**
         * Tags assigned to the resource. A tag is a label that you assign to an Amazon Web Services resource. Each tag consists of a key/value pair.
         */
        public var tags: Map<String, String>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.CreateRecommendationTemplateRequest) : this() {
            this.assessmentArn = x.assessmentArn
            this.bucketName = x.bucketName
            this.clientToken = x.clientToken
            this.format = x.format
            this.name = x.name
            this.recommendationIds = x.recommendationIds
            this.recommendationTypes = x.recommendationTypes
            this.tags = x.tags
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.CreateRecommendationTemplateRequest = CreateRecommendationTemplateRequest(this)

        internal fun correctErrors(): Builder {
            if (assessmentArn == null) assessmentArn = ""
            if (name == null) name = ""
            return this
        }
    }
}
