// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAppVersionResourceResponse private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Resilience Hub application version.
     */
    public val appVersion: kotlin.String = requireNotNull(builder.appVersion) { "A non-null value must be provided for appVersion" }
    /**
     * Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.
     */
    public val physicalResource: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource? = builder.physicalResource

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceResponse = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAppVersionResourceResponse(")
        append("appArn=$appArn,")
        append("appVersion=$appVersion,")
        append("physicalResource=$physicalResource")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (appVersion.hashCode())
        result = 31 * result + (physicalResource?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAppVersionResourceResponse

        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false
        if (physicalResource != other.physicalResource) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceResponse = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Resilience Hub application version.
         */
        public var appVersion: kotlin.String? = null
        /**
         * Defines a physical resource. A physical resource is a resource that exists in your account. It can be identified using an Amazon Resource Name (ARN) or a Resilience Hub-native identifier.
         */
        public var physicalResource: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceResponse) : this() {
            this.appArn = x.appArn
            this.appVersion = x.appVersion
            this.physicalResource = x.physicalResource
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceResponse = CreateAppVersionResourceResponse(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource] inside the given [block]
         */
        public fun physicalResource(block: aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource.Builder.() -> kotlin.Unit) {
            this.physicalResource = aws.sdk.kotlin.services.resiliencehub.model.PhysicalResource.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appVersion == null) appVersion = ""
            return this
        }
    }
}
