// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class CreateAppVersionResourceRequest private constructor(builder: Builder) {
    /**
     * Currently, there is no supported additional information for resources.
     */
    public val additionalInfo: Map<String, List<String>>? = builder.additionalInfo
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.
     */
    public val appComponents: List<String> = requireNotNull(builder.appComponents) { "A non-null value must be provided for appComponents" }
    /**
     * Amazon Web Services account that owns the physical resource.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Amazon Web Services region that owns the physical resource.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
     */
    public val clientToken: kotlin.String? = builder.clientToken
    /**
     * Logical identifier of the resource.
     */
    public val logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = builder.logicalResourceId
    /**
     * Physical identifier of the resource.
     */
    public val physicalResourceId: kotlin.String = requireNotNull(builder.physicalResourceId) { "A non-null value must be provided for physicalResourceId" }
    /**
     * Name of the resource.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * Type of resource.
     */
    public val resourceType: kotlin.String = requireNotNull(builder.resourceType) { "A non-null value must be provided for resourceType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("CreateAppVersionResourceRequest(")
        append("additionalInfo=$additionalInfo,")
        append("appArn=$appArn,")
        append("appComponents=$appComponents,")
        append("awsAccountId=$awsAccountId,")
        append("awsRegion=$awsRegion,")
        append("clientToken=$clientToken,")
        append("logicalResourceId=$logicalResourceId,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (appArn.hashCode())
        result = 31 * result + (appComponents.hashCode())
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (clientToken?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId.hashCode())
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as CreateAppVersionResourceRequest

        if (additionalInfo != other.additionalInfo) return false
        if (appArn != other.appArn) return false
        if (appComponents != other.appComponents) return false
        if (awsAccountId != other.awsAccountId) return false
        if (awsRegion != other.awsRegion) return false
        if (clientToken != other.clientToken) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Currently, there is no supported additional information for resources.
         */
        public var additionalInfo: Map<String, List<String>>? = null
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.
         */
        public var appComponents: List<String>? = null
        /**
         * Amazon Web Services account that owns the physical resource.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * Amazon Web Services region that owns the physical resource.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * Used for an idempotency token. A client token is a unique, case-sensitive string of up to 64 ASCII characters. You should not reuse the same client token for other API requests.
         */
        public var clientToken: kotlin.String? = null
        /**
         * Logical identifier of the resource.
         */
        public var logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = null
        /**
         * Physical identifier of the resource.
         */
        public var physicalResourceId: kotlin.String? = null
        /**
         * Name of the resource.
         */
        public var resourceName: kotlin.String? = null
        /**
         * Type of resource.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceRequest) : this() {
            this.additionalInfo = x.additionalInfo
            this.appArn = x.appArn
            this.appComponents = x.appComponents
            this.awsAccountId = x.awsAccountId
            this.awsRegion = x.awsRegion
            this.clientToken = x.clientToken
            this.logicalResourceId = x.logicalResourceId
            this.physicalResourceId = x.physicalResourceId
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceRequest = CreateAppVersionResourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId] inside the given [block]
         */
        public fun logicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.Builder.() -> kotlin.Unit) {
            this.logicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (appComponents == null) appComponents = emptyList()
            if (physicalResourceId == null) physicalResourceId = ""
            if (resourceType == null) resourceType = ""
            return this
        }
    }
}
