// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Indicates the compliance drifts (recovery time objective (RTO) and recovery point objective (RPO)) that were detected for an assessed entity.
 */
public class ComplianceDrift private constructor(builder: Builder) {
    /**
     * Assessment identifier that is associated with this drift item.
     */
    public val actualReferenceId: kotlin.String? = builder.actualReferenceId
    /**
     * Actual compliance value of the entity.
     */
    public val actualValue: Map<DisruptionType, DisruptionCompliance>? = builder.actualValue
    /**
     * Identifier of your application.
     */
    public val appId: kotlin.String? = builder.appId
    /**
     * Published version of your application on which drift was detected.
     */
    public val appVersion: kotlin.String? = builder.appVersion
    /**
     * Difference type between actual and expected recovery point objective (RPO) and recovery time objective (RTO) values. Currently, Resilience Hub supports only `NotEqual` difference type.
     */
    public val diffType: aws.sdk.kotlin.services.resiliencehub.model.DifferenceType? = builder.diffType
    /**
     * The type of drift detected. Currently, Resilience Hub supports only **ApplicationCompliance** drift type.
     */
    public val driftType: aws.sdk.kotlin.services.resiliencehub.model.DriftType? = builder.driftType
    /**
     * Identifier of an entity in which drift was detected. For compliance drift, the entity ID can be either application ID or the AppComponent ID.
     */
    public val entityId: kotlin.String? = builder.entityId
    /**
     * The type of entity in which drift was detected. For compliance drifts, Resilience Hub supports `AWS::ResilienceHub::AppComponent` and `AWS::ResilienceHub::Application`.
     */
    public val entityType: kotlin.String? = builder.entityType
    /**
     * Assessment identifier of a previous assessment of the same application version. Resilience Hub uses the previous assessment (associated with the reference identifier) to compare the compliance with the current assessment to identify drifts.
     */
    public val expectedReferenceId: kotlin.String? = builder.expectedReferenceId
    /**
     * The expected compliance value of an entity.
     */
    public val expectedValue: Map<DisruptionType, DisruptionCompliance>? = builder.expectedValue

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.ComplianceDrift = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("ComplianceDrift(")
        append("actualReferenceId=$actualReferenceId,")
        append("actualValue=$actualValue,")
        append("appId=$appId,")
        append("appVersion=$appVersion,")
        append("diffType=$diffType,")
        append("driftType=$driftType,")
        append("entityId=$entityId,")
        append("entityType=$entityType,")
        append("expectedReferenceId=$expectedReferenceId,")
        append("expectedValue=$expectedValue")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = actualReferenceId?.hashCode() ?: 0
        result = 31 * result + (actualValue?.hashCode() ?: 0)
        result = 31 * result + (appId?.hashCode() ?: 0)
        result = 31 * result + (appVersion?.hashCode() ?: 0)
        result = 31 * result + (diffType?.hashCode() ?: 0)
        result = 31 * result + (driftType?.hashCode() ?: 0)
        result = 31 * result + (entityId?.hashCode() ?: 0)
        result = 31 * result + (entityType?.hashCode() ?: 0)
        result = 31 * result + (expectedReferenceId?.hashCode() ?: 0)
        result = 31 * result + (expectedValue?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as ComplianceDrift

        if (actualReferenceId != other.actualReferenceId) return false
        if (actualValue != other.actualValue) return false
        if (appId != other.appId) return false
        if (appVersion != other.appVersion) return false
        if (diffType != other.diffType) return false
        if (driftType != other.driftType) return false
        if (entityId != other.entityId) return false
        if (entityType != other.entityType) return false
        if (expectedReferenceId != other.expectedReferenceId) return false
        if (expectedValue != other.expectedValue) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.ComplianceDrift = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Assessment identifier that is associated with this drift item.
         */
        public var actualReferenceId: kotlin.String? = null
        /**
         * Actual compliance value of the entity.
         */
        public var actualValue: Map<DisruptionType, DisruptionCompliance>? = null
        /**
         * Identifier of your application.
         */
        public var appId: kotlin.String? = null
        /**
         * Published version of your application on which drift was detected.
         */
        public var appVersion: kotlin.String? = null
        /**
         * Difference type between actual and expected recovery point objective (RPO) and recovery time objective (RTO) values. Currently, Resilience Hub supports only `NotEqual` difference type.
         */
        public var diffType: aws.sdk.kotlin.services.resiliencehub.model.DifferenceType? = null
        /**
         * The type of drift detected. Currently, Resilience Hub supports only **ApplicationCompliance** drift type.
         */
        public var driftType: aws.sdk.kotlin.services.resiliencehub.model.DriftType? = null
        /**
         * Identifier of an entity in which drift was detected. For compliance drift, the entity ID can be either application ID or the AppComponent ID.
         */
        public var entityId: kotlin.String? = null
        /**
         * The type of entity in which drift was detected. For compliance drifts, Resilience Hub supports `AWS::ResilienceHub::AppComponent` and `AWS::ResilienceHub::Application`.
         */
        public var entityType: kotlin.String? = null
        /**
         * Assessment identifier of a previous assessment of the same application version. Resilience Hub uses the previous assessment (associated with the reference identifier) to compare the compliance with the current assessment to identify drifts.
         */
        public var expectedReferenceId: kotlin.String? = null
        /**
         * The expected compliance value of an entity.
         */
        public var expectedValue: Map<DisruptionType, DisruptionCompliance>? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.ComplianceDrift) : this() {
            this.actualReferenceId = x.actualReferenceId
            this.actualValue = x.actualValue
            this.appId = x.appId
            this.appVersion = x.appVersion
            this.diffType = x.diffType
            this.driftType = x.driftType
            this.entityId = x.entityId
            this.entityType = x.entityType
            this.expectedReferenceId = x.expectedReferenceId
            this.expectedValue = x.expectedValue
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.ComplianceDrift = ComplianceDrift(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
