// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Indicates a specific risk identified in the Resilience Hub assessment and the corresponding recommendation provided to address that risk.
 *
 * The assessment summary generated by large language models (LLMs) on Amazon Bedrock are only suggestions. The current level of generative AI technology is not perfect and LLMs are not infallible. Bias and incorrect answers, although rare, should be expected. Review each recommendation in the assessment summary before you use the output from an LLM.
 *
 * This property is available only in the US East (N. Virginia) Region.
 */
public class AssessmentRiskRecommendation private constructor(builder: Builder) {
    /**
     * Indicates the Application Components (AppComponents) that were assessed as part of the assessment and are associated with the identified risk and recommendation.
     *
     * This property is available only in the US East (N. Virginia) Region.
     */
    public val appComponents: List<String>? = builder.appComponents
    /**
     * Indicates the recommendation provided by the Resilience Hub to address the identified risks in the application.
     *
     * This property is available only in the US East (N. Virginia) Region.
     */
    public val recommendation: kotlin.String? = builder.recommendation
    /**
     * Indicates the description of the potential risk identified in the application as part of the Resilience Hub assessment.
     *
     * This property is available only in the US East (N. Virginia) Region.
     */
    public val risk: kotlin.String? = builder.risk

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AssessmentRiskRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AssessmentRiskRecommendation(")
        append("appComponents=$appComponents,")
        append("recommendation=$recommendation,")
        append("risk=$risk")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appComponents?.hashCode() ?: 0
        result = 31 * result + (recommendation?.hashCode() ?: 0)
        result = 31 * result + (risk?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AssessmentRiskRecommendation

        if (appComponents != other.appComponents) return false
        if (recommendation != other.recommendation) return false
        if (risk != other.risk) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AssessmentRiskRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Indicates the Application Components (AppComponents) that were assessed as part of the assessment and are associated with the identified risk and recommendation.
         *
         * This property is available only in the US East (N. Virginia) Region.
         */
        public var appComponents: List<String>? = null
        /**
         * Indicates the recommendation provided by the Resilience Hub to address the identified risks in the application.
         *
         * This property is available only in the US East (N. Virginia) Region.
         */
        public var recommendation: kotlin.String? = null
        /**
         * Indicates the description of the potential risk identified in the application as part of the Resilience Hub assessment.
         *
         * This property is available only in the US East (N. Virginia) Region.
         */
        public var risk: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AssessmentRiskRecommendation) : this() {
            this.appComponents = x.appComponents
            this.recommendation = x.recommendation
            this.risk = x.risk
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AssessmentRiskRecommendation = AssessmentRiskRecommendation(this)

        internal fun correctErrors(): Builder {
            return this
        }
    }
}
