// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines an application summary.
 */
public class AppSummary private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     */
    public val assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = builder.assessmentSchedule
    /**
     * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val awsApplicationArn: kotlin.String? = builder.awsApplicationArn
    /**
     * The current status of compliance for the resiliency policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.AppComplianceStatusType? = builder.complianceStatus
    /**
     * Date and time when the app was created.
     */
    public val creationTime: aws.smithy.kotlin.runtime.time.Instant = requireNotNull(builder.creationTime) { "A non-null value must be provided for creationTime" }
    /**
     * The optional description for an app.
     */
    public val description: kotlin.String? = builder.description
    /**
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     */
    public val driftStatus: aws.sdk.kotlin.services.resiliencehub.model.AppDriftStatusType? = builder.driftStatus
    /**
     * Date and time of the most recent compliance evaluation.
     */
    public val lastAppComplianceEvaluationTime: aws.smithy.kotlin.runtime.time.Instant? = builder.lastAppComplianceEvaluationTime
    /**
     * The name of the application.
     */
    public val name: kotlin.String = requireNotNull(builder.name) { "A non-null value must be provided for name" }
    /**
     * The current resiliency score for the application.
     */
    public val resiliencyScore: kotlin.Double = builder.resiliencyScore
    /**
     * Recovery Point Objective (RPO) in seconds.
     */
    public val rpoInSecs: kotlin.Int? = builder.rpoInSecs
    /**
     * Recovery Time Objective (RTO) in seconds.
     */
    public val rtoInSecs: kotlin.Int? = builder.rtoInSecs
    /**
     * Status of the application.
     */
    public val status: aws.sdk.kotlin.services.resiliencehub.model.AppStatusType? = builder.status

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AppSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppSummary(")
        append("appArn=$appArn,")
        append("assessmentSchedule=$assessmentSchedule,")
        append("awsApplicationArn=$awsApplicationArn,")
        append("complianceStatus=$complianceStatus,")
        append("creationTime=$creationTime,")
        append("description=$description,")
        append("driftStatus=$driftStatus,")
        append("lastAppComplianceEvaluationTime=$lastAppComplianceEvaluationTime,")
        append("name=$name,")
        append("resiliencyScore=$resiliencyScore,")
        append("rpoInSecs=$rpoInSecs,")
        append("rtoInSecs=$rtoInSecs,")
        append("status=$status")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (assessmentSchedule?.hashCode() ?: 0)
        result = 31 * result + (awsApplicationArn?.hashCode() ?: 0)
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (creationTime.hashCode())
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (driftStatus?.hashCode() ?: 0)
        result = 31 * result + (lastAppComplianceEvaluationTime?.hashCode() ?: 0)
        result = 31 * result + (name.hashCode())
        result = 31 * result + (resiliencyScore.hashCode())
        result = 31 * result + (rpoInSecs ?: 0)
        result = 31 * result + (rtoInSecs ?: 0)
        result = 31 * result + (status?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppSummary

        if (appArn != other.appArn) return false
        if (assessmentSchedule != other.assessmentSchedule) return false
        if (awsApplicationArn != other.awsApplicationArn) return false
        if (complianceStatus != other.complianceStatus) return false
        if (creationTime != other.creationTime) return false
        if (description != other.description) return false
        if (driftStatus != other.driftStatus) return false
        if (lastAppComplianceEvaluationTime != other.lastAppComplianceEvaluationTime) return false
        if (name != other.name) return false
        if (!(resiliencyScore?.equals(other.resiliencyScore) ?: (other.resiliencyScore == null))) return false
        if (rpoInSecs != other.rpoInSecs) return false
        if (rtoInSecs != other.rtoInSecs) return false
        if (status != other.status) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AppSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         */
        public var assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = null
        /**
         * Amazon Resource Name (ARN) of Resource Groups group that is integrated with an AppRegistry application. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var awsApplicationArn: kotlin.String? = null
        /**
         * The current status of compliance for the resiliency policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.AppComplianceStatusType? = null
        /**
         * Date and time when the app was created.
         */
        public var creationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The optional description for an app.
         */
        public var description: kotlin.String? = null
        /**
         * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
         */
        public var driftStatus: aws.sdk.kotlin.services.resiliencehub.model.AppDriftStatusType? = null
        /**
         * Date and time of the most recent compliance evaluation.
         */
        public var lastAppComplianceEvaluationTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * The name of the application.
         */
        public var name: kotlin.String? = null
        /**
         * The current resiliency score for the application.
         */
        public var resiliencyScore: kotlin.Double = 0.0
        /**
         * Recovery Point Objective (RPO) in seconds.
         */
        public var rpoInSecs: kotlin.Int? = null
        /**
         * Recovery Time Objective (RTO) in seconds.
         */
        public var rtoInSecs: kotlin.Int? = null
        /**
         * Status of the application.
         */
        public var status: aws.sdk.kotlin.services.resiliencehub.model.AppStatusType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AppSummary) : this() {
            this.appArn = x.appArn
            this.assessmentSchedule = x.assessmentSchedule
            this.awsApplicationArn = x.awsApplicationArn
            this.complianceStatus = x.complianceStatus
            this.creationTime = x.creationTime
            this.description = x.description
            this.driftStatus = x.driftStatus
            this.lastAppComplianceEvaluationTime = x.lastAppComplianceEvaluationTime
            this.name = x.name
            this.resiliencyScore = x.resiliencyScore
            this.rpoInSecs = x.rpoInSecs
            this.rtoInSecs = x.rtoInSecs
            this.status = x.status
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AppSummary = AppSummary(this)

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            if (creationTime == null) creationTime = Instant.fromEpochSeconds(0)
            if (name == null) name = ""
            return this
        }
    }
}
