// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl
import aws.smithy.kotlin.runtime.time.Instant

/**
 * Defines an application assessment summary.
 */
public class AppAssessmentSummary private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String? = builder.appArn
    /**
     * Version of an application.
     */
    public val appVersion: kotlin.String? = builder.appVersion
    /**
     * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val assessmentArn: kotlin.String = requireNotNull(builder.assessmentArn) { "A non-null value must be provided for assessmentArn" }
    /**
     * Name of the assessment.
     */
    public val assessmentName: kotlin.String? = builder.assessmentName
    /**
     * Current status of the assessment for the resiliency policy.
     */
    public val assessmentStatus: aws.sdk.kotlin.services.resiliencehub.model.AssessmentStatus = requireNotNull(builder.assessmentStatus) { "A non-null value must be provided for assessmentStatus" }
    /**
     * Current status of compliance for the resiliency policy.
     */
    public val complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = builder.complianceStatus
    /**
     * Cost for an application.
     */
    public val cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = builder.cost
    /**
     * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
     */
    public val driftStatus: aws.sdk.kotlin.services.resiliencehub.model.DriftStatus? = builder.driftStatus
    /**
     * End time for the action.
     */
    public val endTime: aws.smithy.kotlin.runtime.time.Instant? = builder.endTime
    /**
     * Entity that invoked the assessment.
     */
    public val invoker: aws.sdk.kotlin.services.resiliencehub.model.AssessmentInvoker? = builder.invoker
    /**
     * Message from the assessment run.
     */
    public val message: kotlin.String? = builder.message
    /**
     * Current resiliency score for the application.
     */
    public val resiliencyScore: kotlin.Double = builder.resiliencyScore
    /**
     * Starting time for the action.
     */
    public val startTime: aws.smithy.kotlin.runtime.time.Instant? = builder.startTime
    /**
     * Name of an application version.
     */
    public val versionName: kotlin.String? = builder.versionName

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentSummary = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("AppAssessmentSummary(")
        append("appArn=$appArn,")
        append("appVersion=$appVersion,")
        append("assessmentArn=$assessmentArn,")
        append("assessmentName=$assessmentName,")
        append("assessmentStatus=$assessmentStatus,")
        append("complianceStatus=$complianceStatus,")
        append("cost=$cost,")
        append("driftStatus=$driftStatus,")
        append("endTime=$endTime,")
        append("invoker=$invoker,")
        append("message=$message,")
        append("resiliencyScore=$resiliencyScore,")
        append("startTime=$startTime,")
        append("versionName=$versionName")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn?.hashCode() ?: 0
        result = 31 * result + (appVersion?.hashCode() ?: 0)
        result = 31 * result + (assessmentArn.hashCode())
        result = 31 * result + (assessmentName?.hashCode() ?: 0)
        result = 31 * result + (assessmentStatus.hashCode())
        result = 31 * result + (complianceStatus?.hashCode() ?: 0)
        result = 31 * result + (cost?.hashCode() ?: 0)
        result = 31 * result + (driftStatus?.hashCode() ?: 0)
        result = 31 * result + (endTime?.hashCode() ?: 0)
        result = 31 * result + (invoker?.hashCode() ?: 0)
        result = 31 * result + (message?.hashCode() ?: 0)
        result = 31 * result + (resiliencyScore.hashCode())
        result = 31 * result + (startTime?.hashCode() ?: 0)
        result = 31 * result + (versionName?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as AppAssessmentSummary

        if (appArn != other.appArn) return false
        if (appVersion != other.appVersion) return false
        if (assessmentArn != other.assessmentArn) return false
        if (assessmentName != other.assessmentName) return false
        if (assessmentStatus != other.assessmentStatus) return false
        if (complianceStatus != other.complianceStatus) return false
        if (cost != other.cost) return false
        if (driftStatus != other.driftStatus) return false
        if (endTime != other.endTime) return false
        if (invoker != other.invoker) return false
        if (message != other.message) return false
        if (!(resiliencyScore?.equals(other.resiliencyScore) ?: (other.resiliencyScore == null))) return false
        if (startTime != other.startTime) return false
        if (versionName != other.versionName) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentSummary = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Version of an application.
         */
        public var appVersion: kotlin.String? = null
        /**
         * Amazon Resource Name (ARN) of the assessment. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app-assessment/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var assessmentArn: kotlin.String? = null
        /**
         * Name of the assessment.
         */
        public var assessmentName: kotlin.String? = null
        /**
         * Current status of the assessment for the resiliency policy.
         */
        public var assessmentStatus: aws.sdk.kotlin.services.resiliencehub.model.AssessmentStatus? = null
        /**
         * Current status of compliance for the resiliency policy.
         */
        public var complianceStatus: aws.sdk.kotlin.services.resiliencehub.model.ComplianceStatus? = null
        /**
         * Cost for an application.
         */
        public var cost: aws.sdk.kotlin.services.resiliencehub.model.Cost? = null
        /**
         * Indicates if compliance drifts (deviations) were detected while running an assessment for your application.
         */
        public var driftStatus: aws.sdk.kotlin.services.resiliencehub.model.DriftStatus? = null
        /**
         * End time for the action.
         */
        public var endTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Entity that invoked the assessment.
         */
        public var invoker: aws.sdk.kotlin.services.resiliencehub.model.AssessmentInvoker? = null
        /**
         * Message from the assessment run.
         */
        public var message: kotlin.String? = null
        /**
         * Current resiliency score for the application.
         */
        public var resiliencyScore: kotlin.Double = 0.0
        /**
         * Starting time for the action.
         */
        public var startTime: aws.smithy.kotlin.runtime.time.Instant? = null
        /**
         * Name of an application version.
         */
        public var versionName: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentSummary) : this() {
            this.appArn = x.appArn
            this.appVersion = x.appVersion
            this.assessmentArn = x.assessmentArn
            this.assessmentName = x.assessmentName
            this.assessmentStatus = x.assessmentStatus
            this.complianceStatus = x.complianceStatus
            this.cost = x.cost
            this.driftStatus = x.driftStatus
            this.endTime = x.endTime
            this.invoker = x.invoker
            this.message = x.message
            this.resiliencyScore = x.resiliencyScore
            this.startTime = x.startTime
            this.versionName = x.versionName
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentSummary = AppAssessmentSummary(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.Cost] inside the given [block]
         */
        public fun cost(block: aws.sdk.kotlin.services.resiliencehub.model.Cost.Builder.() -> kotlin.Unit) {
            this.cost = aws.sdk.kotlin.services.resiliencehub.model.Cost.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (assessmentArn == null) assessmentArn = ""
            if (assessmentStatus == null) assessmentStatus = AssessmentStatus.SdkUnknown("no value provided")
            return this
        }
    }
}
