// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub

import aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider
import aws.sdk.kotlin.runtime.auth.credentials.internal.manage
import aws.sdk.kotlin.runtime.config.AbstractAwsSdkClientFactory
import aws.sdk.kotlin.runtime.config.AwsSdkClientConfig
import aws.sdk.kotlin.runtime.config.endpoints.resolveEndpointUrl
import aws.sdk.kotlin.runtime.config.profile.AwsProfile
import aws.sdk.kotlin.runtime.config.profile.AwsSharedConfig
import aws.sdk.kotlin.runtime.http.retries.AwsRetryPolicy
import aws.sdk.kotlin.runtime.region.DefaultRegionProviderChain
import aws.sdk.kotlin.runtime.region.resolveRegion
import aws.sdk.kotlin.services.resiliencehub.auth.DefaultResiliencehubAuthSchemeProvider
import aws.sdk.kotlin.services.resiliencehub.auth.ResiliencehubAuthSchemeProvider
import aws.sdk.kotlin.services.resiliencehub.endpoints.DefaultResiliencehubEndpointProvider
import aws.sdk.kotlin.services.resiliencehub.endpoints.ResiliencehubEndpointParameters
import aws.sdk.kotlin.services.resiliencehub.endpoints.ResiliencehubEndpointProvider
import aws.sdk.kotlin.services.resiliencehub.model.AcceptResourceGroupingRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.AcceptResourceGroupingRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.AddDraftAppVersionResourceMappingsRequest
import aws.sdk.kotlin.services.resiliencehub.model.AddDraftAppVersionResourceMappingsResponse
import aws.sdk.kotlin.services.resiliencehub.model.BatchUpdateRecommendationStatusRequest
import aws.sdk.kotlin.services.resiliencehub.model.BatchUpdateRecommendationStatusResponse
import aws.sdk.kotlin.services.resiliencehub.model.CreateAppRequest
import aws.sdk.kotlin.services.resiliencehub.model.CreateAppResponse
import aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionAppComponentRequest
import aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionAppComponentResponse
import aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.CreateAppVersionResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.CreateRecommendationTemplateRequest
import aws.sdk.kotlin.services.resiliencehub.model.CreateRecommendationTemplateResponse
import aws.sdk.kotlin.services.resiliencehub.model.CreateResiliencyPolicyRequest
import aws.sdk.kotlin.services.resiliencehub.model.CreateResiliencyPolicyResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppAssessmentRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppAssessmentResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppInputSourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppInputSourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppVersionAppComponentRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppVersionAppComponentResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppVersionResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteAppVersionResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteRecommendationTemplateRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteRecommendationTemplateResponse
import aws.sdk.kotlin.services.resiliencehub.model.DeleteResiliencyPolicyRequest
import aws.sdk.kotlin.services.resiliencehub.model.DeleteResiliencyPolicyResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppAssessmentRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppAssessmentResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionAppComponentRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionAppComponentResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResourcesResolutionStatusResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionTemplateRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeAppVersionTemplateResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeDraftAppVersionResourcesImportStatusResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeMetricsExportRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeMetricsExportResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeResiliencyPolicyRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeResiliencyPolicyResponse
import aws.sdk.kotlin.services.resiliencehub.model.DescribeResourceGroupingRecommendationTaskRequest
import aws.sdk.kotlin.services.resiliencehub.model.DescribeResourceGroupingRecommendationTaskResponse
import aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionRequest
import aws.sdk.kotlin.services.resiliencehub.model.ImportResourcesToDraftAppVersionResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAlarmRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAlarmRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppAssessmentComplianceDriftsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppAssessmentComplianceDriftsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppAssessmentResourceDriftsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppAssessmentResourceDriftsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppAssessmentsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppAssessmentsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppComponentCompliancesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppComponentCompliancesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppComponentRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppComponentRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppInputSourcesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppInputSourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionAppComponentsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionAppComponentsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourceMappingsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourceMappingsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourcesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppVersionsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListAppsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListAppsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListMetricsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListMetricsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListRecommendationTemplatesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListRecommendationTemplatesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListResiliencyPoliciesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListResiliencyPoliciesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListResourceGroupingRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListResourceGroupingRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListSopRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListSopRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListSuggestedResiliencyPoliciesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListSuggestedResiliencyPoliciesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListTagsForResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListTagsForResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListTestRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListTestRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ListUnsupportedAppVersionResourcesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ListUnsupportedAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.PublishAppVersionRequest
import aws.sdk.kotlin.services.resiliencehub.model.PublishAppVersionResponse
import aws.sdk.kotlin.services.resiliencehub.model.PutDraftAppVersionTemplateRequest
import aws.sdk.kotlin.services.resiliencehub.model.PutDraftAppVersionTemplateResponse
import aws.sdk.kotlin.services.resiliencehub.model.RejectResourceGroupingRecommendationsRequest
import aws.sdk.kotlin.services.resiliencehub.model.RejectResourceGroupingRecommendationsResponse
import aws.sdk.kotlin.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsRequest
import aws.sdk.kotlin.services.resiliencehub.model.RemoveDraftAppVersionResourceMappingsResponse
import aws.sdk.kotlin.services.resiliencehub.model.ResolveAppVersionResourcesRequest
import aws.sdk.kotlin.services.resiliencehub.model.ResolveAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.StartAppAssessmentRequest
import aws.sdk.kotlin.services.resiliencehub.model.StartAppAssessmentResponse
import aws.sdk.kotlin.services.resiliencehub.model.StartMetricsExportRequest
import aws.sdk.kotlin.services.resiliencehub.model.StartMetricsExportResponse
import aws.sdk.kotlin.services.resiliencehub.model.StartResourceGroupingRecommendationTaskRequest
import aws.sdk.kotlin.services.resiliencehub.model.StartResourceGroupingRecommendationTaskResponse
import aws.sdk.kotlin.services.resiliencehub.model.TagResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.TagResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.UntagResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.UntagResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppResponse
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionAppComponentRequest
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionAppComponentResponse
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionRequest
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionResourceRequest
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionResourceResponse
import aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionResponse
import aws.sdk.kotlin.services.resiliencehub.model.UpdateResiliencyPolicyRequest
import aws.sdk.kotlin.services.resiliencehub.model.UpdateResiliencyPolicyResponse
import aws.smithy.kotlin.runtime.auth.AuthSchemeId
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProvider
import aws.smithy.kotlin.runtime.auth.awscredentials.CredentialsProviderConfig
import aws.smithy.kotlin.runtime.awsprotocol.ClockSkewInterceptor
import aws.smithy.kotlin.runtime.client.AbstractSdkClientBuilder
import aws.smithy.kotlin.runtime.client.AbstractSdkClientFactory
import aws.smithy.kotlin.runtime.client.IdempotencyTokenConfig
import aws.smithy.kotlin.runtime.client.IdempotencyTokenProvider
import aws.smithy.kotlin.runtime.client.LogMode
import aws.smithy.kotlin.runtime.client.RetryClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfig
import aws.smithy.kotlin.runtime.client.RetryStrategyClientConfigImpl
import aws.smithy.kotlin.runtime.client.SdkClient
import aws.smithy.kotlin.runtime.client.SdkClientConfig
import aws.smithy.kotlin.runtime.client.region.RegionProvider
import aws.smithy.kotlin.runtime.http.auth.AuthScheme
import aws.smithy.kotlin.runtime.http.auth.HttpAuthConfig
import aws.smithy.kotlin.runtime.http.config.HttpClientConfig
import aws.smithy.kotlin.runtime.http.config.HttpEngineConfig
import aws.smithy.kotlin.runtime.http.config.TimeoutConfig
import aws.smithy.kotlin.runtime.http.engine.HttpClientEngine
import aws.smithy.kotlin.runtime.http.engine.HttpEngineConfigImpl
import aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor
import aws.smithy.kotlin.runtime.net.url.Url
import aws.smithy.kotlin.runtime.retries.RetryStrategy
import aws.smithy.kotlin.runtime.retries.policy.RetryPolicy
import aws.smithy.kotlin.runtime.telemetry.Global
import aws.smithy.kotlin.runtime.telemetry.TelemetryConfig
import aws.smithy.kotlin.runtime.telemetry.TelemetryProvider
import aws.smithy.kotlin.runtime.util.LazyAsyncValue
import kotlin.collections.List
import kotlin.jvm.JvmStatic
import kotlin.time.Duration
import kotlinx.coroutines.runBlocking


public const val ServiceId: String = "resiliencehub"
public const val SdkVersion: String = "1.5.22"
public const val ServiceApiVersion: String = "2020-04-30"

/**
 * Resilience Hub helps you proactively prepare and protect your Amazon Web Services applications from disruptions. It offers continual resiliency assessment and validation that integrates into your software development lifecycle. This enables you to uncover resiliency weaknesses, ensure recovery time objective (RTO) and recovery point objective (RPO) targets for your applications are met, and resolve issues before they are released into production.
 */
public interface ResiliencehubClient : SdkClient {
    /**
     * ResiliencehubClient's configuration
     */
    public override val config: Config

    public companion object : AbstractAwsSdkClientFactory<Config, Config.Builder, ResiliencehubClient, Builder>()
     {
        @JvmStatic
        override fun builder(): Builder = Builder()

        override fun finalizeConfig(builder: Builder) {
            super.finalizeConfig(builder)
            builder.config.interceptors.add(0, ClockSkewInterceptor())
        }

        override suspend fun finalizeEnvironmentalConfig(builder: Builder, sharedConfig: LazyAsyncValue<AwsSharedConfig>, activeProfile: LazyAsyncValue<AwsProfile>) {
            super.finalizeEnvironmentalConfig(builder, sharedConfig, activeProfile)
            builder.config.endpointUrl = builder.config.endpointUrl ?: resolveEndpointUrl(
                sharedConfig,
                "Resiliencehub",
                "RESILIENCEHUB",
                "resiliencehub",
            )
        }
    }

    public class Builder internal constructor(): AbstractSdkClientBuilder<Config, Config.Builder, ResiliencehubClient>() {
        override val config: Config.Builder = Config.Builder()
        override fun newClient(config: Config): ResiliencehubClient = DefaultResiliencehubClient(config)
    }

    public class Config private constructor(builder: Builder) : AwsSdkClientConfig, CredentialsProviderConfig, HttpAuthConfig, HttpClientConfig, HttpEngineConfig by builder.buildHttpEngineConfig(), IdempotencyTokenConfig, RetryClientConfig, RetryStrategyClientConfig by builder.buildRetryStrategyClientConfig(), SdkClientConfig, TelemetryConfig, TimeoutConfig {
        override val clientName: String = builder.clientName
        override val region: String? = builder.region ?: runBlocking { builder.regionProvider?.getRegion() ?: resolveRegion() }
        override val regionProvider: RegionProvider = builder.regionProvider ?: DefaultRegionProviderChain()
        override val attemptTimeout: Duration? = builder.attemptTimeout
        override val authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = builder.authSchemePreference
        override val authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = builder.authSchemes
        override val callTimeout: Duration? = builder.callTimeout
        override val credentialsProvider: CredentialsProvider = builder.credentialsProvider ?: DefaultChainCredentialsProvider(httpClient = httpClient, region = region).manage()
        public val endpointProvider: ResiliencehubEndpointProvider = builder.endpointProvider ?: DefaultResiliencehubEndpointProvider()
        public val endpointUrl: Url? = builder.endpointUrl
        override val idempotencyTokenProvider: IdempotencyTokenProvider = builder.idempotencyTokenProvider ?: IdempotencyTokenProvider.Default
        override val interceptors: kotlin.collections.List<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = builder.interceptors
        override val logMode: LogMode = builder.logMode ?: LogMode.Default
        override val retryPolicy: RetryPolicy<Any?> = builder.retryPolicy ?: AwsRetryPolicy.Default
        override val telemetryProvider: TelemetryProvider = builder.telemetryProvider ?: TelemetryProvider.Global
        override val useDualStack: Boolean = builder.useDualStack ?: false
        override val useFips: Boolean = builder.useFips ?: false
        override val applicationId: String? = builder.applicationId
        public val authSchemeProvider: ResiliencehubAuthSchemeProvider = builder.authSchemeProvider ?: DefaultResiliencehubAuthSchemeProvider(authSchemePreference = authSchemePreference)
        public companion object {
            public inline operator fun invoke(block: Builder.() -> kotlin.Unit): Config = Builder().apply(block).build()
        }

        public fun toBuilder(): Builder = Builder().apply {
            clientName = this@Config.clientName
            region = this@Config.region
            regionProvider = this@Config.regionProvider
            attemptTimeout = this@Config.attemptTimeout
            authSchemePreference = this@Config.authSchemePreference
            authSchemes = this@Config.authSchemes
            callTimeout = this@Config.callTimeout
            credentialsProvider = this@Config.credentialsProvider
            endpointProvider = this@Config.endpointProvider
            endpointUrl = this@Config.endpointUrl
            httpClient = this@Config.httpClient
            idempotencyTokenProvider = this@Config.idempotencyTokenProvider
            interceptors = this@Config.interceptors.toMutableList()
            logMode = this@Config.logMode
            retryPolicy = this@Config.retryPolicy
            retryStrategy = this@Config.retryStrategy
            telemetryProvider = this@Config.telemetryProvider
            useDualStack = this@Config.useDualStack
            useFips = this@Config.useFips
            applicationId = this@Config.applicationId
            authSchemeProvider = this@Config.authSchemeProvider
        }

        public class Builder : AwsSdkClientConfig.Builder, CredentialsProviderConfig.Builder, HttpAuthConfig.Builder, HttpClientConfig.Builder, HttpEngineConfig.Builder by HttpEngineConfigImpl.BuilderImpl(), IdempotencyTokenConfig.Builder, RetryClientConfig.Builder, RetryStrategyClientConfig.Builder by RetryStrategyClientConfigImpl.BuilderImpl(), SdkClientConfig.Builder<Config>, TelemetryConfig.Builder, TimeoutConfig.Builder {
            /**
             * A reader-friendly name for the client.
             */
            override var clientName: String = "resiliencehub"

            /**
             * The AWS region (e.g. `us-west-2`) to make requests to. See about AWS
             * [global infrastructure](https://aws.amazon.com/about-aws/global-infrastructure/regions_az/) for more information.
             * When specified, this static region configuration takes precedence over other region resolution methods.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var region: String? = null

            /**
             * An optional region provider that determines the AWS region for client operations. When specified, this provider
             * takes precedence over the default region provider chain, unless a static region is explicitly configured.
             *
             * The region resolution order is:
             * 1. Static region (if specified)
             * 2. Custom region provider (if configured)
             * 3. Default region provider chain
             */
            override var regionProvider: RegionProvider? = null

            /**
             * The maximum amount of time to wait for any single attempt of a request within the retry loop. By default,
             * the value is `null` indicating no timeout is enforced. Attempt timeouts may be retried if allowed by the
             * current retry policy and retry capacity.
             */
            override var attemptTimeout: Duration? = null

            /**
             * The ordered preference of [AuthScheme] that this client will use.
             */
            override var authSchemePreference: kotlin.collections.List<aws.smithy.kotlin.runtime.auth.AuthSchemeId>? = null

            /**
             * Register new or override default [AuthScheme]s configured for this client. By default, the set
             * of auth schemes configured comes from the service model. An auth scheme configured explicitly takes
             * precedence over the defaults and can be used to customize identity resolution and signing for specific
             * authentication schemes.
             */
            override var authSchemes: kotlin.collections.List<aws.smithy.kotlin.runtime.http.auth.AuthScheme> = emptyList()

            /**
             * The maximum amount of time to wait for completion of a call, including any retries after the first attempt.
             * By default, the value is `null` indicating no timeout is enforced. Call timeouts are not retried.
             */
            override var callTimeout: Duration? = null

            /**
             * The AWS credentials provider to use for authenticating requests. If not provided a
             * [aws.sdk.kotlin.runtime.auth.credentials.DefaultChainCredentialsProvider] instance will be used.
             * NOTE: The caller is responsible for managing the lifetime of the provider when set. The SDK
             * client will not close it when the client is closed.
             */
            override var credentialsProvider: CredentialsProvider? = null

            /**
             * The endpoint provider used to determine where to make service requests. **This is an advanced config
             * option.**
             *
             * Endpoint resolution occurs as part of the workflow for every request made via the service client.
             *
             * The inputs to endpoint resolution are defined on a per-service basis (see [EndpointParameters]).
             */
            public var endpointProvider: ResiliencehubEndpointProvider? = null

            /**
             * A custom endpoint to route requests to. The endpoint set here is passed to the configured
             * [endpointProvider], which may inspect and modify it as needed.
             *
             * Setting a custom endpointUrl should generally be preferred to overriding the [endpointProvider] and is
             * the recommended way to route requests to development or preview instances of a service.
             *
             * **This is an advanced config option.**
             */
            public var endpointUrl: Url? = null

            /**
             * Override the default idempotency token generator. SDK clients will generate tokens for members
             * that represent idempotent tokens when not explicitly set by the caller using this generator.
             */
            override var idempotencyTokenProvider: IdempotencyTokenProvider? = null

            /**
             * Add an [aws.smithy.kotlin.runtime.client.Interceptor] that will have access to read and modify
             * the request and response objects as they are processed by the SDK.
             * Interceptors added using this method are executed in the order they are configured and are always
             * later than any added automatically by the SDK.
             */
            override var interceptors: kotlin.collections.MutableList<aws.smithy.kotlin.runtime.http.interceptors.HttpInterceptor> = kotlin.collections.mutableListOf()

            /**
             * Configure events that will be logged. By default clients will not output
             * raw requests or responses. Use this setting to opt-in to additional debug logging.
             *
             * This can be used to configure logging of requests, responses, retries, etc of SDK clients.
             *
             * **NOTE**: Logging of raw requests or responses may leak sensitive information! It may also have
             * performance considerations when dumping the request/response body. This is primarily a tool for
             * debug purposes.
             */
            override var logMode: LogMode? = null

            /**
             * The policy to use for evaluating operation results and determining whether/how to retry.
             */
            override var retryPolicy: RetryPolicy<Any?>? = null

            /**
             * The telemetry provider used to instrument the SDK operations with. By default, the global telemetry
             * provider will be used.
             */
            override var telemetryProvider: TelemetryProvider? = null

            /**
             *            Flag to toggle whether to use dual-stack endpoints when making requests.
             *            See [https://docs.aws.amazon.com/sdkref/latest/guide/feature-endpoints.html] for more information.
             * `          Disabled by default.
             */
            override var useDualStack: Boolean? = null

            /**
             *            Flag to toggle whether to use [FIPS](https://aws.amazon.com/compliance/fips/) endpoints when making requests.
             * `          Disabled by default.
             */
            override var useFips: Boolean? = null

            /**
             * An optional application specific identifier.
             * When set it will be appended to the User-Agent header of every request in the form of: `app/{applicationId}`.
             * When not explicitly set, the value will be loaded from the following locations:
             *
             * - JVM System Property: `aws.userAgentAppId`
             * - Environment variable: `AWS_SDK_UA_APP_ID`
             * - Shared configuration profile attribute: `sdk_ua_app_id`
             *
             * See [shared configuration settings](https://docs.aws.amazon.com/sdkref/latest/guide/settings-reference.html)
             * reference for more information on environment variables and shared config settings.
             */
            override var applicationId: String? = null

            /**
             * Configure the provider used to resolve the authentication scheme to use for a particular operation.
             */
            public var authSchemeProvider: ResiliencehubAuthSchemeProvider? = null

            override fun build(): Config = Config(this)
        }
    }

    /**
     * Accepts the resource grouping recommendations suggested by Resilience Hub for your application.
     */
    public suspend fun acceptResourceGroupingRecommendations(input: AcceptResourceGroupingRecommendationsRequest): AcceptResourceGroupingRecommendationsResponse

    /**
     * Adds the source of resource-maps to the draft version of an application. During assessment, Resilience Hub will use these resource-maps to resolve the latest physical ID for each resource in the application template. For more information about different types of resources supported by Resilience Hub and how to add them in your application, see [Step 2: How is your application managed?](https://docs.aws.amazon.com/resilience-hub/latest/userguide/how-app-manage.html) in the Resilience Hub User Guide.
     */
    public suspend fun addDraftAppVersionResourceMappings(input: AddDraftAppVersionResourceMappingsRequest): AddDraftAppVersionResourceMappingsResponse

    /**
     * Enables you to include or exclude one or more operational recommendations.
     */
    public suspend fun batchUpdateRecommendationStatus(input: BatchUpdateRecommendationStatusRequest): BatchUpdateRecommendationStatusResponse

    /**
     * Creates an Resilience Hub application. An Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more CloudFormation stacks, Resource Groups, Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In addition, you can also add resources that are located on Amazon Elastic Kubernetes Service (Amazon EKS) clusters as optional resources. For more information about the number of resources supported per application, see [Service quotas](https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub).
     *
     * After you create an Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
     */
    public suspend fun createApp(input: CreateAppRequest): CreateAppResponse

    /**
     * Creates a new Application Component in the Resilience Hub application.
     *
     * This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
     */
    public suspend fun createAppVersionAppComponent(input: CreateAppVersionAppComponentRequest): CreateAppVersionAppComponentResponse

    /**
     * Adds a resource to the Resilience Hub application and assigns it to the specified Application Components. If you specify a new Application Component, Resilience Hub will automatically create the Application Component.
     *
     * + This action has no effect outside Resilience Hub.
     * + This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
     * + To update application version with new `physicalResourceID`, you must call `ResolveAppVersionResources` API.
     */
    public suspend fun createAppVersionResource(input: CreateAppVersionResourceRequest): CreateAppVersionResourceResponse

    /**
     * Creates a new recommendation template for the Resilience Hub application.
     */
    public suspend fun createRecommendationTemplate(input: CreateRecommendationTemplateRequest): CreateRecommendationTemplateResponse

    /**
     * Creates a resiliency policy for an application.
     *
     * Resilience Hub allows you to provide a value of zero for `rtoInSecs` and `rpoInSecs` of your resiliency policy. But, while assessing your application, the lowest possible assessment result is near zero. Hence, if you provide value zero for `rtoInSecs` and `rpoInSecs`, the estimated workload RTO and estimated workload RPO result will be near zero and the **Compliance status** for your application will be set to **Policy breached**.
     */
    public suspend fun createResiliencyPolicy(input: CreateResiliencyPolicyRequest): CreateResiliencyPolicyResponse

    /**
     * Deletes an Resilience Hub application. This is a destructive action that can't be undone.
     */
    public suspend fun deleteApp(input: DeleteAppRequest): DeleteAppResponse

    /**
     * Deletes an Resilience Hub application assessment. This is a destructive action that can't be undone.
     */
    public suspend fun deleteAppAssessment(input: DeleteAppAssessmentRequest): DeleteAppAssessmentResponse

    /**
     * Deletes the input source and all of its imported resources from the Resilience Hub application.
     */
    public suspend fun deleteAppInputSource(input: DeleteAppInputSourceRequest): DeleteAppInputSourceResponse

    /**
     * Deletes an Application Component from the Resilience Hub application.
     *
     * + This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
     * + You will not be able to delete an Application Component if it has resources associated with it.
     */
    public suspend fun deleteAppVersionAppComponent(input: DeleteAppVersionAppComponentRequest): DeleteAppVersionAppComponentResponse

    /**
     * Deletes a resource from the Resilience Hub application.
     *
     * + You can only delete a manually added resource. To exclude non-manually added resources, use the `UpdateAppVersionResource` API.
     * + This action has no effect outside Resilience Hub.
     * + This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
     */
    public suspend fun deleteAppVersionResource(input: DeleteAppVersionResourceRequest): DeleteAppVersionResourceResponse

    /**
     * Deletes a recommendation template. This is a destructive action that can't be undone.
     */
    public suspend fun deleteRecommendationTemplate(input: DeleteRecommendationTemplateRequest): DeleteRecommendationTemplateResponse

    /**
     * Deletes a resiliency policy. This is a destructive action that can't be undone.
     */
    public suspend fun deleteResiliencyPolicy(input: DeleteResiliencyPolicyRequest): DeleteResiliencyPolicyResponse

    /**
     * Describes an Resilience Hub application.
     */
    public suspend fun describeApp(input: DescribeAppRequest): DescribeAppResponse

    /**
     * Describes an assessment for an Resilience Hub application.
     */
    public suspend fun describeAppAssessment(input: DescribeAppAssessmentRequest): DescribeAppAssessmentResponse

    /**
     * Describes the Resilience Hub application version.
     */
    public suspend fun describeAppVersion(input: DescribeAppVersionRequest): DescribeAppVersionResponse

    /**
     * Describes an Application Component in the Resilience Hub application.
     */
    public suspend fun describeAppVersionAppComponent(input: DescribeAppVersionAppComponentRequest): DescribeAppVersionAppComponentResponse

    /**
     * Describes a resource of the Resilience Hub application.
     *
     * This API accepts only one of the following parameters to describe the resource:
     * + `resourceName`
     * + `logicalResourceId`
     * + `physicalResourceId` (Along with `physicalResourceId`, you can also provide `awsAccountId`, and `awsRegion`)
     */
    public suspend fun describeAppVersionResource(input: DescribeAppVersionResourceRequest): DescribeAppVersionResourceResponse

    /**
     * Returns the resolution status for the specified resolution identifier for an application version. If `resolutionId` is not specified, the current resolution status is returned.
     */
    public suspend fun describeAppVersionResourcesResolutionStatus(input: DescribeAppVersionResourcesResolutionStatusRequest): DescribeAppVersionResourcesResolutionStatusResponse

    /**
     * Describes details about an Resilience Hub application.
     */
    public suspend fun describeAppVersionTemplate(input: DescribeAppVersionTemplateRequest): DescribeAppVersionTemplateResponse

    /**
     * Describes the status of importing resources to an application version.
     *
     * If you get a 404 error with `ResourceImportStatusNotFoundAppMetadataException`, you must call `importResourcesToDraftAppVersion` after creating the application and before calling `describeDraftAppVersionResourcesImportStatus` to obtain the status.
     */
    public suspend fun describeDraftAppVersionResourcesImportStatus(input: DescribeDraftAppVersionResourcesImportStatusRequest): DescribeDraftAppVersionResourcesImportStatusResponse

    /**
     * Describes the metrics of the application configuration being exported.
     */
    public suspend fun describeMetricsExport(input: DescribeMetricsExportRequest): DescribeMetricsExportResponse

    /**
     * Describes a specified resiliency policy for an Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
     */
    public suspend fun describeResiliencyPolicy(input: DescribeResiliencyPolicyRequest): DescribeResiliencyPolicyResponse

    /**
     * Describes the resource grouping recommendation tasks run by Resilience Hub for your application.
     */
    public suspend fun describeResourceGroupingRecommendationTask(input: DescribeResourceGroupingRecommendationTaskRequest): DescribeResourceGroupingRecommendationTaskResponse

    /**
     * Imports resources to Resilience Hub application draft version from different input sources. For more information about the input sources supported by Resilience Hub, see [Discover the structure and describe your Resilience Hub application](https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html).
     */
    public suspend fun importResourcesToDraftAppVersion(input: ImportResourcesToDraftAppVersionRequest): ImportResourcesToDraftAppVersionResponse

    /**
     * Lists the alarm recommendations for an Resilience Hub application.
     */
    public suspend fun listAlarmRecommendations(input: ListAlarmRecommendationsRequest): ListAlarmRecommendationsResponse

    /**
     * List of compliance drifts that were detected while running an assessment.
     */
    public suspend fun listAppAssessmentComplianceDrifts(input: ListAppAssessmentComplianceDriftsRequest): ListAppAssessmentComplianceDriftsResponse

    /**
     * List of resource drifts that were detected while running an assessment.
     */
    public suspend fun listAppAssessmentResourceDrifts(input: ListAppAssessmentResourceDriftsRequest): ListAppAssessmentResourceDriftsResponse

    /**
     * Lists the assessments for an Resilience Hub application. You can use request parameters to refine the results for the response object.
     */
    public suspend fun listAppAssessments(input: ListAppAssessmentsRequest = ListAppAssessmentsRequest { }): ListAppAssessmentsResponse

    /**
     * Lists the compliances for an Resilience Hub Application Component.
     */
    public suspend fun listAppComponentCompliances(input: ListAppComponentCompliancesRequest): ListAppComponentCompliancesResponse

    /**
     * Lists the recommendations for an Resilience Hub Application Component.
     */
    public suspend fun listAppComponentRecommendations(input: ListAppComponentRecommendationsRequest): ListAppComponentRecommendationsResponse

    /**
     * Lists all the input sources of the Resilience Hub application. For more information about the input sources supported by Resilience Hub, see [Discover the structure and describe your Resilience Hub application](https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html).
     */
    public suspend fun listAppInputSources(input: ListAppInputSourcesRequest): ListAppInputSourcesResponse

    /**
     * Lists all the Application Components in the Resilience Hub application.
     */
    public suspend fun listAppVersionAppComponents(input: ListAppVersionAppComponentsRequest): ListAppVersionAppComponentsResponse

    /**
     * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.
     */
    public suspend fun listAppVersionResourceMappings(input: ListAppVersionResourceMappingsRequest): ListAppVersionResourceMappingsResponse

    /**
     * Lists all the resources in an Resilience Hub application.
     */
    public suspend fun listAppVersionResources(input: ListAppVersionResourcesRequest): ListAppVersionResourcesResponse

    /**
     * Lists the different versions for the Resilience Hub applications.
     */
    public suspend fun listAppVersions(input: ListAppVersionsRequest): ListAppVersionsResponse

    /**
     * Lists your Resilience Hub applications.
     *
     * You can filter applications using only one filter at a time or without using any filter. If you try to filter applications using multiple filters, you will get the following error:
     *
     * `An error occurred (ValidationException) when calling the ListApps operation: Only one filter is supported for this operation.`
     */
    public suspend fun listApps(input: ListAppsRequest = ListAppsRequest { }): ListAppsResponse

    /**
     * Lists the metrics that can be exported.
     */
    public suspend fun listMetrics(input: ListMetricsRequest = ListMetricsRequest { }): ListMetricsResponse

    /**
     * Lists the recommendation templates for the Resilience Hub applications.
     */
    public suspend fun listRecommendationTemplates(input: ListRecommendationTemplatesRequest = ListRecommendationTemplatesRequest { }): ListRecommendationTemplatesResponse

    /**
     * Lists the resiliency policies for the Resilience Hub applications.
     */
    public suspend fun listResiliencyPolicies(input: ListResiliencyPoliciesRequest = ListResiliencyPoliciesRequest { }): ListResiliencyPoliciesResponse

    /**
     * Lists the resource grouping recommendations suggested by Resilience Hub for your application.
     */
    public suspend fun listResourceGroupingRecommendations(input: ListResourceGroupingRecommendationsRequest = ListResourceGroupingRecommendationsRequest { }): ListResourceGroupingRecommendationsResponse

    /**
     * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
     */
    public suspend fun listSopRecommendations(input: ListSopRecommendationsRequest): ListSopRecommendationsResponse

    /**
     * Lists the suggested resiliency policies for the Resilience Hub applications.
     */
    public suspend fun listSuggestedResiliencyPolicies(input: ListSuggestedResiliencyPoliciesRequest = ListSuggestedResiliencyPoliciesRequest { }): ListSuggestedResiliencyPoliciesResponse

    /**
     * Lists the tags for your resources in your Resilience Hub applications.
     */
    public suspend fun listTagsForResource(input: ListTagsForResourceRequest): ListTagsForResourceResponse

    /**
     * Lists the test recommendations for the Resilience Hub application.
     */
    public suspend fun listTestRecommendations(input: ListTestRecommendationsRequest): ListTestRecommendationsResponse

    /**
     * Lists the resources that are not currently supported in Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.
     */
    public suspend fun listUnsupportedAppVersionResources(input: ListUnsupportedAppVersionResourcesRequest): ListUnsupportedAppVersionResourcesResponse

    /**
     * Publishes a new version of a specific Resilience Hub application.
     */
    public suspend fun publishAppVersion(input: PublishAppVersionRequest): PublishAppVersionResponse

    /**
     * Adds or updates the app template for an Resilience Hub application draft version.
     */
    public suspend fun putDraftAppVersionTemplate(input: PutDraftAppVersionTemplateRequest): PutDraftAppVersionTemplateResponse

    /**
     * Rejects resource grouping recommendations.
     */
    public suspend fun rejectResourceGroupingRecommendations(input: RejectResourceGroupingRecommendationsRequest): RejectResourceGroupingRecommendationsResponse

    /**
     * Removes resource mappings from a draft application version.
     */
    public suspend fun removeDraftAppVersionResourceMappings(input: RemoveDraftAppVersionResourceMappingsRequest): RemoveDraftAppVersionResourceMappingsResponse

    /**
     * Resolves the resources for an application version.
     */
    public suspend fun resolveAppVersionResources(input: ResolveAppVersionResourcesRequest): ResolveAppVersionResourcesResponse

    /**
     * Creates a new application assessment for an application.
     */
    public suspend fun startAppAssessment(input: StartAppAssessmentRequest): StartAppAssessmentResponse

    /**
     * Initiates the export task of metrics.
     */
    public suspend fun startMetricsExport(input: StartMetricsExportRequest = StartMetricsExportRequest { }): StartMetricsExportResponse

    /**
     * Starts grouping recommendation task.
     */
    public suspend fun startResourceGroupingRecommendationTask(input: StartResourceGroupingRecommendationTaskRequest): StartResourceGroupingRecommendationTaskResponse

    /**
     * Applies one or more tags to a resource.
     */
    public suspend fun tagResource(input: TagResourceRequest): TagResourceResponse

    /**
     * Removes one or more tags from a resource.
     */
    public suspend fun untagResource(input: UntagResourceRequest): UntagResourceResponse

    /**
     * Updates an application.
     */
    public suspend fun updateApp(input: UpdateAppRequest): UpdateAppResponse

    /**
     * Updates the Resilience Hub application version.
     *
     * This API updates the Resilience Hub application draft version. To use this information for running resiliency assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
     */
    public suspend fun updateAppVersion(input: UpdateAppVersionRequest): UpdateAppVersionResponse

    /**
     * Updates an existing Application Component in the Resilience Hub application.
     *
     * This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
     */
    public suspend fun updateAppVersionAppComponent(input: UpdateAppVersionAppComponentRequest): UpdateAppVersionAppComponentResponse

    /**
     * Updates the resource details in the Resilience Hub application.
     *
     * + This action has no effect outside Resilience Hub.
     * + This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
     * + To update application version with new `physicalResourceID`, you must call `ResolveAppVersionResources` API.
     */
    public suspend fun updateAppVersionResource(input: UpdateAppVersionResourceRequest): UpdateAppVersionResourceResponse

    /**
     * Updates a resiliency policy.
     *
     * Resilience Hub allows you to provide a value of zero for `rtoInSecs` and `rpoInSecs` of your resiliency policy. But, while assessing your application, the lowest possible assessment result is near zero. Hence, if you provide value zero for `rtoInSecs` and `rpoInSecs`, the estimated workload RTO and estimated workload RPO result will be near zero and the **Compliance status** for your application will be set to **Policy breached**.
     */
    public suspend fun updateResiliencyPolicy(input: UpdateResiliencyPolicyRequest): UpdateResiliencyPolicyResponse
}

/**
 * Create a copy of the client with one or more configuration values overridden.
 * This method allows the caller to perform scoped config overrides for one or more client operations.
 *
 * Any resources created on your behalf will be shared between clients, and will only be closed when ALL clients using them are closed.
 * If you provide a resource (e.g. [HttpClientEngine]) to the SDK, you are responsible for managing the lifetime of that resource.
 */
public fun ResiliencehubClient.withConfig(block: ResiliencehubClient.Config.Builder.() -> Unit): ResiliencehubClient {
    val newConfig = config.toBuilder().apply(block).build()
    return DefaultResiliencehubClient(newConfig)
}

/**
 * Accepts the resource grouping recommendations suggested by Resilience Hub for your application.
 */
public suspend inline fun ResiliencehubClient.acceptResourceGroupingRecommendations(crossinline block: AcceptResourceGroupingRecommendationsRequest.Builder.() -> Unit): AcceptResourceGroupingRecommendationsResponse = acceptResourceGroupingRecommendations(AcceptResourceGroupingRecommendationsRequest.Builder().apply(block).build())

/**
 * Adds the source of resource-maps to the draft version of an application. During assessment, Resilience Hub will use these resource-maps to resolve the latest physical ID for each resource in the application template. For more information about different types of resources supported by Resilience Hub and how to add them in your application, see [Step 2: How is your application managed?](https://docs.aws.amazon.com/resilience-hub/latest/userguide/how-app-manage.html) in the Resilience Hub User Guide.
 */
public suspend inline fun ResiliencehubClient.addDraftAppVersionResourceMappings(crossinline block: AddDraftAppVersionResourceMappingsRequest.Builder.() -> Unit): AddDraftAppVersionResourceMappingsResponse = addDraftAppVersionResourceMappings(AddDraftAppVersionResourceMappingsRequest.Builder().apply(block).build())

/**
 * Enables you to include or exclude one or more operational recommendations.
 */
public suspend inline fun ResiliencehubClient.batchUpdateRecommendationStatus(crossinline block: BatchUpdateRecommendationStatusRequest.Builder.() -> Unit): BatchUpdateRecommendationStatusResponse = batchUpdateRecommendationStatus(BatchUpdateRecommendationStatusRequest.Builder().apply(block).build())

/**
 * Creates an Resilience Hub application. An Resilience Hub application is a collection of Amazon Web Services resources structured to prevent and recover Amazon Web Services application disruptions. To describe a Resilience Hub application, you provide an application name, resources from one or more CloudFormation stacks, Resource Groups, Terraform state files, AppRegistry applications, and an appropriate resiliency policy. In addition, you can also add resources that are located on Amazon Elastic Kubernetes Service (Amazon EKS) clusters as optional resources. For more information about the number of resources supported per application, see [Service quotas](https://docs.aws.amazon.com/general/latest/gr/resiliencehub.html#limits_resiliencehub).
 *
 * After you create an Resilience Hub application, you publish it so that you can run a resiliency assessment on it. You can then use recommendations from the assessment to improve resiliency by running another assessment, comparing results, and then iterating the process until you achieve your goals for recovery time objective (RTO) and recovery point objective (RPO).
 */
public suspend inline fun ResiliencehubClient.createApp(crossinline block: CreateAppRequest.Builder.() -> Unit): CreateAppResponse = createApp(CreateAppRequest.Builder().apply(block).build())

/**
 * Creates a new Application Component in the Resilience Hub application.
 *
 * This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
 */
public suspend inline fun ResiliencehubClient.createAppVersionAppComponent(crossinline block: CreateAppVersionAppComponentRequest.Builder.() -> Unit): CreateAppVersionAppComponentResponse = createAppVersionAppComponent(CreateAppVersionAppComponentRequest.Builder().apply(block).build())

/**
 * Adds a resource to the Resilience Hub application and assigns it to the specified Application Components. If you specify a new Application Component, Resilience Hub will automatically create the Application Component.
 *
 * + This action has no effect outside Resilience Hub.
 * + This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
 * + To update application version with new `physicalResourceID`, you must call `ResolveAppVersionResources` API.
 */
public suspend inline fun ResiliencehubClient.createAppVersionResource(crossinline block: CreateAppVersionResourceRequest.Builder.() -> Unit): CreateAppVersionResourceResponse = createAppVersionResource(CreateAppVersionResourceRequest.Builder().apply(block).build())

/**
 * Creates a new recommendation template for the Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.createRecommendationTemplate(crossinline block: CreateRecommendationTemplateRequest.Builder.() -> Unit): CreateRecommendationTemplateResponse = createRecommendationTemplate(CreateRecommendationTemplateRequest.Builder().apply(block).build())

/**
 * Creates a resiliency policy for an application.
 *
 * Resilience Hub allows you to provide a value of zero for `rtoInSecs` and `rpoInSecs` of your resiliency policy. But, while assessing your application, the lowest possible assessment result is near zero. Hence, if you provide value zero for `rtoInSecs` and `rpoInSecs`, the estimated workload RTO and estimated workload RPO result will be near zero and the **Compliance status** for your application will be set to **Policy breached**.
 */
public suspend inline fun ResiliencehubClient.createResiliencyPolicy(crossinline block: CreateResiliencyPolicyRequest.Builder.() -> Unit): CreateResiliencyPolicyResponse = createResiliencyPolicy(CreateResiliencyPolicyRequest.Builder().apply(block).build())

/**
 * Deletes an Resilience Hub application. This is a destructive action that can't be undone.
 */
public suspend inline fun ResiliencehubClient.deleteApp(crossinline block: DeleteAppRequest.Builder.() -> Unit): DeleteAppResponse = deleteApp(DeleteAppRequest.Builder().apply(block).build())

/**
 * Deletes an Resilience Hub application assessment. This is a destructive action that can't be undone.
 */
public suspend inline fun ResiliencehubClient.deleteAppAssessment(crossinline block: DeleteAppAssessmentRequest.Builder.() -> Unit): DeleteAppAssessmentResponse = deleteAppAssessment(DeleteAppAssessmentRequest.Builder().apply(block).build())

/**
 * Deletes the input source and all of its imported resources from the Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.deleteAppInputSource(crossinline block: DeleteAppInputSourceRequest.Builder.() -> Unit): DeleteAppInputSourceResponse = deleteAppInputSource(DeleteAppInputSourceRequest.Builder().apply(block).build())

/**
 * Deletes an Application Component from the Resilience Hub application.
 *
 * + This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
 * + You will not be able to delete an Application Component if it has resources associated with it.
 */
public suspend inline fun ResiliencehubClient.deleteAppVersionAppComponent(crossinline block: DeleteAppVersionAppComponentRequest.Builder.() -> Unit): DeleteAppVersionAppComponentResponse = deleteAppVersionAppComponent(DeleteAppVersionAppComponentRequest.Builder().apply(block).build())

/**
 * Deletes a resource from the Resilience Hub application.
 *
 * + You can only delete a manually added resource. To exclude non-manually added resources, use the `UpdateAppVersionResource` API.
 * + This action has no effect outside Resilience Hub.
 * + This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
 */
public suspend inline fun ResiliencehubClient.deleteAppVersionResource(crossinline block: DeleteAppVersionResourceRequest.Builder.() -> Unit): DeleteAppVersionResourceResponse = deleteAppVersionResource(DeleteAppVersionResourceRequest.Builder().apply(block).build())

/**
 * Deletes a recommendation template. This is a destructive action that can't be undone.
 */
public suspend inline fun ResiliencehubClient.deleteRecommendationTemplate(crossinline block: DeleteRecommendationTemplateRequest.Builder.() -> Unit): DeleteRecommendationTemplateResponse = deleteRecommendationTemplate(DeleteRecommendationTemplateRequest.Builder().apply(block).build())

/**
 * Deletes a resiliency policy. This is a destructive action that can't be undone.
 */
public suspend inline fun ResiliencehubClient.deleteResiliencyPolicy(crossinline block: DeleteResiliencyPolicyRequest.Builder.() -> Unit): DeleteResiliencyPolicyResponse = deleteResiliencyPolicy(DeleteResiliencyPolicyRequest.Builder().apply(block).build())

/**
 * Describes an Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.describeApp(crossinline block: DescribeAppRequest.Builder.() -> Unit): DescribeAppResponse = describeApp(DescribeAppRequest.Builder().apply(block).build())

/**
 * Describes an assessment for an Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.describeAppAssessment(crossinline block: DescribeAppAssessmentRequest.Builder.() -> Unit): DescribeAppAssessmentResponse = describeAppAssessment(DescribeAppAssessmentRequest.Builder().apply(block).build())

/**
 * Describes the Resilience Hub application version.
 */
public suspend inline fun ResiliencehubClient.describeAppVersion(crossinline block: DescribeAppVersionRequest.Builder.() -> Unit): DescribeAppVersionResponse = describeAppVersion(DescribeAppVersionRequest.Builder().apply(block).build())

/**
 * Describes an Application Component in the Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.describeAppVersionAppComponent(crossinline block: DescribeAppVersionAppComponentRequest.Builder.() -> Unit): DescribeAppVersionAppComponentResponse = describeAppVersionAppComponent(DescribeAppVersionAppComponentRequest.Builder().apply(block).build())

/**
 * Describes a resource of the Resilience Hub application.
 *
 * This API accepts only one of the following parameters to describe the resource:
 * + `resourceName`
 * + `logicalResourceId`
 * + `physicalResourceId` (Along with `physicalResourceId`, you can also provide `awsAccountId`, and `awsRegion`)
 */
public suspend inline fun ResiliencehubClient.describeAppVersionResource(crossinline block: DescribeAppVersionResourceRequest.Builder.() -> Unit): DescribeAppVersionResourceResponse = describeAppVersionResource(DescribeAppVersionResourceRequest.Builder().apply(block).build())

/**
 * Returns the resolution status for the specified resolution identifier for an application version. If `resolutionId` is not specified, the current resolution status is returned.
 */
public suspend inline fun ResiliencehubClient.describeAppVersionResourcesResolutionStatus(crossinline block: DescribeAppVersionResourcesResolutionStatusRequest.Builder.() -> Unit): DescribeAppVersionResourcesResolutionStatusResponse = describeAppVersionResourcesResolutionStatus(DescribeAppVersionResourcesResolutionStatusRequest.Builder().apply(block).build())

/**
 * Describes details about an Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.describeAppVersionTemplate(crossinline block: DescribeAppVersionTemplateRequest.Builder.() -> Unit): DescribeAppVersionTemplateResponse = describeAppVersionTemplate(DescribeAppVersionTemplateRequest.Builder().apply(block).build())

/**
 * Describes the status of importing resources to an application version.
 *
 * If you get a 404 error with `ResourceImportStatusNotFoundAppMetadataException`, you must call `importResourcesToDraftAppVersion` after creating the application and before calling `describeDraftAppVersionResourcesImportStatus` to obtain the status.
 */
public suspend inline fun ResiliencehubClient.describeDraftAppVersionResourcesImportStatus(crossinline block: DescribeDraftAppVersionResourcesImportStatusRequest.Builder.() -> Unit): DescribeDraftAppVersionResourcesImportStatusResponse = describeDraftAppVersionResourcesImportStatus(DescribeDraftAppVersionResourcesImportStatusRequest.Builder().apply(block).build())

/**
 * Describes the metrics of the application configuration being exported.
 */
public suspend inline fun ResiliencehubClient.describeMetricsExport(crossinline block: DescribeMetricsExportRequest.Builder.() -> Unit): DescribeMetricsExportResponse = describeMetricsExport(DescribeMetricsExportRequest.Builder().apply(block).build())

/**
 * Describes a specified resiliency policy for an Resilience Hub application. The returned policy object includes creation time, data location constraints, the Amazon Resource Name (ARN) for the policy, tags, tier, and more.
 */
public suspend inline fun ResiliencehubClient.describeResiliencyPolicy(crossinline block: DescribeResiliencyPolicyRequest.Builder.() -> Unit): DescribeResiliencyPolicyResponse = describeResiliencyPolicy(DescribeResiliencyPolicyRequest.Builder().apply(block).build())

/**
 * Describes the resource grouping recommendation tasks run by Resilience Hub for your application.
 */
public suspend inline fun ResiliencehubClient.describeResourceGroupingRecommendationTask(crossinline block: DescribeResourceGroupingRecommendationTaskRequest.Builder.() -> Unit): DescribeResourceGroupingRecommendationTaskResponse = describeResourceGroupingRecommendationTask(DescribeResourceGroupingRecommendationTaskRequest.Builder().apply(block).build())

/**
 * Imports resources to Resilience Hub application draft version from different input sources. For more information about the input sources supported by Resilience Hub, see [Discover the structure and describe your Resilience Hub application](https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html).
 */
public suspend inline fun ResiliencehubClient.importResourcesToDraftAppVersion(crossinline block: ImportResourcesToDraftAppVersionRequest.Builder.() -> Unit): ImportResourcesToDraftAppVersionResponse = importResourcesToDraftAppVersion(ImportResourcesToDraftAppVersionRequest.Builder().apply(block).build())

/**
 * Lists the alarm recommendations for an Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.listAlarmRecommendations(crossinline block: ListAlarmRecommendationsRequest.Builder.() -> Unit): ListAlarmRecommendationsResponse = listAlarmRecommendations(ListAlarmRecommendationsRequest.Builder().apply(block).build())

/**
 * List of compliance drifts that were detected while running an assessment.
 */
public suspend inline fun ResiliencehubClient.listAppAssessmentComplianceDrifts(crossinline block: ListAppAssessmentComplianceDriftsRequest.Builder.() -> Unit): ListAppAssessmentComplianceDriftsResponse = listAppAssessmentComplianceDrifts(ListAppAssessmentComplianceDriftsRequest.Builder().apply(block).build())

/**
 * List of resource drifts that were detected while running an assessment.
 */
public suspend inline fun ResiliencehubClient.listAppAssessmentResourceDrifts(crossinline block: ListAppAssessmentResourceDriftsRequest.Builder.() -> Unit): ListAppAssessmentResourceDriftsResponse = listAppAssessmentResourceDrifts(ListAppAssessmentResourceDriftsRequest.Builder().apply(block).build())

/**
 * Lists the assessments for an Resilience Hub application. You can use request parameters to refine the results for the response object.
 */
public suspend inline fun ResiliencehubClient.listAppAssessments(crossinline block: ListAppAssessmentsRequest.Builder.() -> Unit): ListAppAssessmentsResponse = listAppAssessments(ListAppAssessmentsRequest.Builder().apply(block).build())

/**
 * Lists the compliances for an Resilience Hub Application Component.
 */
public suspend inline fun ResiliencehubClient.listAppComponentCompliances(crossinline block: ListAppComponentCompliancesRequest.Builder.() -> Unit): ListAppComponentCompliancesResponse = listAppComponentCompliances(ListAppComponentCompliancesRequest.Builder().apply(block).build())

/**
 * Lists the recommendations for an Resilience Hub Application Component.
 */
public suspend inline fun ResiliencehubClient.listAppComponentRecommendations(crossinline block: ListAppComponentRecommendationsRequest.Builder.() -> Unit): ListAppComponentRecommendationsResponse = listAppComponentRecommendations(ListAppComponentRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists all the input sources of the Resilience Hub application. For more information about the input sources supported by Resilience Hub, see [Discover the structure and describe your Resilience Hub application](https://docs.aws.amazon.com/resilience-hub/latest/userguide/discover-structure.html).
 */
public suspend inline fun ResiliencehubClient.listAppInputSources(crossinline block: ListAppInputSourcesRequest.Builder.() -> Unit): ListAppInputSourcesResponse = listAppInputSources(ListAppInputSourcesRequest.Builder().apply(block).build())

/**
 * Lists all the Application Components in the Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.listAppVersionAppComponents(crossinline block: ListAppVersionAppComponentsRequest.Builder.() -> Unit): ListAppVersionAppComponentsResponse = listAppVersionAppComponents(ListAppVersionAppComponentsRequest.Builder().apply(block).build())

/**
 * Lists how the resources in an application version are mapped/sourced from. Mappings can be physical resource identifiers, CloudFormation stacks, resource-groups, or an application registry app.
 */
public suspend inline fun ResiliencehubClient.listAppVersionResourceMappings(crossinline block: ListAppVersionResourceMappingsRequest.Builder.() -> Unit): ListAppVersionResourceMappingsResponse = listAppVersionResourceMappings(ListAppVersionResourceMappingsRequest.Builder().apply(block).build())

/**
 * Lists all the resources in an Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.listAppVersionResources(crossinline block: ListAppVersionResourcesRequest.Builder.() -> Unit): ListAppVersionResourcesResponse = listAppVersionResources(ListAppVersionResourcesRequest.Builder().apply(block).build())

/**
 * Lists the different versions for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listAppVersions(crossinline block: ListAppVersionsRequest.Builder.() -> Unit): ListAppVersionsResponse = listAppVersions(ListAppVersionsRequest.Builder().apply(block).build())

/**
 * Lists your Resilience Hub applications.
 *
 * You can filter applications using only one filter at a time or without using any filter. If you try to filter applications using multiple filters, you will get the following error:
 *
 * `An error occurred (ValidationException) when calling the ListApps operation: Only one filter is supported for this operation.`
 */
public suspend inline fun ResiliencehubClient.listApps(crossinline block: ListAppsRequest.Builder.() -> Unit): ListAppsResponse = listApps(ListAppsRequest.Builder().apply(block).build())

/**
 * Lists the metrics that can be exported.
 */
public suspend inline fun ResiliencehubClient.listMetrics(crossinline block: ListMetricsRequest.Builder.() -> Unit): ListMetricsResponse = listMetrics(ListMetricsRequest.Builder().apply(block).build())

/**
 * Lists the recommendation templates for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listRecommendationTemplates(crossinline block: ListRecommendationTemplatesRequest.Builder.() -> Unit): ListRecommendationTemplatesResponse = listRecommendationTemplates(ListRecommendationTemplatesRequest.Builder().apply(block).build())

/**
 * Lists the resiliency policies for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listResiliencyPolicies(crossinline block: ListResiliencyPoliciesRequest.Builder.() -> Unit): ListResiliencyPoliciesResponse = listResiliencyPolicies(ListResiliencyPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the resource grouping recommendations suggested by Resilience Hub for your application.
 */
public suspend inline fun ResiliencehubClient.listResourceGroupingRecommendations(crossinline block: ListResourceGroupingRecommendationsRequest.Builder.() -> Unit): ListResourceGroupingRecommendationsResponse = listResourceGroupingRecommendations(ListResourceGroupingRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists the standard operating procedure (SOP) recommendations for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listSopRecommendations(crossinline block: ListSopRecommendationsRequest.Builder.() -> Unit): ListSopRecommendationsResponse = listSopRecommendations(ListSopRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists the suggested resiliency policies for the Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listSuggestedResiliencyPolicies(crossinline block: ListSuggestedResiliencyPoliciesRequest.Builder.() -> Unit): ListSuggestedResiliencyPoliciesResponse = listSuggestedResiliencyPolicies(ListSuggestedResiliencyPoliciesRequest.Builder().apply(block).build())

/**
 * Lists the tags for your resources in your Resilience Hub applications.
 */
public suspend inline fun ResiliencehubClient.listTagsForResource(crossinline block: ListTagsForResourceRequest.Builder.() -> Unit): ListTagsForResourceResponse = listTagsForResource(ListTagsForResourceRequest.Builder().apply(block).build())

/**
 * Lists the test recommendations for the Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.listTestRecommendations(crossinline block: ListTestRecommendationsRequest.Builder.() -> Unit): ListTestRecommendationsResponse = listTestRecommendations(ListTestRecommendationsRequest.Builder().apply(block).build())

/**
 * Lists the resources that are not currently supported in Resilience Hub. An unsupported resource is a resource that exists in the object that was used to create an app, but is not supported by Resilience Hub.
 */
public suspend inline fun ResiliencehubClient.listUnsupportedAppVersionResources(crossinline block: ListUnsupportedAppVersionResourcesRequest.Builder.() -> Unit): ListUnsupportedAppVersionResourcesResponse = listUnsupportedAppVersionResources(ListUnsupportedAppVersionResourcesRequest.Builder().apply(block).build())

/**
 * Publishes a new version of a specific Resilience Hub application.
 */
public suspend inline fun ResiliencehubClient.publishAppVersion(crossinline block: PublishAppVersionRequest.Builder.() -> Unit): PublishAppVersionResponse = publishAppVersion(PublishAppVersionRequest.Builder().apply(block).build())

/**
 * Adds or updates the app template for an Resilience Hub application draft version.
 */
public suspend inline fun ResiliencehubClient.putDraftAppVersionTemplate(crossinline block: PutDraftAppVersionTemplateRequest.Builder.() -> Unit): PutDraftAppVersionTemplateResponse = putDraftAppVersionTemplate(PutDraftAppVersionTemplateRequest.Builder().apply(block).build())

/**
 * Rejects resource grouping recommendations.
 */
public suspend inline fun ResiliencehubClient.rejectResourceGroupingRecommendations(crossinline block: RejectResourceGroupingRecommendationsRequest.Builder.() -> Unit): RejectResourceGroupingRecommendationsResponse = rejectResourceGroupingRecommendations(RejectResourceGroupingRecommendationsRequest.Builder().apply(block).build())

/**
 * Removes resource mappings from a draft application version.
 */
public suspend inline fun ResiliencehubClient.removeDraftAppVersionResourceMappings(crossinline block: RemoveDraftAppVersionResourceMappingsRequest.Builder.() -> Unit): RemoveDraftAppVersionResourceMappingsResponse = removeDraftAppVersionResourceMappings(RemoveDraftAppVersionResourceMappingsRequest.Builder().apply(block).build())

/**
 * Resolves the resources for an application version.
 */
public suspend inline fun ResiliencehubClient.resolveAppVersionResources(crossinline block: ResolveAppVersionResourcesRequest.Builder.() -> Unit): ResolveAppVersionResourcesResponse = resolveAppVersionResources(ResolveAppVersionResourcesRequest.Builder().apply(block).build())

/**
 * Creates a new application assessment for an application.
 */
public suspend inline fun ResiliencehubClient.startAppAssessment(crossinline block: StartAppAssessmentRequest.Builder.() -> Unit): StartAppAssessmentResponse = startAppAssessment(StartAppAssessmentRequest.Builder().apply(block).build())

/**
 * Initiates the export task of metrics.
 */
public suspend inline fun ResiliencehubClient.startMetricsExport(crossinline block: StartMetricsExportRequest.Builder.() -> Unit): StartMetricsExportResponse = startMetricsExport(StartMetricsExportRequest.Builder().apply(block).build())

/**
 * Starts grouping recommendation task.
 */
public suspend inline fun ResiliencehubClient.startResourceGroupingRecommendationTask(crossinline block: StartResourceGroupingRecommendationTaskRequest.Builder.() -> Unit): StartResourceGroupingRecommendationTaskResponse = startResourceGroupingRecommendationTask(StartResourceGroupingRecommendationTaskRequest.Builder().apply(block).build())

/**
 * Applies one or more tags to a resource.
 */
public suspend inline fun ResiliencehubClient.tagResource(crossinline block: TagResourceRequest.Builder.() -> Unit): TagResourceResponse = tagResource(TagResourceRequest.Builder().apply(block).build())

/**
 * Removes one or more tags from a resource.
 */
public suspend inline fun ResiliencehubClient.untagResource(crossinline block: UntagResourceRequest.Builder.() -> Unit): UntagResourceResponse = untagResource(UntagResourceRequest.Builder().apply(block).build())

/**
 * Updates an application.
 */
public suspend inline fun ResiliencehubClient.updateApp(crossinline block: UpdateAppRequest.Builder.() -> Unit): UpdateAppResponse = updateApp(UpdateAppRequest.Builder().apply(block).build())

/**
 * Updates the Resilience Hub application version.
 *
 * This API updates the Resilience Hub application draft version. To use this information for running resiliency assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
 */
public suspend inline fun ResiliencehubClient.updateAppVersion(crossinline block: UpdateAppVersionRequest.Builder.() -> Unit): UpdateAppVersionResponse = updateAppVersion(UpdateAppVersionRequest.Builder().apply(block).build())

/**
 * Updates an existing Application Component in the Resilience Hub application.
 *
 * This API updates the Resilience Hub application draft version. To use this Application Component for running assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
 */
public suspend inline fun ResiliencehubClient.updateAppVersionAppComponent(crossinline block: UpdateAppVersionAppComponentRequest.Builder.() -> Unit): UpdateAppVersionAppComponentResponse = updateAppVersionAppComponent(UpdateAppVersionAppComponentRequest.Builder().apply(block).build())

/**
 * Updates the resource details in the Resilience Hub application.
 *
 * + This action has no effect outside Resilience Hub.
 * + This API updates the Resilience Hub application draft version. To use this resource for running resiliency assessments, you must publish the Resilience Hub application using the `PublishAppVersion` API.
 * + To update application version with new `physicalResourceID`, you must call `ResolveAppVersionResources` API.
 */
public suspend inline fun ResiliencehubClient.updateAppVersionResource(crossinline block: UpdateAppVersionResourceRequest.Builder.() -> Unit): UpdateAppVersionResourceResponse = updateAppVersionResource(UpdateAppVersionResourceRequest.Builder().apply(block).build())

/**
 * Updates a resiliency policy.
 *
 * Resilience Hub allows you to provide a value of zero for `rtoInSecs` and `rpoInSecs` of your resiliency policy. But, while assessing your application, the lowest possible assessment result is near zero. Hence, if you provide value zero for `rtoInSecs` and `rpoInSecs`, the estimated workload RTO and estimated workload RPO result will be near zero and the **Compliance status** for your application will be set to **Policy breached**.
 */
public suspend inline fun ResiliencehubClient.updateResiliencyPolicy(crossinline block: UpdateResiliencyPolicyRequest.Builder.() -> Unit): UpdateResiliencyPolicyResponse = updateResiliencyPolicy(UpdateResiliencyPolicyRequest.Builder().apply(block).build())
