// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.serde

import aws.sdk.kotlin.services.resiliencehub.model.ResiliencehubException
import aws.sdk.kotlin.services.resiliencehub.model.ResolveAppVersionResourcesResponse
import aws.sdk.kotlin.services.resiliencehub.model.ResourceResolutionStatusType
import aws.smithy.kotlin.runtime.awsprotocol.json.RestJsonErrorDeserializer
import aws.smithy.kotlin.runtime.awsprotocol.setAseErrorMetadata
import aws.smithy.kotlin.runtime.awsprotocol.withPayload
import aws.smithy.kotlin.runtime.http.HttpCall
import aws.smithy.kotlin.runtime.http.isSuccess
import aws.smithy.kotlin.runtime.http.operation.HttpDeserializer
import aws.smithy.kotlin.runtime.operation.ExecutionContext
import aws.smithy.kotlin.runtime.serde.SdkFieldDescriptor
import aws.smithy.kotlin.runtime.serde.SdkObjectDescriptor
import aws.smithy.kotlin.runtime.serde.SerialKind
import aws.smithy.kotlin.runtime.serde.asSdkSerializable
import aws.smithy.kotlin.runtime.serde.deserializeList
import aws.smithy.kotlin.runtime.serde.deserializeMap
import aws.smithy.kotlin.runtime.serde.deserializeStruct
import aws.smithy.kotlin.runtime.serde.field
import aws.smithy.kotlin.runtime.serde.json.JsonDeserializer
import aws.smithy.kotlin.runtime.serde.json.JsonSerialName
import aws.smithy.kotlin.runtime.serde.serializeList
import aws.smithy.kotlin.runtime.serde.serializeMap
import aws.smithy.kotlin.runtime.serde.serializeStruct


internal class ResolveAppVersionResourcesOperationDeserializer: HttpDeserializer.NonStreaming<ResolveAppVersionResourcesResponse> {

    override fun deserialize(context: ExecutionContext, call: HttpCall, payload: ByteArray?): ResolveAppVersionResourcesResponse {
        val response = call.response
        if (!response.status.isSuccess()) {
            throwResolveAppVersionResourcesError(context, call, payload)
        }
        val builder = ResolveAppVersionResourcesResponse.Builder()

        if (payload != null) {
            deserializeResolveAppVersionResourcesOperationBody(builder, payload)
        }
        builder.correctErrors()
        return builder.build()
    }
}

private fun throwResolveAppVersionResourcesError(context: ExecutionContext, call: HttpCall, payload: ByteArray?): kotlin.Nothing {
    val wrappedResponse = call.response.withPayload(payload)
    val wrappedCall = call.copy(response = wrappedResponse)

    val errorDetails = try {
        RestJsonErrorDeserializer.deserialize(call.response.headers, payload)
    } catch (ex: Exception) {
        throw ResiliencehubException("Failed to parse response as 'restJson1' error", ex).also {
            setAseErrorMetadata(it, wrappedCall.response, null)
        }
    }

    val ex = when(errorDetails.code) {
        "ThrottlingException" -> ThrottlingExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "AccessDeniedException" -> AccessDeniedExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ResourceNotFoundException" -> ResourceNotFoundExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ConflictException" -> ConflictExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "ValidationException" -> ValidationExceptionDeserializer().deserialize(context, wrappedCall, payload)
        "InternalServerException" -> InternalServerExceptionDeserializer().deserialize(context, wrappedCall, payload)
        else -> ResiliencehubException(errorDetails.message)
    }

    setAseErrorMetadata(ex, wrappedResponse, errorDetails)
    throw ex
}

private fun deserializeResolveAppVersionResourcesOperationBody(builder: ResolveAppVersionResourcesResponse.Builder, payload: ByteArray) {
    val deserializer = JsonDeserializer(payload)
    val APPARN_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appArn"))
    val APPVERSION_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("appVersion"))
    val RESOLUTIONID_DESCRIPTOR = SdkFieldDescriptor(SerialKind.String, JsonSerialName("resolutionId"))
    val STATUS_DESCRIPTOR = SdkFieldDescriptor(SerialKind.Enum, JsonSerialName("status"))
    val OBJ_DESCRIPTOR = SdkObjectDescriptor.build {
        field(APPARN_DESCRIPTOR)
        field(APPVERSION_DESCRIPTOR)
        field(RESOLUTIONID_DESCRIPTOR)
        field(STATUS_DESCRIPTOR)
    }

    deserializer.deserializeStruct(OBJ_DESCRIPTOR) {
        loop@while (true) {
            when (findNextFieldIndex()) {
                APPARN_DESCRIPTOR.index -> builder.appArn = deserializeString()
                APPVERSION_DESCRIPTOR.index -> builder.appVersion = deserializeString()
                RESOLUTIONID_DESCRIPTOR.index -> builder.resolutionId = deserializeString()
                STATUS_DESCRIPTOR.index -> builder.status = deserializeString().let { ResourceResolutionStatusType.fromValue(it) }
                null -> break@loop
                else -> skipValue()
            }
        }
    }
}
