// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAppVersionResourceRequest private constructor(builder: Builder) {
    /**
     * Currently, there is no supported additional information for resources.
     */
    public val additionalInfo: Map<String, List<String>>? = builder.additionalInfo
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.
     */
    public val appComponents: List<String>? = builder.appComponents
    /**
     * Amazon Web Services account that owns the physical resource.
     */
    public val awsAccountId: kotlin.String? = builder.awsAccountId
    /**
     * Amazon Web Services region that owns the physical resource.
     */
    public val awsRegion: kotlin.String? = builder.awsRegion
    /**
     * Indicates if a resource is excluded from an Resilience Hub application.
     *
     * You can exclude only imported resources from an Resilience Hub application.
     */
    public val excluded: kotlin.Boolean? = builder.excluded
    /**
     * Logical identifier of the resource.
     */
    public val logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = builder.logicalResourceId
    /**
     * Physical identifier of the resource.
     */
    public val physicalResourceId: kotlin.String? = builder.physicalResourceId
    /**
     * Name of the resource.
     */
    public val resourceName: kotlin.String? = builder.resourceName
    /**
     * Type of resource.
     */
    public val resourceType: kotlin.String? = builder.resourceType

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionResourceRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAppVersionResourceRequest(")
        append("additionalInfo=$additionalInfo,")
        append("appArn=$appArn,")
        append("appComponents=$appComponents,")
        append("awsAccountId=$awsAccountId,")
        append("awsRegion=$awsRegion,")
        append("excluded=$excluded,")
        append("logicalResourceId=$logicalResourceId,")
        append("physicalResourceId=$physicalResourceId,")
        append("resourceName=$resourceName,")
        append("resourceType=$resourceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = additionalInfo?.hashCode() ?: 0
        result = 31 * result + (appArn.hashCode())
        result = 31 * result + (appComponents?.hashCode() ?: 0)
        result = 31 * result + (awsAccountId?.hashCode() ?: 0)
        result = 31 * result + (awsRegion?.hashCode() ?: 0)
        result = 31 * result + (excluded?.hashCode() ?: 0)
        result = 31 * result + (logicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (physicalResourceId?.hashCode() ?: 0)
        result = 31 * result + (resourceName?.hashCode() ?: 0)
        result = 31 * result + (resourceType?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAppVersionResourceRequest

        if (additionalInfo != other.additionalInfo) return false
        if (appArn != other.appArn) return false
        if (appComponents != other.appComponents) return false
        if (awsAccountId != other.awsAccountId) return false
        if (awsRegion != other.awsRegion) return false
        if (excluded != other.excluded) return false
        if (logicalResourceId != other.logicalResourceId) return false
        if (physicalResourceId != other.physicalResourceId) return false
        if (resourceName != other.resourceName) return false
        if (resourceType != other.resourceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionResourceRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Currently, there is no supported additional information for resources.
         */
        public var additionalInfo: Map<String, List<String>>? = null
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * List of Application Components that this resource belongs to. If an Application Component is not part of the Resilience Hub application, it will be added.
         */
        public var appComponents: List<String>? = null
        /**
         * Amazon Web Services account that owns the physical resource.
         */
        public var awsAccountId: kotlin.String? = null
        /**
         * Amazon Web Services region that owns the physical resource.
         */
        public var awsRegion: kotlin.String? = null
        /**
         * Indicates if a resource is excluded from an Resilience Hub application.
         *
         * You can exclude only imported resources from an Resilience Hub application.
         */
        public var excluded: kotlin.Boolean? = null
        /**
         * Logical identifier of the resource.
         */
        public var logicalResourceId: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId? = null
        /**
         * Physical identifier of the resource.
         */
        public var physicalResourceId: kotlin.String? = null
        /**
         * Name of the resource.
         */
        public var resourceName: kotlin.String? = null
        /**
         * Type of resource.
         */
        public var resourceType: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionResourceRequest) : this() {
            this.additionalInfo = x.additionalInfo
            this.appArn = x.appArn
            this.appComponents = x.appComponents
            this.awsAccountId = x.awsAccountId
            this.awsRegion = x.awsRegion
            this.excluded = x.excluded
            this.logicalResourceId = x.logicalResourceId
            this.physicalResourceId = x.physicalResourceId
            this.resourceName = x.resourceName
            this.resourceType = x.resourceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppVersionResourceRequest = UpdateAppVersionResourceRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId] inside the given [block]
         */
        public fun logicalResourceId(block: aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.Builder.() -> kotlin.Unit) {
            this.logicalResourceId = aws.sdk.kotlin.services.resiliencehub.model.LogicalResourceId.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            return this
        }
    }
}
