// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

public class UpdateAppRequest private constructor(builder: Builder) {
    /**
     * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val appArn: kotlin.String = requireNotNull(builder.appArn) { "A non-null value must be provided for appArn" }
    /**
     * Assessment execution schedule with 'Daily' or 'Disabled' values.
     */
    public val assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = builder.assessmentSchedule
    /**
     * Specifies if the resiliency policy ARN should be cleared.
     */
    public val clearResiliencyPolicyArn: kotlin.Boolean? = builder.clearResiliencyPolicyArn
    /**
     * The optional description for an app.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for **Drift detected** and **Scheduled assessment failure** events.
     */
    public val eventSubscriptions: List<EventSubscription>? = builder.eventSubscriptions
    /**
     * Defines the roles and credentials that Resilience Hub would use while creating an application, importing its resources, and running an assessment.
     */
    public val permissionModel: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel? = builder.permissionModel
    /**
     * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
     */
    public val policyArn: kotlin.String? = builder.policyArn

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("UpdateAppRequest(")
        append("appArn=$appArn,")
        append("assessmentSchedule=$assessmentSchedule,")
        append("clearResiliencyPolicyArn=$clearResiliencyPolicyArn,")
        append("description=$description,")
        append("eventSubscriptions=$eventSubscriptions,")
        append("permissionModel=$permissionModel,")
        append("policyArn=$policyArn")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appArn.hashCode()
        result = 31 * result + (assessmentSchedule?.hashCode() ?: 0)
        result = 31 * result + (clearResiliencyPolicyArn?.hashCode() ?: 0)
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (eventSubscriptions?.hashCode() ?: 0)
        result = 31 * result + (permissionModel?.hashCode() ?: 0)
        result = 31 * result + (policyArn?.hashCode() ?: 0)
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as UpdateAppRequest

        if (appArn != other.appArn) return false
        if (assessmentSchedule != other.assessmentSchedule) return false
        if (clearResiliencyPolicyArn != other.clearResiliencyPolicyArn) return false
        if (description != other.description) return false
        if (eventSubscriptions != other.eventSubscriptions) return false
        if (permissionModel != other.permissionModel) return false
        if (policyArn != other.policyArn) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Amazon Resource Name (ARN) of the Resilience Hub application. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:app/`app-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var appArn: kotlin.String? = null
        /**
         * Assessment execution schedule with 'Daily' or 'Disabled' values.
         */
        public var assessmentSchedule: aws.sdk.kotlin.services.resiliencehub.model.AppAssessmentScheduleType? = null
        /**
         * Specifies if the resiliency policy ARN should be cleared.
         */
        public var clearResiliencyPolicyArn: kotlin.Boolean? = null
        /**
         * The optional description for an app.
         */
        public var description: kotlin.String? = null
        /**
         * The list of events you would like to subscribe and get notification for. Currently, Resilience Hub supports notifications only for **Drift detected** and **Scheduled assessment failure** events.
         */
        public var eventSubscriptions: List<EventSubscription>? = null
        /**
         * Defines the roles and credentials that Resilience Hub would use while creating an application, importing its resources, and running an assessment.
         */
        public var permissionModel: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel? = null
        /**
         * Amazon Resource Name (ARN) of the resiliency policy. The format for this ARN is: arn:`partition`:resiliencehub:`region`:`account`:resiliency-policy/`policy-id`. For more information about ARNs, see [ Amazon Resource Names (ARNs)](https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in the *Amazon Web Services General Reference* guide.
         */
        public var policyArn: kotlin.String? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest) : this() {
            this.appArn = x.appArn
            this.assessmentSchedule = x.assessmentSchedule
            this.clearResiliencyPolicyArn = x.clearResiliencyPolicyArn
            this.description = x.description
            this.eventSubscriptions = x.eventSubscriptions
            this.permissionModel = x.permissionModel
            this.policyArn = x.policyArn
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.UpdateAppRequest = UpdateAppRequest(this)

        /**
         * construct an [aws.sdk.kotlin.services.resiliencehub.model.PermissionModel] inside the given [block]
         */
        public fun permissionModel(block: aws.sdk.kotlin.services.resiliencehub.model.PermissionModel.Builder.() -> kotlin.Unit) {
            this.permissionModel = aws.sdk.kotlin.services.resiliencehub.model.PermissionModel.invoke(block)
        }

        internal fun correctErrors(): Builder {
            if (appArn == null) appArn = ""
            return this
        }
    }
}
