// Code generated by smithy-kotlin-codegen. DO NOT EDIT!

package aws.sdk.kotlin.services.resiliencehub.model

import aws.smithy.kotlin.runtime.SdkDsl

/**
 * Defines a standard operating procedure (SOP) recommendation.
 */
public class SopRecommendation private constructor(builder: Builder) {
    /**
     * Name of the Application Component.
     */
    public val appComponentName: kotlin.String? = builder.appComponentName
    /**
     * Description of the SOP recommendation.
     */
    public val description: kotlin.String? = builder.description
    /**
     * The recommendation items.
     */
    public val items: List<RecommendationItem>? = builder.items
    /**
     * Name of the SOP recommendation.
     */
    public val name: kotlin.String? = builder.name
    /**
     * Prerequisite for the SOP recommendation.
     */
    public val prerequisite: kotlin.String? = builder.prerequisite
    /**
     * Identifier for the SOP recommendation.
     */
    public val recommendationId: kotlin.String = requireNotNull(builder.recommendationId) { "A non-null value must be provided for recommendationId" }
    /**
     * Status of the recommended standard operating procedure.
     */
    public val recommendationStatus: aws.sdk.kotlin.services.resiliencehub.model.RecommendationStatus? = builder.recommendationStatus
    /**
     * Reference identifier for the SOP recommendation.
     */
    public val referenceId: kotlin.String = requireNotNull(builder.referenceId) { "A non-null value must be provided for referenceId" }
    /**
     * The service type.
     */
    public val serviceType: aws.sdk.kotlin.services.resiliencehub.model.SopServiceType = requireNotNull(builder.serviceType) { "A non-null value must be provided for serviceType" }

    public companion object {
        public operator fun invoke(block: Builder.() -> kotlin.Unit): aws.sdk.kotlin.services.resiliencehub.model.SopRecommendation = Builder().apply(block).build()
    }

    override fun toString(): kotlin.String = buildString {
        append("SopRecommendation(")
        append("appComponentName=$appComponentName,")
        append("description=$description,")
        append("items=$items,")
        append("name=$name,")
        append("prerequisite=$prerequisite,")
        append("recommendationId=$recommendationId,")
        append("recommendationStatus=$recommendationStatus,")
        append("referenceId=$referenceId,")
        append("serviceType=$serviceType")
        append(")")
    }

    override fun hashCode(): kotlin.Int {
        var result = appComponentName?.hashCode() ?: 0
        result = 31 * result + (description?.hashCode() ?: 0)
        result = 31 * result + (items?.hashCode() ?: 0)
        result = 31 * result + (name?.hashCode() ?: 0)
        result = 31 * result + (prerequisite?.hashCode() ?: 0)
        result = 31 * result + (recommendationId.hashCode())
        result = 31 * result + (recommendationStatus?.hashCode() ?: 0)
        result = 31 * result + (referenceId.hashCode())
        result = 31 * result + (serviceType.hashCode())
        return result
    }

    override fun equals(other: kotlin.Any?): kotlin.Boolean {
        if (this === other) return true
        if (other == null || this::class != other::class) return false

        other as SopRecommendation

        if (appComponentName != other.appComponentName) return false
        if (description != other.description) return false
        if (items != other.items) return false
        if (name != other.name) return false
        if (prerequisite != other.prerequisite) return false
        if (recommendationId != other.recommendationId) return false
        if (recommendationStatus != other.recommendationStatus) return false
        if (referenceId != other.referenceId) return false
        if (serviceType != other.serviceType) return false

        return true
    }

    public inline fun copy(block: Builder.() -> kotlin.Unit = {}): aws.sdk.kotlin.services.resiliencehub.model.SopRecommendation = Builder(this).apply(block).build()

    @SdkDsl
    public class Builder {
        /**
         * Name of the Application Component.
         */
        public var appComponentName: kotlin.String? = null
        /**
         * Description of the SOP recommendation.
         */
        public var description: kotlin.String? = null
        /**
         * The recommendation items.
         */
        public var items: List<RecommendationItem>? = null
        /**
         * Name of the SOP recommendation.
         */
        public var name: kotlin.String? = null
        /**
         * Prerequisite for the SOP recommendation.
         */
        public var prerequisite: kotlin.String? = null
        /**
         * Identifier for the SOP recommendation.
         */
        public var recommendationId: kotlin.String? = null
        /**
         * Status of the recommended standard operating procedure.
         */
        public var recommendationStatus: aws.sdk.kotlin.services.resiliencehub.model.RecommendationStatus? = null
        /**
         * Reference identifier for the SOP recommendation.
         */
        public var referenceId: kotlin.String? = null
        /**
         * The service type.
         */
        public var serviceType: aws.sdk.kotlin.services.resiliencehub.model.SopServiceType? = null

        @PublishedApi
        internal constructor()
        @PublishedApi
        internal constructor(x: aws.sdk.kotlin.services.resiliencehub.model.SopRecommendation) : this() {
            this.appComponentName = x.appComponentName
            this.description = x.description
            this.items = x.items
            this.name = x.name
            this.prerequisite = x.prerequisite
            this.recommendationId = x.recommendationId
            this.recommendationStatus = x.recommendationStatus
            this.referenceId = x.referenceId
            this.serviceType = x.serviceType
        }

        @PublishedApi
        internal fun build(): aws.sdk.kotlin.services.resiliencehub.model.SopRecommendation = SopRecommendation(this)

        internal fun correctErrors(): Builder {
            if (recommendationId == null) recommendationId = ""
            if (referenceId == null) referenceId = ""
            if (serviceType == null) serviceType = SopServiceType.SdkUnknown("no value provided")
            return this
        }
    }
}
